/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class MekanismIntegration
extends AbstractIntegrationThread {
    MekanismIntegration() {
        super("Mekanism");
    }

    public String call() {
        try {
            this.FixCrusherRecipes(RecipeHandler.Recipe.CRUSHER.get());
            this.FixEnrichmentRecipes(RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get());
            this.FixChemicalInjectionRecipes(RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get());
            this.FixInfusionRecipes(RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "All the mekanisms were checked.";
    }

    private void FixCrusherRecipes(@Nonnull Map<ItemStackInput, CrusherRecipe> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, CrusherRecipe> correctRecipes = new HashMap<MachineInput, CrusherRecipe>(initialSize, 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<CrusherRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                CrusherRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                CrusherRecipe correctRecipe = mekanismRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E())) : (((ItemStackInput)correctRecipe.recipeInput).ingredient = ((ItemStackInput)correctRecipe.recipeInput).ingredient.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<CrusherRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet kindSet;
                CrusherRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    CrusherRecipe correctRecipe = mekanismRecipe.copy();
                    ((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }

    private void FixEnrichmentRecipes(@Nonnull HashMap<ItemStackInput, EnrichmentRecipe> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, EnrichmentRecipe> correctRecipes = new HashMap<MachineInput, EnrichmentRecipe>(initialSize, 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<EnrichmentRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                EnrichmentRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                EnrichmentRecipe correctRecipe = mekanismRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E())) : (((ItemStackInput)correctRecipe.recipeInput).ingredient = ((ItemStackInput)correctRecipe.recipeInput).ingredient.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<EnrichmentRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet kindSet;
                EnrichmentRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    EnrichmentRecipe correctRecipe = mekanismRecipe.copy();
                    ((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }

    private void FixChemicalInjectionRecipes(@Nonnull Map<AdvancedMachineInput, InjectionRecipe> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, InjectionRecipe> correctRecipes = new HashMap<MachineInput, InjectionRecipe>(initialSize, 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<InjectionRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                InjectionRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((AdvancedMachineInput)mekanismRecipe.recipeInput).itemStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                InjectionRecipe correctRecipe = mekanismRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((AdvancedMachineInput)correctRecipe.recipeInput).itemStack = inputContainer.getMainEntry(((AdvancedMachineInput)correctRecipe.recipeInput).itemStack.func_190916_E())) : (((AdvancedMachineInput)correctRecipe.recipeInput).itemStack = ((AdvancedMachineInput)correctRecipe.recipeInput).itemStack.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<InjectionRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet kindSet;
                InjectionRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((AdvancedMachineInput)mekanismRecipe.recipeInput).itemStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    InjectionRecipe correctRecipe = mekanismRecipe.copy();
                    ((AdvancedMachineInput)correctRecipe.recipeInput).itemStack = inputContainer.getMainEntry(((AdvancedMachineInput)correctRecipe.recipeInput).itemStack.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }

    private void FixInfusionRecipes(@Nonnull Map<InfusionInput, MetallurgicInfuserRecipe> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, MetallurgicInfuserRecipe> correctRecipes = new HashMap<MachineInput, MetallurgicInfuserRecipe>(initialSize, 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MetallurgicInfuserRecipe> infusionRecipeIterator = recipes.values().iterator();
            while (infusionRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                MachineRecipe infusionRecipe = (MachineRecipe)infusionRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((InfusionInput)infusionRecipe.recipeInput).inputStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)infusionRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)infusionRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)infusionRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                MetallurgicInfuserRecipe correctRecipe = (MetallurgicInfuserRecipe)infusionRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((InfusionInput)correctRecipe.recipeInput).inputStack = inputContainer.getMainEntry(((InfusionInput)correctRecipe.recipeInput).inputStack.func_190916_E())) : (((InfusionInput)correctRecipe.recipeInput).inputStack = ((InfusionInput)correctRecipe.recipeInput).inputStack.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                infusionRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MetallurgicInfuserRecipe> infusionRecipeIterator = recipes.values().iterator();
            while (infusionRecipeIterator.hasNext()) {
                TIntSet kindSet;
                MachineRecipe mekanismRecipe = (MachineRecipe)infusionRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((InfusionInput)mekanismRecipe.recipeInput).inputStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    MetallurgicInfuserRecipe correctRecipe = (MetallurgicInfuserRecipe)mekanismRecipe.copy();
                    ((InfusionInput)correctRecipe.recipeInput).inputStack = inputContainer.getMainEntry(((InfusionInput)correctRecipe.recipeInput).inputStack.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                infusionRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }
}

