/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.forge;

import bspkrs.treecapitator.Treecapitator;
import bspkrs.treecapitator.TreecapitatorMod;
import bspkrs.treecapitator.config.TCConfigHandler;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.ModulusBlockID;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ForgeEventHandler {
    private final Map<String, Boolean> playerSneakingMap = new ConcurrentHashMap<String, Boolean>(64);
    private final Map<CachedBreakSpeed, Float> breakSpeedCache = new ConcurrentHashMap<CachedBreakSpeed, Float>(64);

    @SubscribeEvent
    public void onBlockClicked(PlayerInteractEvent.LeftClickBlock event) {
        if (TreecapitatorMod.proxy.isEnabled() && !TCSettings.sneakAction.equalsIgnoreCase("none") && !event.getEntityPlayer().field_70170_p.func_175623_d(event.getPos())) {
            this.playerSneakingMap.put(event.getEntityPlayer().func_146103_bH().getName(), event.getEntityPlayer().func_70093_af());
        }
    }

    @SubscribeEvent
    public void getPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        TreeDefinition treeDef;
        ModulusBlockID blockID = new ModulusBlockID(event.getState(), 4);
        BlockPos pos = event.getPos();
        if (TreecapitatorMod.proxy.isEnabled() && (TreeRegistry.instance().isRegistered((BlockID)blockID) || TCSettings.allowAutoTreeDetection && TreeRegistry.canAutoDetect(event.getEntityPlayer().field_70170_p, event.getState().func_177230_c(), pos)) && Treecapitator.isBreakingPossible(event.getEntityPlayer(), event.getPos(), false) && (treeDef = TCSettings.allowAutoTreeDetection ? TreeRegistry.autoDetectTree(event.getEntityPlayer().field_70170_p, (BlockID)blockID, pos, TCSettings.allowDebugLogging) : TreeRegistry.instance().get((BlockID)blockID)) != null) {
            Boolean isSneaking = this.playerSneakingMap.get(event.getEntityPlayer().func_146103_bH().getName());
            boolean swappedSneak = (isSneaking == null || isSneaking.booleanValue() != event.getEntityPlayer().func_70093_af()) && isSneaking != null;
            CachedBreakSpeed cachedBreakSpeed = new CachedBreakSpeed(event, swappedSneak);
            Float newBreakSpeed = this.breakSpeedCache.get((Object)cachedBreakSpeed);
            if (newBreakSpeed == null) {
                if (!swappedSneak) {
                    if (TCSettings.treeHeightDecidesBreakSpeed) {
                        int height;
                        if (Treecapitator.isBreakingEnabled(event.getEntityPlayer()) && (height = Treecapitator.getTreeHeight(treeDef, event.getEntityPlayer().field_70170_p, pos, event.getEntityPlayer())) > 1) {
                            event.setNewSpeed(event.getOriginalSpeed() / ((float)height * TCSettings.treeHeightModifier));
                        }
                    } else if (Treecapitator.isBreakingEnabled(event.getEntityPlayer())) {
                        event.setNewSpeed(event.getOriginalSpeed() * treeDef.breakSpeedModifier());
                    }
                } else {
                    event.setNewSpeed(0.0f);
                }
                this.breakSpeedCache.put(cachedBreakSpeed, Float.valueOf(event.getNewSpeed()));
            } else {
                event.setNewSpeed(newBreakSpeed.floatValue());
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.BreakEvent event) {
        if (event.getState() != null && event.getWorld() != null && event.getPlayer() != null) {
            if (TreecapitatorMod.proxy.isEnabled() && !event.getWorld().field_72995_K) {
                ModulusBlockID blockID = new ModulusBlockID(event.getState(), 4);
                if ((TreeRegistry.instance().isRegistered((BlockID)blockID) || TCSettings.allowAutoTreeDetection && TreeRegistry.canAutoDetect(event.getWorld(), event.getState().func_177230_c(), event.getPos())) && Treecapitator.isBreakingPossible(event.getPlayer(), event.getPos(), TCSettings.allowDebugLogging)) {
                    BlockPos pos = event.getPos();
                    if (TreeRegistry.instance().trackTreeChopEventAt(pos)) {
                        TCLog.debug("BlockID " + blockID + " is a log.", new Object[0]);
                        TreeDefinition treeDef = TCSettings.allowAutoTreeDetection ? TreeRegistry.autoDetectTree(event.getWorld(), (BlockID)blockID, pos, TCSettings.allowDebugLogging) : TreeRegistry.instance().get((BlockID)blockID);
                        if (treeDef != null) {
                            new Treecapitator(event.getPlayer(), treeDef).onBlockHarvested(event.getWorld(), pos);
                        }
                        TreeRegistry.instance().endTreeChopEventAt(pos);
                    } else {
                        TCLog.debug("Previous chopping event detected for block @%s", pos.toString());
                    }
                }
            }
            this.cleanUpCaches(event.getPlayer());
            if (ModConfigRegistry.instance().isChanged()) {
                ModConfigRegistry.instance().writeChangesToConfig(TCConfigHandler.instance().getConfig());
            }
        }
    }

    public void cleanUpCaches(EntityPlayer player) {
        ArrayList<CachedBreakSpeed> toRemove = new ArrayList<CachedBreakSpeed>();
        for (CachedBreakSpeed bs : this.breakSpeedCache.keySet()) {
            if (!bs.getEntityPlayer().func_146103_bH().getName().equals(player.func_146103_bH().getName())) continue;
            toRemove.add(bs);
        }
        for (CachedBreakSpeed bs : toRemove) {
            this.breakSpeedCache.remove((Object)bs);
        }
        if (this.playerSneakingMap.containsKey(player.func_146103_bH().getName())) {
            this.playerSneakingMap.remove(player.func_146103_bH().getName());
        }
    }

    private class CachedBreakSpeed
    extends PlayerEvent.BreakSpeed {
        private final boolean isSneaking;
        private final boolean swappedSneak;

        public CachedBreakSpeed(PlayerEvent.BreakSpeed event, boolean swappedSneak) {
            super(event.getEntityPlayer(), event.getState(), event.getOriginalSpeed(), event.getPos());
            this.isSneaking = event.getEntityPlayer().func_70093_af();
            this.swappedSneak = swappedSneak;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedBreakSpeed)) {
                return false;
            }
            CachedBreakSpeed bs = (CachedBreakSpeed)((Object)o);
            ItemStack oItem = bs.getEntityPlayer().func_184614_ca();
            ItemStack thisItem = this.getEntityPlayer().func_184614_ca();
            return bs.getEntityPlayer().func_146103_bH().getName().equals(this.getEntityPlayer().func_146103_bH().getName()) && (oItem != null && oItem.func_77973_b() != null ? thisItem != null && thisItem.func_77973_b() != null && ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)thisItem.func_77973_b())).equals(Item.field_150901_e.func_177774_c((Object)oItem.func_77973_b())) : thisItem == null || thisItem.func_77973_b() == null) && ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)bs.getState().func_177230_c())).equals(Block.field_149771_c.func_177774_c((Object)this.getState().func_177230_c())) && bs.isSneaking == this.isSneaking && bs.swappedSneak == this.swappedSneak && bs.getState().func_177230_c().func_176201_c(bs.getState()) == this.getState().func_177230_c().func_176201_c(this.getState()) && bs.getOriginalSpeed() == this.getOriginalSpeed() && bs.getPos().equals((Object)this.getPos());
        }

        public int hashCode() {
            ItemStack thisItem = this.getEntityPlayer().func_184614_ca();
            HashFunction hf = Hashing.md5();
            Hasher h = hf.newHasher().putString((CharSequence)this.getEntityPlayer().func_146103_bH().getName(), Charsets.UTF_8).putString((CharSequence)((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.getState().func_177230_c())).toString(), Charsets.UTF_8).putBoolean(this.isSneaking).putBoolean(this.swappedSneak).putInt(this.getState().func_177230_c().func_176201_c(this.getState())).putFloat(this.getOriginalSpeed()).putInt(this.getPos().hashCode());
            if (thisItem != null && thisItem.func_77973_b() != null) {
                h.putString((CharSequence)((ResourceLocation)Item.field_150901_e.func_177774_c((Object)thisItem.func_77973_b())).toString(), Charsets.UTF_8).putInt(thisItem.func_77960_j());
            }
            return h.hash().hashCode();
        }
    }
}

