/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ToolRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.ModulusBlockID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class Treecapitator {
    private World world;
    private final EntityPlayer player;
    private BlockPos startPos;
    private ItemStack axe;
    private ItemStack shears;
    private final TreeDefinition treeDef;
    private final BlockID vineID;
    private float currentAxeDamage;
    private float currentShearsDamage = 0.0f;
    private int numLogsToBreak;
    private int numLogsBroken;
    private int numLeavesSheared;
    private float logDamageMultiplier;
    private float leafDamageMultiplier;
    private List<ItemStack> drops;
    private BlockPos dropPos;
    private boolean maxAllowed = false;

    public Treecapitator(EntityPlayer entityPlayer, TreeDefinition treeDef) {
        this.player = entityPlayer;
        this.treeDef = treeDef;
        this.vineID = new BlockID(Blocks.field_150395_bd);
        this.logDamageMultiplier = TCSettings.damageMultiplier;
        this.leafDamageMultiplier = TCSettings.damageMultiplier;
        this.numLogsToBreak = 0;
        this.numLogsBroken = 1;
        this.numLeavesSheared = 1;
    }

    public static boolean isBreakingPossible(EntityPlayer entityPlayer, BlockPos pos, boolean shouldLog) {
        ItemStack axe = entityPlayer.func_184614_ca();
        if (Treecapitator.isAxeItemEquipped(entityPlayer, pos) || !TCSettings.needItem) {
            if (!entityPlayer.field_71075_bZ.field_75098_d && TCSettings.allowItemDamage && axe != null && axe.func_77984_f() && (float)(axe.func_77958_k() - axe.func_77960_j()) <= TCSettings.damageMultiplier && !TCSettings.allowMoreBlocksThanDamage) {
                if (shouldLog) {
                    TCLog.debug("Chopping disabled due to axe durability.", new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (shouldLog) {
            TCLog.debug("Player does not have an axe equipped.", new Object[0]);
        }
        return false;
    }

    private boolean isBreakingPossible() {
        this.axe = this.player.func_184614_ca();
        if (this.isAxeItemEquipped() || !TCSettings.needItem) {
            if (!this.player.field_71075_bZ.field_75098_d && TCSettings.allowItemDamage && this.axe != null && this.axe.func_77984_f() && (float)(this.axe.func_77958_k() - this.axe.func_77960_j()) <= TCSettings.damageMultiplier && !TCSettings.allowMoreBlocksThanDamage) {
                TCLog.debug("Chopping disabled due to axe durability.", new Object[0]);
                return false;
            }
            return true;
        }
        TCLog.debug("Player does not have an axe equipped.", new Object[0]);
        return false;
    }

    private boolean isAxeItemEquipped() {
        ItemStack item = this.player.func_184614_ca();
        Enchantment enchantment = Enchantment.func_180305_b((String)"treecapitating");
        int enchantmentID = Enchantment.func_185258_b((Enchantment)enchantment);
        if (TCSettings.enableEnchantmentMode) {
            if (item != null && item.func_77948_v()) {
                for (int i = 0; i < item.func_77986_q().func_74745_c(); ++i) {
                    NBTTagCompound tag = item.func_77986_q().func_150305_b(i);
                    if (tag.func_74765_d("id") != enchantmentID) continue;
                    this.axe = item;
                    return true;
                }
            }
            this.axe = null;
            return false;
        }
        if (ToolRegistry.instance().isAxe(item)) {
            this.axe = item;
            return true;
        }
        this.axe = null;
        return false;
    }

    public static boolean isAxeItemEquipped(EntityPlayer entityPlayer, BlockPos pos) {
        ItemStack item = entityPlayer.func_184614_ca();
        Enchantment enchantment = Enchantment.func_180305_b((String)"treecapitating");
        int enchantmentID = Enchantment.func_185258_b((Enchantment)enchantment);
        if (TCSettings.enableEnchantmentMode) {
            int i;
            if (item != null && item.func_77948_v() && (i = 0) < item.func_77986_q().func_74745_c()) {
                NBTTagCompound tag = item.func_77986_q().func_150305_b(i);
                if (tag.func_74765_d("id") == enchantmentID) {
                    // empty if block
                }
                return true;
            }
            return false;
        }
        if (item != null && !ToolRegistry.instance().isAxe(item) && TCSettings.allowAutoAxeDetection) {
            ToolRegistry.autoDetectAxe(entityPlayer.field_70170_p, pos, item);
        }
        return ToolRegistry.instance().isAxe(item);
    }

    public static boolean isBreakingEnabled(EntityPlayer entityPlayer) {
        return (TCSettings.sneakAction.equalsIgnoreCase("none") || TCSettings.sneakAction.equalsIgnoreCase("disable") && !entityPlayer.func_70093_af() || TCSettings.sneakAction.equalsIgnoreCase("enable") && entityPlayer.func_70093_af()) && (!entityPlayer.field_71075_bZ.field_75098_d || !TCSettings.disableInCreative);
    }

    public static int getTreeHeight(TreeDefinition tree, World world, BlockPos pos, EntityPlayer entityPlayer) {
        BlockPos topLog;
        BlockPos startPos = pos;
        if (!tree.onlyDestroyUpwards()) {
            startPos = tree.useAdvancedTopLogLogic() ? Treecapitator.getBottomLog(tree.getLogList(), world, startPos, false) : Treecapitator.getBottomLogAtPos(tree.getLogList(), world, startPos, false);
        }
        BlockPos blockPos = topLog = tree.useAdvancedTopLogLogic() ? Treecapitator.getTopLog(tree.getLogList(), world, pos, false) : Treecapitator.getTopLogAtPos(tree.getLogList(), world, pos, false);
        if (!tree.allowSmartTreeDetection() || tree.getLeafList().size() == 0 || Treecapitator.hasXLeavesInDist(tree.getLeafList(), world, topLog, tree.maxLeafIDDist(), tree.minLeavesToID(), false)) {
            return topLog.func_177956_o() - startPos.func_177956_o() + 1;
        }
        return 1;
    }

    public void onBlockHarvested(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            TCLog.debug("In TreeCapitator.onBlockHarvested() " + pos.toString(), new Object[0]);
            this.world = world;
            this.dropPos = this.startPos = pos;
            this.drops = new ArrayList<ItemStack>();
            if (Treecapitator.isBreakingEnabled(this.player)) {
                BlockPos topLog = this.getTopLog(world, pos);
                if (!this.treeDef.allowSmartTreeDetection() || this.treeDef.getLeafList().size() == 0 || this.hasXLeavesInDist(world, topLog, this.treeDef.maxLeafIDDist(), this.treeDef.minLeavesToID())) {
                    if (this.isBreakingPossible()) {
                        this.doProceduralChop(pos);
                    }
                } else {
                    TCLog.debug("Could not identify tree.", new Object[0]);
                }
            } else {
                TCLog.debug("Tree Chopping is disabled due to player state or gamemode.", new Object[0]);
            }
        } else {
            TCLog.debug("World is remote, skipping TreeCapitator.onBlockHarvested().", new Object[0]);
        }
    }

    public void doProceduralChop(BlockPos pos) {
        long beginning = System.currentTimeMillis();
        TCLog.debug("Proceeding to chop tree...", new Object[0]);
        LinkedList<BlockPos> listFinal = new LinkedList<BlockPos>();
        TCLog.debug("Finding log blocks...", new Object[0]);
        long startTime = System.currentTimeMillis();
        LinkedList<BlockPos> logs = this.addLogs(this.world, pos);
        TCLog.debug("Log Discovery: %dms", System.currentTimeMillis() - startTime);
        if (logs.isEmpty() && this.maxAllowed) {
            return;
        }
        startTime = System.currentTimeMillis();
        this.addLogsAbove(this.world, pos, listFinal);
        TCLog.debug("Final Logs: %dms", System.currentTimeMillis() - startTime);
        TCLog.debug("Destroying %d log blocks...", logs.size());
        startTime = System.currentTimeMillis();
        this.destroyBlocks(this.world, logs);
        TCLog.debug("Log Destruction: %dms", System.currentTimeMillis() - startTime);
        if (this.numLogsBroken > 1) {
            TCLog.debug("Number of logs broken: %d", this.numLogsBroken);
        }
        if (TCSettings.destroyLeaves && this.treeDef.getLeafList().size() != 0) {
            TCLog.debug("Finding leaf blocks...", new Object[0]);
            ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
            startTime = System.currentTimeMillis();
            for (BlockPos BlockPos2 : listFinal) {
                this.addLeaves(this.world, BlockPos2, leaves);
            }
            TCLog.debug("Leaf Discovery: %dms", System.currentTimeMillis() - startTime);
            TCLog.debug("Destroying %d leaf blocks...", leaves.size());
            startTime = System.currentTimeMillis();
            this.destroyBlocksWithChance(this.world, leaves, 0.5f, this.hasShearsInHotbar(this.player));
            TCLog.debug("Leaf Destruction: %dms", System.currentTimeMillis() - startTime);
            if (this.numLeavesSheared > 1) {
                TCLog.debug("Number of leaves sheared: %d", this.numLeavesSheared);
            }
        }
        if (this.currentAxeDamage > 0.0f && this.axe != null) {
            this.currentAxeDamage = Math.round(this.currentAxeDamage);
            for (int i = 0; i < MathHelper.func_76141_d((float)this.currentAxeDamage); ++i) {
                this.axe.func_77973_b().func_179218_a(this.axe, this.world, this.world.func_180495_p(pos), pos, (EntityLivingBase)this.player);
            }
        }
        if (this.currentShearsDamage > 0.0f && this.shears != null) {
            this.currentShearsDamage = Math.round(this.currentShearsDamage);
            int i = 0;
            while ((double)i < Math.floor(this.currentShearsDamage)) {
                if (this.shears.func_77973_b().equals(Items.field_151097_aZ)) {
                    this.shears.func_77972_a(1, (EntityLivingBase)this.player);
                } else {
                    this.shears.func_77973_b().func_179218_a(this.shears, this.world, this.world.func_180495_p(pos), pos, (EntityLivingBase)this.player);
                }
                ++i;
            }
        }
        startTime = System.currentTimeMillis();
        if (TCSettings.stackDrops) {
            while (this.drops.size() > 0) {
                this.world.func_72838_d((Entity)new EntityItem(this.world, (double)this.dropPos.func_177958_n(), (double)this.dropPos.func_177956_o(), (double)this.dropPos.func_177952_p(), this.drops.remove(0)));
            }
        }
        TCLog.debug("Drops: %dms", System.currentTimeMillis() - startTime);
        TCLog.debug("Total: %dms", System.currentTimeMillis() - beginning);
    }

    public static List<BlockID> getLeavesForTree(World world, BlockID logID, BlockPos pos, boolean shouldLog) {
        ArrayList<BlockID> leaves = new ArrayList();
        ArrayList<BlockID> logs = new ArrayList<BlockID>();
        logs.add(logID);
        BlockPos topLogPos = TCSettings.useAdvancedTopLogLogic ? Treecapitator.getTopLog(logs, world, pos, shouldLog) : Treecapitator.getTopLogAtPos(logs, world, pos, shouldLog);
        leaves = Treecapitator.getLeavesInDist(world, topLogPos, TCSettings.maxLeafIDDist, shouldLog);
        return leaves;
    }

    private static List<BlockID> getLeavesInDist(World world, BlockPos pos, int range, boolean shouldLog) {
        if (shouldLog) {
            TCLog.debug("Attempting to identify tree...", new Object[0]);
        }
        ArrayList<BlockID> leaves = new ArrayList<BlockID>();
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos2;
                    if (x == 0 && y == 0 && z == 0 || world.func_175623_d(pos2 = pos.func_177971_a((Vec3i)new BlockPos(x, y, z)))) continue;
                    Block block = world.func_180495_p(pos2).func_177230_c();
                    ModulusBlockID blockID = new ModulusBlockID(world, pos2, 8);
                    if (block.isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos2)) {
                        if (shouldLog) {
                            TCLog.debug("Found leaf block: %s", blockID);
                        }
                        leaves.add((BlockID)blockID);
                        continue;
                    }
                    if (!shouldLog) continue;
                    TCLog.debug("Not a leaf block: %s", blockID);
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Found %d leaves.", leaves.size());
        }
        return leaves;
    }

    private BlockPos getTopLog(World world, BlockPos pos) {
        if (this.treeDef.useAdvancedTopLogLogic()) {
            return Treecapitator.getTopLog(this.treeDef.getLogList(), world, pos, true);
        }
        return Treecapitator.getTopLogAtPos(this.treeDef.getLogList(), world, pos, true);
    }

    private static BlockPos getTopLog(List<BlockID> logBlocks, World world, BlockPos pos, boolean shouldLog) {
        LinkedList<BlockPos> topLogs = new LinkedList<BlockPos>();
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        BlockPos topLog = pos;
        topLogs.add(Treecapitator.getTopLogAtPos(logBlocks, world, topLog, false));
        while (topLogs.size() > 0) {
            BlockPos newPos;
            int z;
            int x;
            BlockPos nextLog = (BlockPos)topLogs.pollFirst();
            processed.add(nextLog);
            if (nextLog.func_177956_o() > topLog.func_177956_o()) {
                topLog = nextLog;
            }
            int currentSize = topLogs.size();
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    newPos = new BlockPos(x, 1, z).func_177971_a((Vec3i)nextLog);
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, newPos)) || topLogs.contains(newPos) || processed.contains(newPos)) continue;
                    topLogs.add(Treecapitator.getTopLogAtPos(logBlocks, world, newPos, false));
                }
            }
            if (topLogs.size() != currentSize) continue;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    newPos = new BlockPos(x, 0, z).func_177971_a((Vec3i)nextLog);
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, newPos)) || topLogs.contains(newPos) || processed.contains(newPos)) continue;
                    topLogs.add(Treecapitator.getTopLogAtPos(logBlocks, world, newPos, false));
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Top Log: " + pos.toString(), new Object[0]);
        }
        return topLog;
    }

    private static BlockPos getTopLogAtPos(List<? extends BlockID> logBlocks, World world, BlockPos pos, boolean shouldLog) {
        while (logBlocks.contains(new BlockID(world, pos.func_177984_a()))) {
            pos = pos.func_177984_a();
        }
        if (shouldLog) {
            TCLog.debug("Top Log: " + pos.toString(), new Object[0]);
        }
        return pos;
    }

    private static BlockPos getBottomLog(List<BlockID> logBlocks, World world, BlockPos pos, boolean shouldLog) {
        LinkedList<BlockPos> bottomLogs = new LinkedList<BlockPos>();
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        BlockPos bottomLog = pos;
        bottomLogs.add(Treecapitator.getBottomLogAtPos(logBlocks, world, bottomLog, false));
        while (bottomLogs.size() > 0) {
            BlockPos newPos;
            int z;
            int x;
            BlockPos nextLog = (BlockPos)bottomLogs.pollFirst();
            processed.add(nextLog);
            if (nextLog.func_177956_o() < bottomLog.func_177956_o()) {
                bottomLog = nextLog;
            }
            int currentSize = bottomLogs.size();
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    newPos = new BlockPos(x, -1, z).func_177971_a((Vec3i)nextLog);
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, newPos)) || bottomLogs.contains(newPos) || processed.contains(newPos)) continue;
                    bottomLogs.add(Treecapitator.getBottomLogAtPos(logBlocks, world, newPos, false));
                }
            }
            if (bottomLogs.size() != currentSize) continue;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    newPos = new BlockPos(x, 0, z).func_177971_a((Vec3i)nextLog);
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, newPos)) || bottomLogs.contains(newPos) || processed.contains(newPos)) continue;
                    bottomLogs.add(Treecapitator.getBottomLogAtPos(logBlocks, world, newPos, false));
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Bottom Log: " + pos.toString(), new Object[0]);
        }
        return bottomLog;
    }

    private static BlockPos getBottomLogAtPos(List<BlockID> logBlocks, World world, BlockPos pos, boolean shouldLog) {
        while (logBlocks.contains(new BlockID(world, pos.func_177977_b()))) {
            pos = pos.func_177977_b();
        }
        if (shouldLog) {
            TCLog.debug("Bottom Log: " + pos.toString(), new Object[0]);
        }
        return pos;
    }

    private static boolean hasXLeavesInDist(List<BlockID> leafBlocks, World world, BlockPos pos, int range, int limit, boolean shouldLog) {
        if (shouldLog) {
            TCLog.debug("Attempting to identify tree...", new Object[0]);
        }
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos otherPos;
                    BlockID blockID;
                    if (x == 0 && y == 0 && z == 0 || !(blockID = new BlockID(world, otherPos = new BlockPos(x, y, z).func_177971_a((Vec3i)pos))).isValid()) continue;
                    if (Treecapitator.isLeafBlock(leafBlocks, blockID)) {
                        if (shouldLog) {
                            TCLog.debug("Found leaf block: %s", blockID);
                        }
                        if (++i < limit) continue;
                        return true;
                    }
                    if (!shouldLog) continue;
                    TCLog.debug("Not a leaf block: %s", blockID);
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Number of leaf blocks is less than the limit. Found: %s", i);
        }
        return false;
    }

    private boolean hasXLeavesInDist(World world, BlockPos pos, int range, int limit) {
        return Treecapitator.hasXLeavesInDist(this.treeDef.getLeafList(), world, pos, range, limit, true);
    }

    private boolean hasShearsInHotbar(EntityPlayer entityplayer) {
        return this.shearsHotbarIndex(entityplayer) != -1;
    }

    private int shearsHotbarIndex(EntityPlayer entityPlayer) {
        for (int i = 0; i < 9; ++i) {
            ItemStack item = (ItemStack)entityPlayer.field_71071_by.field_70462_a.get(i);
            if (item == null || item.func_190916_E() <= 0 || !ToolRegistry.instance().isShears(item)) continue;
            this.shears = item;
            return i;
        }
        this.shears = null;
        return -1;
    }

    public static boolean isLeafBlock(List<BlockID> leafBlocks, BlockID blockID) {
        return leafBlocks.contains(blockID) || leafBlocks.contains(new BlockID(blockID.id, blockID.metadata & 7));
    }

    public boolean isLeafBlock(BlockID blockID) {
        return Treecapitator.isLeafBlock(this.treeDef.getLeafList(), blockID);
    }

    private void destroyBlocks(World world, LinkedList<BlockPos> list) {
        this.destroyBlocksWithChance(world, list, 1.0f, false);
    }

    private void destroyBlocksWithChance(World world, List<BlockPos> list, float f, boolean canShear) {
        while (list.size() > 0) {
            BlockPos pos = list.remove(0);
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.isAir(world.func_180495_p(pos), (IBlockAccess)world, pos)) continue;
            int metadata = block.func_176201_c(state);
            BlockID blockID = new BlockID(block, metadata);
            if (block instanceof IShearable && (this.vineID.equals((Object)blockID) && TCSettings.shearVines || this.isLeafBlock(blockID) && TCSettings.shearLeaves) && canShear && (!this.player.field_71075_bZ.field_75098_d || !TCSettings.disableCreativeDrops)) {
                IShearable target = (IShearable)block;
                if (target.isShearable(this.shears, (IBlockAccess)world, pos)) {
                    List drops = target.onSheared(this.shears, (IBlockAccess)this.player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.shears));
                    if (drops != null) {
                        if (TCSettings.stackDrops) {
                            this.addDrops(drops);
                        } else if (TCSettings.itemsDropInPlace) {
                            for (ItemStack itemStack : drops) {
                                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack));
                            }
                        } else {
                            for (ItemStack itemStack : drops) {
                                world.func_72838_d((Entity)new EntityItem(world, (double)this.startPos.func_177958_n(), (double)this.startPos.func_177956_o(), (double)this.startPos.func_177952_p(), itemStack));
                            }
                        }
                    }
                    if (TCSettings.allowItemDamage && !this.player.field_71075_bZ.field_75098_d && this.shears != null && this.shears.func_190916_E() > 0) {
                        canShear = this.damageShearsAndContinue(world, block, pos);
                        ++this.numLeavesSheared;
                        if (canShear && TCSettings.useIncreasingItemDamage && this.numLeavesSheared % TCSettings.increaseDamageEveryXBlocks == 0) {
                            this.leafDamageMultiplier += TCSettings.damageIncreaseAmount;
                        }
                    }
                }
            } else if (!this.player.field_71075_bZ.field_75098_d || !TCSettings.disableCreativeDrops) {
                if (TCSettings.stackDrops) {
                    this.addDrop(block, metadata, pos);
                } else if (TCSettings.itemsDropInPlace) {
                    block.func_176226_b(world, pos, world.func_180495_p(pos), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.player.func_184614_ca()));
                } else {
                    block.func_176226_b(world, this.startPos, world.func_180495_p(pos), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.player.func_184614_ca()));
                }
                if (!(!TCSettings.allowItemDamage || this.player.field_71075_bZ.field_75098_d || this.axe == null || this.axe.func_190916_E() <= 0 || this.vineID.equals((Object)new BlockID(block, metadata)) || this.isLeafBlock(new BlockID(block, metadata)) || pos.equals((Object)this.startPos))) {
                    if (!this.damageAxeAndContinue(world, block, this.startPos)) {
                        list.clear();
                    }
                    ++this.numLogsBroken;
                    if (TCSettings.useIncreasingItemDamage && this.numLogsBroken % TCSettings.increaseDamageEveryXBlocks == 0) {
                        this.logDamageMultiplier += TCSettings.damageIncreaseAmount;
                    }
                }
            }
            if (world.func_175625_s(pos) != null) {
                world.func_175713_t(pos);
            }
            world.func_175698_g(pos);
            this.player.func_71064_a(StatList.func_188055_a((Block)block), 1);
            this.player.func_71020_j(0.025f);
        }
    }

    private void addDrop(Block block, int metadata, BlockPos pos) {
        ArrayList<ItemStack> stacks = null;
        this.dropPos = TCSettings.itemsDropInPlace ? pos : this.startPos;
        IBlockState state = this.world.func_180495_p(pos);
        if (block.canSilkHarvest(this.world, pos, state, this.player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)this.player.func_184614_ca()) > 0) {
            stacks = new ArrayList<ItemStack>();
            stacks.add(new ItemStack(block, 1, metadata));
        } else {
            stacks = block.getDrops((IBlockAccess)this.world, pos, state, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.player.func_184614_ca()));
        }
        this.addDrops(stacks);
    }

    private void addDrops(List<ItemStack> stacks) {
        if (stacks == null) {
            return;
        }
        for (ItemStack drop : stacks) {
            int i;
            if (drop == null) continue;
            int index = -1;
            for (i = 0; i < this.drops.size(); ++i) {
                if (!this.drops.get(i).func_77969_a(drop)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                this.drops.add(drop);
                index = this.drops.indexOf(drop);
            } else {
                int quantity = drop.func_190916_E();
                drop = this.drops.get(index);
                drop.func_190920_e(drop.func_190916_E() + quantity);
            }
            if (drop.func_190916_E() < drop.func_77976_d()) continue;
            i = drop.func_190916_E() - drop.func_77976_d();
            drop.func_190920_e(drop.func_77976_d());
            this.world.func_72838_d((Entity)new EntityItem(this.world, (double)this.dropPos.func_177958_n(), (double)this.dropPos.func_177956_o(), (double)this.dropPos.func_177952_p(), drop));
            if (i > 0) {
                drop.func_190920_e(i);
                continue;
            }
            this.drops.remove(index);
        }
    }

    private void destroyCurrentEquippedItem() {
        ItemStack item = this.player.func_184614_ca();
        this.player.field_71071_by.func_70299_a(this.player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.player, (ItemStack)item, (EnumHand)EnumHand.MAIN_HAND);
    }

    private boolean damageAxeAndContinue(World world, Block block, BlockPos pos) {
        if (this.axe != null) {
            this.currentAxeDamage += this.logDamageMultiplier;
            for (int i = 0; i < (int)Math.floor(this.currentAxeDamage); ++i) {
                this.axe.func_77973_b().func_179218_a(this.axe, world, world.func_180495_p(pos), pos, (EntityLivingBase)this.player);
            }
            this.currentAxeDamage = (float)((double)this.currentAxeDamage - Math.floor(this.currentAxeDamage));
            if (this.axe != null && this.axe.func_190916_E() < 1) {
                this.destroyCurrentEquippedItem();
            }
        }
        return !TCSettings.needItem || TCSettings.allowMoreBlocksThanDamage || this.isAxeItemEquipped();
    }

    private boolean damageShearsAndContinue(World world, Block block, BlockPos pos) {
        if (this.shears != null) {
            int shearsIndex = this.shearsHotbarIndex(this.player);
            this.currentShearsDamage += this.leafDamageMultiplier;
            int i = 0;
            while ((double)i < Math.floor(this.currentShearsDamage)) {
                if (this.shears.func_77973_b().equals(Items.field_151097_aZ)) {
                    this.shears.func_77972_a(1, (EntityLivingBase)this.player);
                } else {
                    this.shears.func_77973_b().func_179218_a(this.shears, world, world.func_180495_p(pos), pos, (EntityLivingBase)this.player);
                }
                ++i;
            }
            this.currentShearsDamage = (float)((double)this.currentShearsDamage - Math.floor(this.currentShearsDamage));
            if (this.shears != null && this.shears.func_190916_E() < 1 && shearsIndex != -1) {
                this.player.field_71071_by.func_70299_a(shearsIndex, null);
            }
        }
        return TCSettings.allowMoreBlocksThanDamage || this.hasShearsInHotbar(this.player);
    }

    private LinkedList<BlockPos> addLogs(World world, BlockPos pos) {
        int index = 0;
        int lowY = pos.func_177956_o();
        LinkedList<BlockPos> list = new LinkedList<BlockPos>();
        list.add(pos);
        do {
            BlockPos currentLog = (BlockPos)list.get(index);
            for (int x = -1; x <= 1; ++x) {
                int y;
                int n = y = this.treeDef.onlyDestroyUpwards() ? 0 : -1;
                while (y <= 1) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = currentLog.func_177982_a(x, y, z);
                        if (world.func_175623_d(newPos) || !this.treeDef.getLogList().contains(new BlockID(world, newPos)) || this.treeDef.maxHorLogBreakDist() != -1 && (Math.abs(newPos.func_177958_n() - this.startPos.func_177958_n()) > this.treeDef.maxHorLogBreakDist() || Math.abs(newPos.func_177952_p() - this.startPos.func_177952_p()) > this.treeDef.maxHorLogBreakDist() || this.treeDef.maxVerLogBreakDist() != -1 && Math.abs(newPos.func_177956_o() - this.startPos.func_177956_o()) > this.treeDef.maxVerLogBreakDist() || list.contains(newPos) || newPos.func_177956_o() < lowY && this.treeDef.onlyDestroyUpwards())) continue;
                        list.add(newPos);
                        if (TCSettings.maxNumberOfBlocksInTree == -1 || ++this.numLogsToBreak <= TCSettings.maxNumberOfBlocksInTree) continue;
                        list.clear();
                        TCLog.debug("Number of logs in tree is more than the maximum number allowed.", new Object[0]);
                        this.maxAllowed = true;
                        return list;
                    }
                    ++y;
                }
            }
        } while (++index < list.size());
        if (list.contains(pos)) {
            list.remove(pos);
        }
        return list;
    }

    private void addLogsAbove(World world, BlockPos position, List<BlockPos> listFinal) {
        ArrayList<BlockPos> listAbove = new ArrayList<BlockPos>();
        listAbove.add(position);
        do {
            BlockPos newPosition;
            int z;
            int x;
            ArrayList<BlockPos> list = listAbove;
            listAbove = new ArrayList();
            for (BlockPos pos : list) {
                int counter = 0;
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        newPosition = pos.func_177982_a(x, 1, z);
                        if (!this.treeDef.getLogList().contains(new BlockID(world, newPosition))) continue;
                        if (!listAbove.contains(newPosition)) {
                            listAbove.add(newPosition);
                        }
                        ++counter;
                    }
                }
                if (counter != 0) continue;
                listFinal.add(pos);
            }
            int index = -1;
            while (++index < listAbove.size()) {
                BlockPos pos = (BlockPos)listAbove.get(index);
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        newPosition = pos.func_177982_a(x, 0, z);
                        if (!this.treeDef.getLogList().contains(new BlockID(world, newPosition)) || listAbove.contains(newPosition)) continue;
                        listAbove.add(newPosition);
                    }
                }
            }
        } while (listAbove.size() > 0);
    }

    public List<BlockPos> addLeaves(World world, BlockPos pos, List<BlockPos> list) {
        int index = -1;
        if (list == null) {
            list = new ArrayList<BlockPos>();
        }
        this.addLeavesInDistance(world, pos, this.treeDef.maxHorLeafBreakDist(), list);
        while (++index < list.size()) {
            BlockPos pos2 = list.get(index);
            if (this.treeDef.maxHorLeafBreakDist() != -1 && CommonUtils.getHorSquaredDistance((BlockPos)pos, (BlockPos)pos2) > this.treeDef.maxHorLeafBreakDist()) continue;
            this.addLeavesInDistance(world, pos2, 1, list);
        }
        return list;
    }

    public void addLeavesInDistance(World world, BlockPos pos, int range, List<BlockPos> list) {
        if (range == -1) {
            range = 4;
        }
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    int md;
                    IBlockState state;
                    Block block;
                    BlockPos newPos = pos.func_177982_a(x, y, z);
                    if (world.func_175623_d(newPos) || !this.isLeafBlock(new BlockID(block = (state = world.func_180495_p(newPos)).func_177230_c(), md = block.func_176201_c(state))) && !this.vineID.equals((Object)new BlockID(block)) || this.treeDef.requireLeafDecayCheck() && ((md & 8) == 0 || (md & 4) != 0) || list.contains(newPos) || this.hasLogClose(world, newPos, 1)) continue;
                    list.add(newPos);
                }
            }
        }
    }

    public boolean hasLogClose(World world, BlockPos pos, int i) {
        for (int x = -i; x <= i; ++x) {
            for (int y = -i; y <= i; ++y) {
                for (int z = -i; z <= i; ++z) {
                    BlockPos neighborPos = pos.func_177982_a(x, y, z);
                    if (x == 0 && y == 0 && z == 0 || world.func_175623_d(neighborPos) || !this.treeDef.getLogList().contains(new BlockID(world, neighborPos)) || neighborPos.equals((Object)this.startPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

