/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.network;

import com.austinv11.collectiveframework.minecraft.reference.Config;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TimeUpdatePacket
implements IMessage {
    public long startTime;
    public int time;
    public GameProfile profile;

    public TimeUpdatePacket() {
    }

    public TimeUpdatePacket(long startTime, int time, GameProfile profile) {
        this.startTime = startTime;
        this.time = time;
        this.profile = profile;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.startTime = tag.func_74763_f("startTime");
        this.time = tag.func_74762_e("time");
        this.profile = new GameProfile(UUID.fromString(tag.func_74779_i("uuid")), tag.func_74779_i("name"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("startTime", this.startTime);
        tag.func_74768_a("time", this.time);
        tag.func_74778_a("uuid", this.profile.getId().toString());
        tag.func_74778_a("name", this.profile.getName());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class TimeUpdatePacketHandler
    implements IMessageHandler<TimeUpdatePacket, IMessage> {
        public IMessage onMessage(TimeUpdatePacket message, MessageContext ctx) {
            boolean playerCanSendCommands = false;
            for (WorldServer world : DimensionManager.getWorlds()) {
                MinecraftServer server = world.func_73046_m();
                if (server == null || !server.func_184103_al().func_152596_g(message.profile)) continue;
                playerCanSendCommands = true;
                break;
            }
            if (Config.enableButtonTimeChanging && playerCanSendCommands) {
                for (WorldServer world : DimensionManager.getWorlds()) {
                    world.func_72877_b(message.startTime + (long)message.time);
                }
            }
            return null;
        }
    }
}

