/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.books.core;

import com.austinv11.collectiveframework.minecraft.CollectiveFramework;
import com.austinv11.collectiveframework.minecraft.books.api.Book;
import com.austinv11.collectiveframework.minecraft.books.api.Entry;
import com.austinv11.collectiveframework.minecraft.books.api.InteractiveEntry;
import com.austinv11.collectiveframework.minecraft.books.api.Page;
import com.austinv11.collectiveframework.minecraft.books.core.ItemBook;
import com.austinv11.collectiveframework.minecraft.utils.client.GuiUtils;
import com.austinv11.collectiveframework.utils.TimeProfiler;
import com.austinv11.collectiveframework.utils.math.TwoDimensionalVector;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBook
extends GuiScreen {
    private ItemBook bookItem;
    private ItemStack stack;
    private Book book;
    private TimeProfiler profiler;
    private EntityPlayer player;

    public GuiBook(EntityPlayer player) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemBook)) {
            GuiUtils.closeCurrentGui();
            return;
        }
        this.stack = heldItem;
        this.bookItem = (ItemBook)heldItem.func_77973_b();
        try {
            this.book = this.bookItem.getBook().getConstructor(ItemBook.class, ItemStack.class).newInstance(new Object[]{this.bookItem, this.stack});
        }
        catch (Exception e) {
            CollectiveFramework.LOGGER.error("Exception opening book gui for " + ((Object)((Object)this.bookItem)).getClass().getName());
            e.printStackTrace();
            GuiUtils.closeCurrentGui();
            return;
        }
        this.book.handoffGui(this);
        this.player = player;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.profiler == null) {
            this.profiler = new TimeProfiler();
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        this.drawBackground();
        this.drawCurrentPage();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        this.profiler = new TimeProfiler();
    }

    public void func_73866_w_() {
        this.book.onOpen(this.player);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    private void drawEntries(Page page) {
        for (Entry entry : page.getEntries()) {
            GL11.glPushMatrix();
            if (!entry.useAbsoluteCoords && this.book.getBackground() != null) {
                try {
                    ScaledResolution resolution = GuiUtils.getCurrentResolution();
                    BufferedImage backgroundImage = ImageIO.read(GuiUtils.getResourceAsStream(this.book.getBackground()));
                    int backgroundWidth = backgroundImage.getWidth();
                    int backgroundHeight = backgroundImage.getHeight();
                    int backX = (resolution.func_78326_a() - backgroundWidth) / 2;
                    int backY = (resolution.func_78328_b() - backgroundHeight) / 2;
                    GL11.glTranslated((double)backX, (double)backY, (double)0.0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            GL11.glRotatef((float)entry.getPitch(), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)entry.getYaw(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)entry.getRotation(), (float)0.0f, (float)0.0f, (float)1.0f);
            if (entry.drawDebugLines) {
                GuiBook.func_73734_a((int)entry.getCoords().getRoundedX(), (int)entry.getCoords().getRoundedY(), (int)(entry.getCoords().getRoundedX() + entry.field_146294_l), (int)(entry.getCoords().getRoundedY() + entry.field_146295_m), (int)Color.LIGHT_GRAY.getRGB());
            }
            entry.onRender((int)this.profiler.getTime());
            if (entry.drawDebugLines) {
                this.func_73730_a(entry.getCoords().getRoundedX(), entry.getCoords().getRoundedX() + entry.field_146294_l, entry.getCoords().getRoundedY(), Color.BLACK.getRGB());
                this.func_73730_a(entry.getCoords().getRoundedX(), entry.getCoords().getRoundedX() + entry.field_146294_l, entry.getCoords().getRoundedY() + entry.field_146295_m, Color.BLACK.getRGB());
                this.func_73728_b(entry.getCoords().getRoundedX(), entry.getCoords().getRoundedY(), entry.getCoords().getRoundedY() + entry.field_146295_m, Color.BLACK.getRGB());
                this.func_73728_b(entry.getCoords().getRoundedX() + entry.field_146294_l, entry.getCoords().getRoundedY(), entry.getCoords().getRoundedY() + entry.field_146295_m, Color.BLACK.getRGB());
            }
            GL11.glPopMatrix();
        }
    }

    private void drawCurrentPage() {
        int currentPage = this.book.getCurrentPage();
        Page page = this.book.getPages()[currentPage];
        ResourceLocation background = page.getBackground();
        ScaledResolution resolution = GuiUtils.getCurrentResolution();
        if (background != null) {
            try {
                BufferedImage backgroundImage = ImageIO.read(GuiUtils.getResourceAsStream(background));
                int backgroundWidth = backgroundImage.getWidth();
                int backgroundHeight = backgroundImage.getHeight();
                int backX = (resolution.func_78326_a() - backgroundWidth) / 2;
                int backY = (resolution.func_78328_b() - backgroundHeight) / 2;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(background);
                this.func_73729_b(backX, backY, 0, 0, resolution.func_78326_a(), resolution.func_78328_b());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        page.onRender((int)this.profiler.getTime());
        this.drawEntries(page);
    }

    private void drawBackground() {
        ResourceLocation background = this.book.getBackground();
        ScaledResolution resolution = GuiUtils.getCurrentResolution();
        if (background != null) {
            try {
                BufferedImage backgroundImage = ImageIO.read(GuiUtils.getResourceAsStream(background));
                int backgroundWidth = backgroundImage.getWidth();
                int backgroundHeight = backgroundImage.getHeight();
                int backX = (resolution.func_78326_a() - backgroundWidth) / 2;
                int backY = (resolution.func_78328_b() - backgroundHeight) / 2;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(background);
                this.func_73729_b(backX, backY, 0, 0, backgroundWidth, backgroundHeight);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.book.onRender((int)this.profiler.getTime());
        if (this.book.drawDebugLines) {
            for (int x = 0; x < resolution.func_78326_a(); ++x) {
                if (x % 2 == 0 && x % 4 != 0) {
                    this.func_73728_b(x, 0, resolution.func_78328_b(), Color.LIGHT_GRAY.getRGB());
                    continue;
                }
                if (x % 4 != 0) continue;
                this.func_73730_a(x, 0, resolution.func_78328_b(), Color.GRAY.getRGB());
            }
            for (int y = 0; y < resolution.func_78328_b(); ++y) {
                if (y % 2 == 0 && y % 4 != 0) {
                    this.func_73730_a(0, resolution.func_78326_a(), y, Color.LIGHT_GRAY.getRGB());
                    continue;
                }
                if (y % 4 != 0) continue;
                this.func_73730_a(0, resolution.func_78326_a(), y, Color.GRAY.getRGB());
            }
        }
    }

    @SubscribeEvent
    public void onKeyboardInput(InputEvent.KeyInputEvent event) {
        char eventChar = Keyboard.getEventCharacter();
        boolean isDown = Keyboard.getEventKeyState();
        Page page = this.book.getPages()[this.book.getCurrentPage()];
        for (Entry entry : page.getEntries()) {
            if (!(entry instanceof InteractiveEntry)) continue;
            ((InteractiveEntry)entry).onKeyboardEvent(eventChar, isDown);
        }
    }

    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        Page page = this.book.getPages()[this.book.getCurrentPage()];
        for (Entry entry : page.getEntries()) {
            if (!(entry instanceof InteractiveEntry)) continue;
            int offsetX = 0;
            int offsetY = 0;
            TwoDimensionalVector startCoords = entry.getCoords();
            if (!entry.useAbsoluteCoords) {
                try {
                    ScaledResolution resolution = GuiUtils.getCurrentResolution();
                    BufferedImage backgroundImage = ImageIO.read(GuiUtils.getResourceAsStream(this.book.getBackground()));
                    int backgroundWidth = backgroundImage.getWidth();
                    int backgroundHeight = backgroundImage.getHeight();
                    offsetX = (resolution.func_78326_a() - backgroundWidth) / 2;
                    offsetY = (resolution.func_78328_b() - backgroundHeight) / 2;
                    startCoords = startCoords.add(new TwoDimensionalVector(offsetX, offsetY));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (event.getX() < startCoords.getRoundedX() || event.getX() > startCoords.getRoundedX() + entry.field_146294_l || event.getY() < startCoords.getRoundedY() || event.getY() > entry.field_146295_m) continue;
            ((InteractiveEntry)entry).onMouseEvent(event.getX() - offsetX, event.getY() - offsetY, event.getDx(), event.getDy(), event.getButton(), event.getDwheel(), event.isButtonstate());
        }
    }

    public void func_146281_b() {
        this.book.onClose();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public boolean func_73868_f() {
        return this.book.doesPauseGame();
    }
}

