/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.iterators.BaseChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.helpers.IVoxelSrc;
import mod.chiselsandbits.modes.ChiselMode;
import net.minecraft.util.EnumFacing;

public class ChiselMaterialIterator
extends BaseChiselIterator
implements ChiselIterator {
    final int INDEX_X = 0;
    final int INDEX_Y = 8;
    final int INDEX_Z = 16;
    Iterator<Integer> list;
    EnumFacing side;
    int value;

    private int setValue(int pos, int idx) {
        return ((byte)pos & 0xFF) << idx;
    }

    private int getValue(int value, int idx) {
        return (byte)(value >>> idx & 0xFF);
    }

    private int createPos(int x, int y, int z) {
        return this.setValue(x, 0) | this.setValue(y, 8) | this.setValue(z, 16);
    }

    public ChiselMaterialIterator(int dim, int sx, int sy, int sz, IVoxelSrc source, ChiselMode mode, EnumFacing side, boolean place) {
        this.side = side;
        ArrayList<Integer> selectedpositions = new ArrayList<Integer>();
        int tx = side.func_82601_c();
        int ty = side.func_96559_d();
        int tz = side.func_82599_e();
        int x = sx;
        int y = sy;
        int z = sz;
        int placeoffsetX = 0;
        int placeoffsetY = 0;
        int placeoffsetZ = 0;
        if (place) {
            x -= tx;
            y -= ty;
            z -= tz;
            int n = side.func_176740_k() == EnumFacing.Axis.X ? (side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1 : -1) : (placeoffsetX = 0);
            int n2 = side.func_176740_k() == EnumFacing.Axis.Y ? (side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1 : -1) : (placeoffsetY = 0);
            placeoffsetZ = side.func_176740_k() == EnumFacing.Axis.Z ? (side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1 : -1) : 0;
        }
        int target = source.getSafe(x, y, z);
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            int zz;
            int yy;
            int xx;
            if (source.getSafe(bi.x - tx, bi.y - ty, bi.z - tz) == target) {
                xx = placeoffsetX + bi.x - tx;
                yy = placeoffsetY + bi.y - ty;
                zz = placeoffsetZ + bi.z - tz;
                if (xx >= 0 && xx < 16 && yy >= 0 && yy < 16 && zz >= 0 && zz < 16) {
                    selectedpositions.add(this.createPos(xx, yy, zz));
                }
            }
            if (source.getSafe(bi.x, bi.y, bi.z) != target) continue;
            xx = placeoffsetX + bi.x;
            yy = placeoffsetY + bi.y;
            zz = placeoffsetZ + bi.z;
            if (xx < 0 || xx >= 16 || yy < 0 || yy >= 16 || zz < 0 || zz >= 16) continue;
            selectedpositions.add(this.createPos(xx, yy, zz));
        }
        this.list = selectedpositions.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.list.hasNext()) {
            this.value = this.list.next();
            return true;
        }
        return false;
    }

    @Override
    public EnumFacing side() {
        return this.side;
    }

    @Override
    public int x() {
        return this.getValue(this.value, 0);
    }

    @Override
    public int y() {
        return this.getValue(this.value, 8);
    }

    @Override
    public int z() {
        return this.getValue(this.value, 16);
    }
}

