/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import mod.chiselsandbits.bitbag.BagStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;

public class BagCapabilityProvider
extends BagStorage
implements ICapabilityProvider {
    public BagCapabilityProvider(ItemStack stack, NBTTagCompound nbt) {
        this.stack = stack;
    }

    static int[] getStorageArray(ItemStack stack, int size) {
        int[] out = null;
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (compound.func_74764_b("contents")) {
            out = compound.func_74759_k("contents");
        }
        if (out == null) {
            stack.func_77982_d(compound);
            out = new int[size];
            compound.func_74783_a("contents", out);
        }
        if (out.length != size && compound != null) {
            int[] tmp = out;
            out = new int[size];
            System.arraycopy(out, 0, tmp, 0, Math.min(size, tmp.length));
            compound.func_74783_a("contents", out);
        }
        return out;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.setStorage(BagCapabilityProvider.getStorageArray(this.stack, 126));
            return (T)this;
        }
        return null;
    }
}

