/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class VaultDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION && !topBlock) {
            return null;
        }
        float x = 0.0f;
        float y = 0.0f;
        if (topBlock != tileEntity.isHingeLeft()) {
            x = topBlock ? -0.8125f : 0.8125f;
        } else {
            y = topBlock ? 0.8125f : -0.8125f;
        }
        return IDoorMovement.getHalfBoundingBox().func_72317_d((double)x, (double)y, 0.0);
    }

    private Rotation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float hinge;
        float angle = -90.0f;
        float offsetX = hinge = -0.40625f;
        float offsetY = hinge;
        if (topBlock) {
            offsetY = 1.0f - offsetY;
        }
        if (tileEntity.isHingeLeft()) {
            offsetX = -offsetX;
        }
        Rotation rotation = new Rotation(angle).aroundAxis(0.0f, 0.0f, 1.0f).offset(offsetX, offsetY, 0.0f);
        rotation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        rotation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return rotation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model.getShape("top"), (Transformation)this.getTransformation(tileEntity, true)), new Animation((ITransformable)model.getShape("bottom"), (Transformation)this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

