/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.farming.mutation.Mutation;
import com.infinityraider.agricraft.impl.v1.AgriRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import scala.actors.threadpool.Arrays;

public class AgriMutationRegistry
extends AgriRegistry<IAgriMutation>
implements IAgriMutationRegistry {
    @Override
    public boolean add(@Nonnull String id, double chance, @Nonnull String childId, String ... parentIds) {
        return this.add(id, chance, childId, Arrays.asList((Object[])parentIds));
    }

    @Override
    public boolean add(@Nonnull String id, double chance, @Nonnull String childId, @Nonnull List<String> parentIds) {
        Objects.requireNonNull(id, "The id of a mutation may not be null!");
        Objects.requireNonNull(childId, "The id of the child plant for a mutation may not be null!");
        Objects.requireNonNull(parentIds, "The supplied list of parents for a mutation may not be null!");
        parentIds.forEach(parentId -> Objects.requireNonNull(parentId, "The id of a parent for a mutation may not be null!"));
        IAgriPlant childPlant = AgriApi.getPlantRegistry().get(id).orElse(null);
        if (childPlant == null) {
            return false;
        }
        ArrayList<IAgriPlant> parentPlants = new ArrayList<IAgriPlant>(parentIds.size());
        for (String parentId2 : parentIds) {
            IAgriPlant parentPlant = AgriApi.getPlantRegistry().get(parentId2).orElse(null);
            if (parentPlant != null) {
                parentPlants.add(parentPlant);
                continue;
            }
            return false;
        }
        Mutation mutation = new Mutation(id, chance, childPlant, parentPlants);
        return this.add(mutation);
    }
}

