/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui.component;

import com.infinityraider.agricraft.gui.AgriGuiWrapper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiComponent<C> {
    private final C component;
    private final Rectangle bounds;
    private final Rectangle uv;
    private final double scale;
    private final boolean centeredHorizontally;
    private final boolean centeredVertically;
    private BiConsumer<GuiComponent<C>, List<String>> tootipAdder;
    private BiFunction<GuiComponent<C>, Point, Boolean> mouseClickAction;
    private BiConsumer<GuiComponent<C>, Point> mouseEnterAction;
    private BiConsumer<GuiComponent<C>, Point> mouseLeaveAction;
    private BiConsumer<AgriGuiWrapper, GuiComponent<C>> renderAction;
    private boolean isVisible = true;
    private boolean isEnabled = true;
    private boolean isHovered = false;

    public GuiComponent(C component, Rectangle bounds, Rectangle uv, double scale, boolean centeredHorizontally, boolean centeredVertically, boolean visable, boolean enabled, BiConsumer<GuiComponent<C>, List<String>> tootipAdder, BiFunction<GuiComponent<C>, Point, Boolean> mouseClickAction, BiConsumer<GuiComponent<C>, Point> mouseEnterAction, BiConsumer<GuiComponent<C>, Point> mouseLeaveAction, BiConsumer<AgriGuiWrapper, GuiComponent<C>> renderAction) {
        this.component = component;
        this.bounds = bounds;
        this.uv = uv;
        this.scale = scale;
        this.centeredHorizontally = centeredHorizontally;
        this.centeredVertically = centeredVertically;
        this.isVisible = visable;
        this.isEnabled = enabled;
        this.tootipAdder = tootipAdder;
        this.mouseClickAction = mouseClickAction;
        this.mouseEnterAction = mouseEnterAction;
        this.mouseLeaveAction = mouseLeaveAction;
        this.renderAction = renderAction;
    }

    public final C getComponent() {
        return this.component;
    }

    public final Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle getUV() {
        return this.uv;
    }

    public double getScale() {
        return this.scale;
    }

    public final boolean isCenteredHorizontally() {
        return this.centeredHorizontally;
    }

    public boolean isCenteredVertically() {
        return this.centeredVertically;
    }

    public final boolean isHovered() {
        return this.isHovered;
    }

    public final boolean isVisable() {
        return this.isVisible;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public final void setVisable(boolean visable) {
        this.isVisible = visable;
    }

    public void setTootipAdder(BiConsumer<GuiComponent<C>, List<String>> tootipAdder) {
        this.tootipAdder = tootipAdder;
    }

    public void setMouseClickAction(BiFunction<GuiComponent<C>, Point, Boolean> mouseClickAction) {
        this.mouseClickAction = mouseClickAction;
    }

    public void setMouseEnterAction(BiConsumer<GuiComponent<C>, Point> mouseEnterAction) {
        this.mouseEnterAction = mouseEnterAction;
    }

    public void setMouseLeaveAction(BiConsumer<GuiComponent<C>, Point> mouseLeaveAction) {
        this.mouseLeaveAction = mouseLeaveAction;
    }

    public void setRenderAction(BiConsumer<AgriGuiWrapper, GuiComponent<C>> renderAction) {
        this.renderAction = renderAction;
    }

    public final boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    public final boolean onClick(int x, int y, int mouseButton) {
        return this.isEnabled && this.mouseClickAction != null && this.mouseClickAction.apply(this, this.relativize(x, y)) != false;
    }

    public final void onMouseMove(int x, int y) {
        if (this.isEnabled) {
            if (this.contains(x, y)) {
                if (!this.isHovered) {
                    this.isHovered = true;
                    this.onMouseEnter(x, y);
                }
            } else if (this.isHovered) {
                this.isHovered = false;
                this.onMouseLeave(x, y);
            }
        }
    }

    public final void onMouseEnter(int x, int y) {
        if (this.isEnabled && this.mouseEnterAction != null) {
            this.mouseEnterAction.accept(this, this.relativize(x, y));
        }
    }

    public final void onMouseLeave(int x, int y) {
        if (this.isEnabled && this.mouseLeaveAction != null) {
            this.mouseLeaveAction.accept(this, this.relativize(x, y));
        }
    }

    public final void addToolTip(List<String> toolTip, EntityPlayer player) {
        if (this.isEnabled && this.tootipAdder != null) {
            this.tootipAdder.accept(this, toolTip);
        }
    }

    public final void renderComponent(AgriGuiWrapper gui) {
        if (this.isVisible && this.renderAction != null) {
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.bounds.x, (float)this.bounds.y, (float)0.0f);
            GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)this.scale);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderAction.accept(gui, this);
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
        }
    }

    public final Point relativize(int x, int y) {
        return new Point(x - this.bounds.x, y - this.bounds.y);
    }
}

