/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class StringUtil {
    public static final Pattern TOKENIZER = Pattern.compile("\"([^\"]*)\"|(\\S+)");

    public static final Deque<String> tokenize(@Nonnull String input) {
        Matcher m = TOKENIZER.matcher(input);
        ArrayDeque<String> tokens = new ArrayDeque<String>();
        while (m.find()) {
            tokens.add(m.group());
        }
        return tokens;
    }

    public static final String increaseIndent(@Nonnull String input) {
        return input.replaceAll("(?m)^", "\t");
    }

    public static final String decreaseIndent(@Nonnull String input) {
        return input.replaceAll("(?m)^\t", "");
    }

    public static final String trimStart(@Nonnull String input) {
        return input.replaceAll("^\\s+", "");
    }

    public static final String trimEnd(@Nonnull String input) {
        return input.replaceAll("\\s+$", "");
    }

    private StringUtil() {
    }
}

