/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.json;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriSerializable;
import com.agricraft.agricore.util.TypeHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;

public class AgriSaver {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void saveElements(Path location, AgriSerializable ... objects) {
        AgriSaver.saveElements(location, TypeHelper.asList(objects));
    }

    public static void saveElements(Path location, Collection<? extends AgriSerializable> objects) {
        objects.forEach(obj -> AgriSaver.saveElement(location, obj));
    }

    public static void saveElement(Path location, AgriSerializable obj) {
        if (location.getFileName().toString().indexOf(46) == -1) {
            location = location.resolve(obj.getPath());
        }
        try {
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            AgriCore.getCoreLogger().warn("Unable to create directories for element: \"{0}\"!", location);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(location, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            gson.toJson((Object)obj, (Appendable)writer);
            writer.append("\n");
        }
        catch (IOException e) {
            AgriCore.getCoreLogger().warn("Unable to save element: \"{0}\"!", location);
        }
    }
}

