/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openblocks.Config;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class ItemSpongeOnAStick
extends Item {
    public ItemSpongeOnAStick() {
        this.func_77625_d(1);
        this.func_77656_e(Config.spongeMaxDamage);
    }

    private static int getCleanupFlags() {
        return Config.spongeStickBlockUpdate ? 3 : 2;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        return ItemSpongeOnAStick.soakUp(world, pos, player, stack) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean result = ItemSpongeOnAStick.soakUp(world, player.func_180425_c(), player, stack);
        return ActionResult.newResult((EnumActionResult)(result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL), (Object)stack);
    }

    private static boolean soakUp(World world, BlockPos pos, EntityPlayer player, @Nonnull ItemStack stack) {
        boolean absorbedAnything = false;
        boolean hitLava = false;
        int damage = stack.func_77952_i();
        int cleanupFlags = ItemSpongeOnAStick.getCleanupFlags();
        for (int x = -Config.spongeStickRange; x <= Config.spongeStickRange; ++x) {
            block1: for (int y = -Config.spongeStickRange; y <= Config.spongeStickRange; ++y) {
                for (int z = -Config.spongeStickRange; z <= Config.spongeStickRange; ++z) {
                    BlockPos targetPos = pos.func_177982_a(x, y, z);
                    Material material = world.func_180495_p(targetPos).func_185904_a();
                    if (!material.func_76224_d()) continue;
                    absorbedAnything = true;
                    hitLava |= material == Material.field_151587_i;
                    world.func_180501_a(targetPos, Blocks.field_150350_a.func_176223_P(), cleanupFlags);
                    if (++damage >= Config.spongeMaxDamage) continue block1;
                }
            }
        }
        if (hitLava) {
            stack.func_190920_e(0);
            player.func_70015_d(6);
        }
        if (absorbedAnything) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }
}

