/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import openblocks.OpenBlocks;
import openblocks.common.item.ItemGlyph;

public class EntityGlyph
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private static final String TAG_CHAR_INDEX = "CharIndex";
    private static final String TAG_OFFSET_X = "OffsetX";
    private static final String TAG_OFFSET_Y = "OffsetY";
    private int charIndex;
    private byte offsetX;
    private byte offsetY;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private static final double DEPTH = 0.5;

    public EntityGlyph(World world) {
        super(world);
    }

    public EntityGlyph(World world, BlockPos pos, EnumFacing facing, int charIndex, byte offsetX, byte offsetY) {
        super(world, pos);
        this.setCharIndex(charIndex);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.func_174859_a(facing);
    }

    public void func_70107_b(double x, double y, double z) {
        EnumFacing normal = this.field_174860_b;
        if (normal != null) {
            EnumFacing left = normal.func_176746_e();
            if (left.func_176740_k() == EnumFacing.Axis.Z) {
                z -= (double)(this.offsetX - 8) / 16.0;
            } else {
                x -= (double)(this.offsetX - 8) / 16.0;
            }
            y -= (double)(this.offsetY - 8) / 16.0;
        }
        super.func_70107_b(x, y, z);
    }

    protected void func_174856_o() {
        EnumFacing normal = this.field_174860_b;
        if (normal != null) {
            double halfSizeZ;
            double halfSizeX;
            double centerX = (double)this.field_174861_a.func_177958_n() + 0.5;
            double centerY = (double)this.field_174861_a.func_177956_o() + 0.5;
            double centerZ = (double)this.field_174861_a.func_177952_p() + 0.5;
            centerX -= (double)normal.func_82601_c() * 15.5 / 16.0 / 2.0;
            centerZ -= (double)normal.func_82599_e() * 15.5 / 16.0 / 2.0;
            EnumFacing left = normal.func_176746_e();
            centerY += (double)(this.offsetY - 8) / 16.0;
            if (left.func_176740_k() == EnumFacing.Axis.Z) {
                centerZ += (double)(this.offsetX - 8) / 16.0;
            } else {
                centerX += (double)(this.offsetX - 8) / 16.0;
            }
            this.field_70165_t = centerX;
            this.field_70163_u = centerY;
            this.field_70161_v = centerZ;
            double halfSizeY = (double)this.func_82330_g() / 16.0 / 2.0;
            if (normal.func_176740_k() == EnumFacing.Axis.Z) {
                halfSizeX = (double)this.func_82329_d() / 16.0 / 2.0;
                halfSizeZ = 0.015625;
            } else {
                halfSizeX = 0.015625;
                halfSizeZ = (double)this.func_82329_d() / 16.0 / 2.0;
            }
            this.func_174826_a(new AxisAlignedBB(centerX - halfSizeX, centerY - halfSizeY, centerZ - halfSizeZ, centerX + halfSizeX, centerY + halfSizeY, centerZ + halfSizeZ));
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.itemStack.func_77946_l();
    }

    public int func_82329_d() {
        return 8;
    }

    public int func_82330_g() {
        return 8;
    }

    private void setCharIndex(int charIndex) {
        this.charIndex = charIndex;
        this.itemStack = ItemGlyph.createStack(OpenBlocks.Items.glyph, charIndex);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(TAG_CHAR_INDEX, this.charIndex);
        compound.func_74774_a(TAG_OFFSET_X, this.offsetX);
        compound.func_74774_a(TAG_OFFSET_Y, this.offsetY);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setCharIndex((char)compound.func_74762_e(TAG_CHAR_INDEX));
        this.offsetX = compound.func_74771_c(TAG_OFFSET_X);
        this.offsetY = compound.func_74771_c(TAG_OFFSET_Y);
        super.func_70037_a(compound);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.charIndex);
        buffer.writeByte(this.field_174860_b.ordinal());
        buffer.writeInt(this.field_174861_a.func_177958_n());
        buffer.writeInt(this.field_174861_a.func_177956_o());
        buffer.writeInt(this.field_174861_a.func_177952_p());
        buffer.writeByte((int)this.offsetX);
        buffer.writeByte((int)this.offsetY);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setCharIndex(buffer.readInt());
        byte facing = buffer.readByte();
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.field_174861_a = new BlockPos(x, y, z);
        this.offsetX = buffer.readByte();
        this.offsetY = buffer.readByte();
        this.func_174859_a(EnumFacing.field_82609_l[facing]);
    }

    public ItemStack getStack() {
        return this.itemStack;
    }

    public void func_110128_b(Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_184185_a(OpenBlocks.Sounds.ENTITY_GLYPH_BREAK, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(this.itemStack.func_77946_l(), 0.0f);
        }
    }

    public void func_184523_o() {
        this.func_184185_a(OpenBlocks.Sounds.ENTITY_GLYPH_PLACE, 1.0f, 1.0f);
    }
}

