/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.hud;

import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.hud.IGuiOverlay;
import org.orecruncher.dsurround.client.hud.InspectionHUD;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public final class GuiHUDHandler {
    private static GuiHUDHandler INSTANCE;
    private final ObjectArray<IGuiOverlay> overlays = new ObjectArray(1);

    private GuiHUDHandler() {
        this.register(new InspectionHUD());
    }

    public void register(IGuiOverlay overlay) {
        this.overlays.add((Object)overlay);
    }

    public static void register() {
        INSTANCE = new GuiHUDHandler();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void unregister() {
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
            INSTANCE = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        this.overlays.forEach(o -> o.doRender(event));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        this.overlays.forEach(o -> o.doRender(event));
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        int tickRef = EnvironStateHandler.EnvironState.getTickCounter();
        this.overlays.forEach(o -> o.doTick(tickRef));
    }
}

