/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle.mote;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.particle.mote.MoteAgeable;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.registry.footstep.FootprintStyle;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class MoteFootprint
extends MoteAgeable {
    private static final float TEXEL_WIDTH = 0.125f;
    private static final float TEXEL_PRINT_WIDTH = 0.0625f;
    private static final float WIDTH = 0.125f;
    private static final float LENGTH = 0.25f;
    private static final Vec2f FIRST_POINT = new Vec2f(-0.125f, 0.25f);
    private static final Vec2f SECOND_POINT = new Vec2f(0.125f, 0.25f);
    private static final Vec2f THIRD_POINT = new Vec2f(0.125f, -0.25f);
    private static final Vec2f FOURTH_POINT = new Vec2f(-0.125f, -0.25f);
    private static float zFighter = 0.0f;
    protected final boolean isSnowLayer;
    protected final BlockPos downPos;
    protected final float texU1;
    protected final float texU2;
    protected final float texV1;
    protected final float texV2;
    protected final float scale;
    protected final Vec2f firstPoint;
    protected final Vec2f secondPoint;
    protected final Vec2f thirdPoint;
    protected final Vec2f fourthPoint;

    public MoteFootprint(@Nonnull FootprintStyle style, @Nonnull World world, double x, double y, double z, float rotation, float scale, boolean isRight) {
        super(world, x, y, z);
        IBlockState state;
        float f;
        this.maxAge = 200;
        zFighter += 1.0f;
        if (f > 20.0f) {
            zFighter = 1.0f;
        }
        this.isSnowLayer = (state = WorldUtils.getBlockState((World)this.world, (BlockPos)this.position)).func_177230_c() == Blocks.field_150431_aC;
        this.posY += (double)(zFighter * 0.001f);
        float fraction = (float)(y - (double)((int)y));
        this.downPos = this.isSnowLayer || fraction <= 0.0625f ? new BlockPos(this.posX, this.posY, this.posZ).func_177977_b() : this.position.func_185334_h();
        float u1 = (float)style.ordinal() * 0.125f + 0.00390625f;
        if (isRight) {
            u1 += 0.0625f;
        }
        this.texU1 = u1;
        this.texU2 = u1 + 0.0625f;
        this.texV1 = 0.0f;
        this.texV2 = 1.0f;
        this.scale = scale;
        float theRotation = MathStuff.toRadians((float)(-rotation + 180.0f));
        this.firstPoint = MathStuff.rotateScale((Vec2f)FIRST_POINT, (float)theRotation, (float)this.scale);
        this.secondPoint = MathStuff.rotateScale((Vec2f)SECOND_POINT, (float)theRotation, (float)this.scale);
        this.thirdPoint = MathStuff.rotateScale((Vec2f)THIRD_POINT, (float)theRotation, (float)this.scale);
        this.fourthPoint = MathStuff.rotateScale((Vec2f)FOURTH_POINT, (float)theRotation, (float)this.scale);
    }

    @Override
    protected boolean advanceAge() {
        if (Weather.isRaining()) {
            this.age = (int)((float)this.age + Weather.getIntensityLevel() * 100.0f / 25.0f);
        }
        return super.advanceAge();
    }

    @Override
    protected void update() {
        if (!ClientChunkCache.instance().func_180495_p(this.downPos).func_185904_a().func_76220_a()) {
            this.kill();
        } else if (this.isSnowLayer && ClientChunkCache.instance().func_180495_p((BlockPos)this.position).func_177230_c() != Blocks.field_150431_aC) {
            this.kill();
        }
    }

    @Override
    public void renderParticle(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        float f = ((float)this.age + partialTicks) / ((float)this.maxAge + 1.0f);
        f *= f;
        this.alpha = (int)(MathStuff.clamp((float)(1.0f - f), (float)0.0f, (float)1.0f) * 255.0f);
        this.alpha = (int)((float)this.alpha * 0.4f);
        double x = this.renderX(partialTicks);
        double y = this.renderY(partialTicks);
        double z = this.renderZ(partialTicks);
        this.drawVertex(buffer, x + (double)this.firstPoint.field_189982_i, y, z + (double)this.firstPoint.field_189983_j, this.texU1, this.texV2);
        this.drawVertex(buffer, x + (double)this.secondPoint.field_189982_i, y, z + (double)this.secondPoint.field_189983_j, this.texU2, this.texV2);
        this.drawVertex(buffer, x + (double)this.thirdPoint.field_189982_i, y, z + (double)this.thirdPoint.field_189983_j, this.texU2, this.texV1);
        this.drawVertex(buffer, x + (double)this.fourthPoint.field_189982_i, y, z + (double)this.fourthPoint.field_189983_j, this.texU1, this.texV1);
    }
}

