/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableBlockState
extends SyncableObjectBase
implements ISyncableValueProvider<IBlockState> {
    private static final String TAG_BLOCK_META = "Meta";
    private static final String TAG_BLOCK_ID = "Id";
    private IBlockState state = Blocks.field_150350_a.func_176223_P();

    @Override
    public void readFromStream(PacketBuffer buf) {
        int id = buf.func_150792_a();
        this.state = Block.func_176220_d((int)id);
    }

    @Override
    public void writeToStream(PacketBuffer buf) {
        int id = Block.func_176210_f((IBlockState)this.state);
        buf.func_150787_b(id);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        Block block = this.state.func_177230_c();
        int meta = block.func_176201_c(this.state);
        tag.func_74774_a(TAG_BLOCK_META, (byte)meta);
        ResourceLocation blockId = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        tag.func_74778_a(TAG_BLOCK_ID, blockId.toString());
        nbt.func_74782_a(name, (NBTBase)tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound tag;
        this.state = Blocks.field_150350_a.func_176223_P();
        if (nbt.func_150297_b(name, 10) && (tag = nbt.func_74775_l(name)).func_150297_b(TAG_BLOCK_ID, 8)) {
            ResourceLocation blockId = new ResourceLocation(tag.func_74779_i(TAG_BLOCK_ID));
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)blockId);
            int meta = tag.func_74771_c(TAG_BLOCK_META) & 0xFF;
            this.state = block.func_176203_a(meta);
        }
    }

    @Override
    public IBlockState getValue() {
        return this.state;
    }

    public void setValue(IBlockState state) {
        this.state = state;
        this.markDirty();
    }

    public boolean isAir() {
        return this.state == Blocks.field_150350_a.func_176223_P();
    }
}

