/*
 * Decompiled with CFR 0.152.
 */
package openmods.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.model.BakedModelAdapter;
import openmods.model.ModelUpdater;
import openmods.utils.CollectionUtils;

public final class MultiLayerModel
implements IModel {
    public static final MultiLayerModel EMPTY = new MultiLayerModel(Optional.empty(), (Map<BlockRenderLayer, ResourceLocation>)ImmutableMap.of());
    private final Optional<ResourceLocation> base;
    private final Map<BlockRenderLayer, ResourceLocation> models;

    public MultiLayerModel(Optional<ResourceLocation> base, Map<BlockRenderLayer, ResourceLocation> models) {
        this.base = base;
        this.models = ImmutableMap.copyOf(models);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.models.values(), CollectionUtils.asSet(this.base)));
    }

    private static IBakedModel bakeModel(ResourceLocation model, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel baseModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)model, (String)("Couldn't load MultiLayerModel dependency: " + model));
        return baseModel.bake((IModelState)new ModelStateComposition(state, baseModel.getDefaultState()), format, bakedTextureGetter);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Map bakedModels = Maps.transformValues(this.models, location -> MultiLayerModel.bakeModel(location, state, format, bakedTextureGetter));
        IModel missing = ModelLoaderRegistry.getMissingModel();
        IBakedModel bakedMissing = missing.bake(missing.getDefaultState(), format, bakedTextureGetter);
        IBakedModel bakedBase = this.base.isPresent() ? MultiLayerModel.bakeModel(this.base.get(), state, format, bakedTextureGetter) : bakedMissing;
        return new MultiLayerBakedModel(bakedModels, bakedBase, bakedMissing, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((IModelState)state));
    }

    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> base = updater.get("base", ModelUpdater.MODEL_LOCATION, this.base);
        HashMap models = Maps.newHashMap();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            ResourceLocation result = updater.get(layer.toString(), ModelUpdater.MODEL_LOCATION, this.models.get(layer));
            if (result == null) continue;
            models.put(layer, result);
        }
        return updater.hasChanged() ? new MultiLayerModel(base, models) : this;
    }

    private static final class MultiLayerBakedModel
    extends BakedModelAdapter {
        private final Map<BlockRenderLayer, IBakedModel> models;
        private final IBakedModel missing;
        private final List<BakedQuad> quads;

        public MultiLayerBakedModel(Map<BlockRenderLayer, IBakedModel> models, IBakedModel base, IBakedModel missing, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            super(base, cameraTransforms);
            this.models = ImmutableMap.copyOf(models);
            this.missing = missing;
            ArrayList quads = Lists.newArrayList();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                IBakedModel model = models.get(layer);
                if (model == null) continue;
                MultiLayerBakedModel.buildQuadsForLayer(quads, model);
            }
            this.quads = ImmutableList.copyOf((Collection)quads);
        }

        private static void buildQuadsForLayer(List<BakedQuad> quads, IBakedModel model) {
            quads.addAll(model.func_188616_a(null, null, 0L));
            for (EnumFacing side : EnumFacing.field_82609_l) {
                quads.addAll(model.func_188616_a(null, side, 0L));
            }
        }

        @Override
        @Nonnull
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                return side == null ? this.quads : ImmutableList.of();
            }
            IBakedModel model = this.models.get(layer);
            return ((IBakedModel)MoreObjects.firstNonNull((Object)model, (Object)this.missing)).func_188616_a(state, side, rand);
        }
    }
}

