/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.openmods.calc.Environment;
import info.openmods.calc.Frame;
import info.openmods.calc.symbol.BinaryFunction;
import info.openmods.calc.symbol.SingleReturnCallable;
import info.openmods.calc.symbol.TernaryFunction;
import info.openmods.calc.symbol.UnaryFunction;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.SimpleTypedFunction;
import info.openmods.calc.types.multi.Symbol;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedFunction;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.types.multi.TypedValueComparator;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LibListFunctions {
    private static final KeyFunction NULL_KEY_FUNCTION = new KeyFunction(){

        @Override
        public TypedValue apply(TypedValue value) {
            return value;
        }
    };

    private static MetaObject.SlotCall getCallableSlot(TypedValue functor) {
        MetaObject.SlotCall slotCall = functor.getMetaObject().slotCall;
        Preconditions.checkState((slotCall != null ? 1 : 0) != 0, (String)"Value %s is not callable", (Object)functor);
        return slotCall;
    }

    private static TypedValue executeUnaryCallable(Frame<TypedValue> frame, TypedValue callable, MetaObject.SlotCall slotCall, TypedValue arg) {
        Stack<TypedValue> stack = frame.stack();
        stack.push(arg);
        slotCall.call(callable, OptionalInt.ONE, OptionalInt.ONE, frame);
        return stack.pop();
    }

    public static void register(Environment<TypedValue> env) {
        final TypedValue nullValue = env.nullValue();
        final TypeDomain domain = nullValue.domain;
        env.setGlobalSymbol("map", (TypedValue)((Object)new BinaryFunction.WithFrame<TypedValue>(){

            @Override
            protected TypedValue call(final Frame<TypedValue> frame, final TypedValue functor, TypedValue list) {
                final MetaObject.SlotCall slotCall = LibListFunctions.getCallableSlot(functor);
                final Stack<TypedValue> stack = frame.stack();
                return new Cons.RecursiveVisitor(nullValue){

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        TypedValue result = LibListFunctions.executeUnaryCallable(frame, functor, slotCall, head);
                        stack.checkIsEmpty();
                        return Cons.create(domain, result, this.process(tail));
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("filter", (TypedValue)((Object)new BinaryFunction.WithFrame<TypedValue>(){

            @Override
            protected TypedValue call(final Frame<TypedValue> frame, final TypedValue predicate, TypedValue list) {
                final MetaObject.SlotCall slotCall = LibListFunctions.getCallableSlot(predicate);
                final Stack<TypedValue> stack = frame.stack();
                return new Cons.RecursiveVisitor(nullValue){

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        TypedValue result = LibListFunctions.executeUnaryCallable(frame, predicate, slotCall, head);
                        boolean shouldKeep = MetaObjectUtils.boolValue(frame, result);
                        stack.checkIsEmpty();
                        return shouldKeep ? Cons.create(domain, head, this.process(tail)) : this.process(tail);
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("reduce", (TypedValue)((Object)new TernaryFunction.WithFrame<TypedValue>(){

            @Override
            protected TypedValue call(final Frame<TypedValue> frame, final TypedValue functor, final TypedValue initialValue, TypedValue list) {
                final MetaObject.SlotCall slotCall = functor.getMetaObject().slotCall;
                final Stack<TypedValue> stack = frame.stack();
                return new Cons.RecursiveVisitor(nullValue){
                    private TypedValue result;
                    {
                        super(nullValue);
                        this.result = initialValue;
                    }

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        stack.push(this.result);
                        stack.push(head);
                        slotCall.call(functor, OptionalInt.TWO, OptionalInt.ONE, frame);
                        this.result = (TypedValue)stack.pop();
                        return this.process(tail);
                    }

                    @Override
                    protected TypedValue processEnd() {
                        return this.result;
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("take", (TypedValue)((Object)new BinaryFunction.WithFrame<TypedValue>(){

            @Override
            public TypedValue call(Frame<TypedValue> frame, TypedValue list, TypedValue countArg) {
                final int count = countArg.as(BigInteger.class).intValue();
                Preconditions.checkState((count >= 0 ? 1 : 0) != 0, (String)"Invalid count: %s", (int)count);
                return new Cons.RecursiveVisitor(nullValue){
                    private int countdown;
                    {
                        super(nullValue);
                        this.countdown = count;
                    }

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        if (this.countdown-- == 0) {
                            return nullValue;
                        }
                        return Cons.create(domain, head, this.process(tail));
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("takeWhile", (TypedValue)((Object)new BinaryFunction.WithFrame<TypedValue>(){

            @Override
            public TypedValue call(final Frame<TypedValue> frame, TypedValue list, final TypedValue predicate) {
                final MetaObject.SlotCall slotCall = LibListFunctions.getCallableSlot(predicate);
                final Stack<TypedValue> stack = frame.stack();
                return new Cons.RecursiveVisitor(nullValue){

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        TypedValue result = LibListFunctions.executeUnaryCallable(frame, predicate, slotCall, head);
                        boolean shouldContinue = MetaObjectUtils.boolValue(frame, result);
                        stack.checkIsEmpty();
                        return shouldContinue ? Cons.create(domain, head, this.process(tail)) : nullValue;
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("drop", (TypedValue)((Object)new BinaryFunction.WithFrame<TypedValue>(){

            @Override
            public TypedValue call(Frame<TypedValue> frame, TypedValue list, TypedValue countArg) {
                final int count = countArg.as(BigInteger.class).intValue();
                if (count == 0) {
                    return list;
                }
                Preconditions.checkState((count > 0 ? 1 : 0) != 0, (String)"Invalid count: %s", (int)count);
                return new Cons.RecursiveVisitor(nullValue){
                    private int countdown;
                    {
                        super(nullValue);
                        this.countdown = count;
                    }

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        if (--this.countdown <= 0) {
                            return tail;
                        }
                        return this.process(tail);
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("dropWhile", (TypedValue)((Object)new BinaryFunction.WithFrame<TypedValue>(){

            @Override
            public TypedValue call(final Frame<TypedValue> frame, TypedValue list, final TypedValue predicate) {
                final MetaObject.SlotCall slotCall = LibListFunctions.getCallableSlot(predicate);
                final Stack<TypedValue> stack = frame.stack();
                return new Cons.RecursiveVisitor(nullValue){

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        TypedValue result = LibListFunctions.executeUnaryCallable(frame, predicate, slotCall, head);
                        boolean shouldDrop = MetaObjectUtils.boolValue(frame, result);
                        stack.checkIsEmpty();
                        return shouldDrop ? this.process(tail) : Cons.create(domain, head, tail);
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("any", (TypedValue)((Object)new UnaryFunction.WithFrame<TypedValue>(){

            @Override
            public TypedValue call(final Frame<TypedValue> frame, TypedValue list) {
                boolean result = (Boolean)new Cons.TypedRecursiveVisitor<Boolean>(nullValue){

                    @Override
                    protected Boolean processValue(TypedValue head, TypedValue tail) {
                        boolean value = MetaObjectUtils.boolValue(frame, head);
                        return value || (Boolean)this.process(tail) != false;
                    }

                    @Override
                    protected Boolean processEnd() {
                        return false;
                    }
                }.process(list);
                return domain.create(Boolean.class, result);
            }
        }));
        env.setGlobalSymbol("all", (TypedValue)((Object)new UnaryFunction.WithFrame<TypedValue>(){

            @Override
            public TypedValue call(final Frame<TypedValue> frame, TypedValue list) {
                boolean result = (Boolean)new Cons.TypedRecursiveVisitor<Boolean>(nullValue){

                    @Override
                    protected Boolean processValue(TypedValue head, TypedValue tail) {
                        boolean value = MetaObjectUtils.boolValue(frame, head);
                        return value && (Boolean)this.process(tail) != false;
                    }

                    @Override
                    protected Boolean processEnd() {
                        return true;
                    }
                }.process(list);
                return domain.create(Boolean.class, result);
            }
        }));
        env.setGlobalSymbol("enumerate", (TypedValue)((Object)new UnaryFunction.WithFrame<TypedValue>(){

            @Override
            protected TypedValue call(Frame<TypedValue> frame, TypedValue list) {
                return new Cons.RecursiveVisitor(nullValue){
                    int count;
                    {
                        super(nullValue);
                        this.count = 0;
                    }

                    @Override
                    protected TypedValue processValue(TypedValue head, TypedValue tail) {
                        TypedValue wrappedCount = domain.create(BigInteger.class, BigInteger.valueOf(this.count++));
                        TypedValue enumeratedPair = Cons.create(domain, wrappedCount, head);
                        return Cons.create(domain, enumeratedPair, this.process(tail));
                    }
                }.process(list);
            }
        }));
        env.setGlobalSymbol("range", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue range(BigInteger stop) {
                return this.range(0, stop.intValue(), 1);
            }

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue range(BigInteger start, @TypedFunction.DispatchArg BigInteger stop) {
                return this.range(start.intValue(), stop.intValue(), 1);
            }

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue range(BigInteger start, BigInteger stop, @TypedFunction.DispatchArg BigInteger step) {
                return this.range(start.intValue(), stop.intValue(), step.intValue());
            }

            private TypedValue range(int start, int stop, int step) {
                Preconditions.checkState((step != 0 ? 1 : 0) != 0, (Object)"Step cannot be 0");
                ArrayList result = Lists.newArrayList();
                if (stop >= start) {
                    if (step < 0) {
                        return nullValue;
                    }
                    for (int i = start; i < stop; i += step) {
                        result.add(domain.create(BigInteger.class, BigInteger.valueOf(i)));
                    }
                } else {
                    if (step > 0) {
                        return nullValue;
                    }
                    for (int i = start; i > stop; i += step) {
                        result.add(domain.create(BigInteger.class, BigInteger.valueOf(i)));
                    }
                }
                return Cons.createList(result, nullValue);
            }
        }));
        env.setGlobalSymbol("zip", (TypedValue)((Object)new BinaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue left, TypedValue right) {
                Iterator<TypedValue> leftIt = Cons.toIterable(left, nullValue).iterator();
                Iterator<TypedValue> rightIt = Cons.toIterable(right, nullValue).iterator();
                ArrayList result = Lists.newArrayList();
                while (leftIt.hasNext() && rightIt.hasNext()) {
                    result.add(Cons.create(domain, leftIt.next(), rightIt.next()));
                }
                return Cons.createList(result, nullValue);
            }
        }));
        env.setGlobalSymbol("flatten", (TypedValue)((Object)new SingleReturnCallable<TypedValue>(){

            @Override
            public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
                Preconditions.checkArgument((boolean)argumentsCount.isPresent(), (Object)"'flatten' required argument count");
                Stack<TypedValue> values = frame.stack().substack(argumentsCount.get());
                ArrayList result = Lists.newArrayList();
                for (TypedValue value : values) {
                    Iterables.addAll((Collection)result, Cons.toIterable(value, nullValue));
                }
                values.clear();
                return Cons.createList(result, nullValue);
            }
        }));
        env.setGlobalSymbol("sort", (TypedValue)((Object)new SingleReturnCallable<TypedValue>(){

            @Override
            public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
                int args = argumentsCount.or(1);
                Preconditions.checkState((args >= 1 ? 1 : 0) != 0, (Object)"'sort' expects at least one argument");
                Stack<TypedValue> stack = frame.stack().substack(args);
                HashMap kwdArgs = Maps.newHashMap();
                for (int i = 0; i < args - 1; ++i) {
                    TypedValue arg = stack.pop();
                    Cons keyValuePair = arg.as(Cons.class, "optional arg");
                    kwdArgs.put(keyValuePair.car.as(Symbol.class, (String)"optional arg name").value, keyValuePair.cdr);
                }
                TypedValue list = stack.pop();
                List elements = Lists.newArrayList(Cons.toIterable(list, nullValue));
                TypedValue keyFunctionArg = (TypedValue)kwdArgs.get("key");
                KeyFunction keyFunction = this.extractKeyFunction(frame, stack, keyFunctionArg);
                TypedValue compareFunctionArg = (TypedValue)kwdArgs.get("cmp");
                Comparator<TypedValue> compareFunction = this.extractCompareFunction(frame, stack, compareFunctionArg);
                Collections.sort(elements, new CompositeComparator(keyFunction, compareFunction));
                TypedValue reverse = (TypedValue)kwdArgs.get("reverse");
                if (reverse != null && MetaObjectUtils.boolValue(frame, reverse)) {
                    elements = Lists.reverse((List)elements);
                }
                return Cons.createList(elements, nullValue);
            }

            private Comparator<TypedValue> extractCompareFunction(final Frame<TypedValue> frame, final Stack<TypedValue> stack, final TypedValue compareFunctionArg) {
                if (compareFunctionArg != null) {
                    final MetaObject.SlotCall slotCall = compareFunctionArg.getMetaObject().slotCall;
                    Preconditions.checkState((slotCall != null ? 1 : 0) != 0, (String)"'Compare function' argument %s is not callable", (Object)compareFunctionArg);
                    return new Comparator<TypedValue>(){

                        @Override
                        public int compare(TypedValue o1, TypedValue o2) {
                            stack.push(o1);
                            stack.push(o2);
                            slotCall.call(compareFunctionArg, OptionalInt.TWO, OptionalInt.ONE, frame);
                            TypedValue result = (TypedValue)stack.popAndExpectEmptyStack();
                            return result.unwrap(BigInteger.class).intValue();
                        }
                    };
                }
                return new TypedValueComparator();
            }

            private KeyFunction extractKeyFunction(final Frame<TypedValue> frame, final Stack<TypedValue> stack, final TypedValue keyFunctionArg) {
                if (keyFunctionArg != null) {
                    final MetaObject.SlotCall slotCall = keyFunctionArg.getMetaObject().slotCall;
                    Preconditions.checkState((slotCall != null ? 1 : 0) != 0, (String)"'Key function' argument %s is not callable", (Object)keyFunctionArg);
                    return new KeyFunction(){

                        @Override
                        public TypedValue apply(TypedValue value) {
                            stack.push(value);
                            slotCall.call(keyFunctionArg, OptionalInt.ONE, OptionalInt.ONE, frame);
                            return (TypedValue)stack.popAndExpectEmptyStack();
                        }
                    };
                }
                return NULL_KEY_FUNCTION;
            }
        }));
        env.setGlobalSymbol("reverse", (TypedValue)((Object)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                TypedValue result = nullValue;
                for (TypedValue v : Cons.toIterable(value, nullValue)) {
                    result = Cons.create(domain, v, result);
                }
                return result;
            }
        }));
    }

    private static class CompositeComparator
    implements Comparator<TypedValue> {
        private final KeyFunction keyFunction;
        private final Comparator<TypedValue> compareFunction;

        public CompositeComparator(KeyFunction keyFunction, Comparator<TypedValue> compareFunction) {
            this.keyFunction = keyFunction;
            this.compareFunction = compareFunction;
        }

        @Override
        public int compare(TypedValue o1, TypedValue o2) {
            TypedValue c1 = this.keyFunction.apply(o1);
            TypedValue c2 = this.keyFunction.apply(o2);
            return this.compareFunction.compare(c1, c2);
        }
    }

    private static interface KeyFunction {
        public TypedValue apply(TypedValue var1);
    }
}

