/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum PipeFlowRendererPower implements IPipeFlowRenderer<PipeFlowPower>
{
    INSTANCE;


    public void render(PipeFlowPower flow, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        double centrePower = 0.0;
        double[] power = new double[6];
        for (EnumFacing side : EnumFacing.values()) {
            PipeFlowPower.Section s = flow.getSection(side);
            int i = side.ordinal();
            power[i] = (double)s.displayPower / (double)MjAPI.MJ;
            centrePower = Math.max(centrePower, power[i]);
        }
        bb.func_178969_c(x, y, z);
        if (centrePower > 0.0) {
            for (EnumFacing side : EnumFacing.values()) {
                if (!flow.pipe.isConnected(side)) continue;
                int i = side.ordinal();
                PipeFlowPower.Section s = flow.getSection(side);
                double offset = MathUtil.interp((double)partialTicks, (double)s.clientDisplayFlowLast, (double)s.clientDisplayFlow);
                PipeFlowRendererPower.renderSidePower(side, power[i], centrePower, offset, bb);
            }
            PipeFlowRendererPower.renderCentrePower(centrePower, flow.clientDisplayFlowCentre, bb);
        }
        bb.func_178969_c(0.0, 0.0, 0.0);
    }

    private static void renderSidePower(EnumFacing side, double power, double centrePower, double offset, BufferBuilder bb) {
        if (power < 0.0) {
            return;
        }
        boolean overload = false;
        double radius = 0.248 * power;
        if (radius >= 0.248) {
            radius = 0.248;
        }
        TextureAtlasSprite sprite = (overload ? BCTransportSprites.POWER_FLOW_OVERLOAD : BCTransportSprites.POWER_FLOW).getSprite();
        double centreRadius = 0.252 - 0.248 * centrePower;
        Vec3d centre = VecUtil.offset((Vec3d)VecUtil.VEC_HALF, (EnumFacing)side, (double)(0.375 - centreRadius / 2.0));
        Vec3d radiusV = new Vec3d(radius, radius, radius);
        radiusV = VecUtil.replaceValue((Vec3d)radiusV, (EnumFacing.Axis)side.func_176740_k(), (double)(0.125 + centreRadius / 2.0));
        Point3f centreF = new Point3f((float)centre.field_72450_a, (float)centre.field_72448_b, (float)centre.field_72449_c);
        Point3f radiusF = new Point3f((float)radiusV.field_72450_a, (float)radiusV.field_72448_b, (float)radiusV.field_72449_c);
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        for (EnumFacing face : EnumFacing.values()) {
            if (face == side.func_176734_d()) continue;
            AxisAlignedBB box = new AxisAlignedBB(centre.func_178788_d(radiusV).func_186678_a(0.5), centre.func_178787_e(radiusV).func_186678_a(0.5));
            box = box.func_191194_a(VecUtil.offset((Vec3d)Vec3d.field_186680_a, (EnumFacing)side, (double)(offset * (double)side.func_176743_c().func_179524_a() / 32.0)));
            ModelUtil.mapBoxToUvs((AxisAlignedBB)box, (EnumFacing)face, (ModelUtil.UvFaceData)uvs);
            MutableQuad quad = ModelUtil.createFace((EnumFacing)face, (Tuple3f)centreF, (Tuple3f)radiusF, (ModelUtil.UvFaceData)uvs);
            quad.texFromSprite(sprite);
            quad.lighti(15, 15);
            quad.render(bb);
        }
    }

    private static void renderCentrePower(double power, Vec3d offset, BufferBuilder bb) {
        boolean overload = false;
        float radius = 0.248f * (float)power;
        if (radius > 0.248f) {
            radius = 0.248f;
        }
        TextureAtlasSprite sprite = (overload ? BCTransportSprites.POWER_FLOW_OVERLOAD : BCTransportSprites.POWER_FLOW).getSprite();
        Point3f centre = new Point3f(0.5f, 0.5f, 0.5f);
        Point3f radiusP = new Point3f(radius, radius, radius);
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        for (EnumFacing face : EnumFacing.values()) {
            AxisAlignedBB box = new AxisAlignedBB(new Vec3d(0.5 - (double)radius, 0.5 - (double)radius, 0.5 - (double)radius).func_186678_a(0.5), new Vec3d(0.5 + (double)radius, 0.5 + (double)radius, 0.5 + (double)radius).func_186678_a(0.5));
            box = box.func_191194_a(offset.func_186678_a(0.03125));
            ModelUtil.mapBoxToUvs((AxisAlignedBB)box, (EnumFacing)face, (ModelUtil.UvFaceData)uvs);
            MutableQuad quad = ModelUtil.createFace((EnumFacing)face, (Tuple3f)centre, (Tuple3f)radiusP, (ModelUtil.UvFaceData)uvs);
            quad.texFromSprite(sprite);
            quad.lighti(15, 15);
            quad.render(bb);
        }
    }
}

