/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model.key;

import buildcraft.api.transport.pipe.EnumPipeColourType;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeFaceTex;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class PipeModelKey {
    public static final PipeModelKey DEFAULT_KEY;
    public final PipeDefinition definition;
    public final PipeFaceTex center;
    public final PipeFaceTex[] sides;
    public final float[] connected;
    public final EnumDyeColor colour;
    private final int hash;

    public PipeModelKey(PipeDefinition definition, PipeFaceTex center, PipeFaceTex[] sides, float[] connected, EnumDyeColor colour) {
        this.definition = definition;
        this.center = center;
        this.sides = sides;
        this.connected = connected;
        this.colour = colour;
        this.hash = Arrays.hashCode(new int[]{Objects.hashCode(definition), Objects.hashCode(center), Arrays.hashCode(sides), Arrays.hashCode(connected), Objects.hashCode(colour)});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PipeModelKey other = (PipeModelKey)obj;
        if (this.definition != other.definition) {
            return false;
        }
        if (this.center != other.center) {
            return false;
        }
        if (!Arrays.equals(this.sides, other.sides)) {
            return false;
        }
        if (!Arrays.equals(this.connected, other.connected)) {
            return false;
        }
        return this.colour == other.colour;
    }

    public int hashCode() {
        return this.hash;
    }

    public EnumPipeColourType getColourType() {
        if (this.definition != null) {
            return this.definition.getColourType();
        }
        return EnumPipeColourType.TRANSLUCENT;
    }

    static {
        PipeFaceTex sprite = PipeFaceTex.get((int)0);
        PipeFaceTex[] sides = new PipeFaceTex[]{sprite, sprite, sprite, sprite, sprite, sprite};
        float[] connected = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        DEFAULT_KEY = new PipeModelKey(null, sprite, sides, connected, null);
    }
}

