/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.pipe.IPipeBehaviourRenderer;
import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.api.transport.pipe.PipeApiClient;
import buildcraft.api.transport.pluggable.IPluggableStaticBaker;
import buildcraft.lib.client.model.ModelHolderStatic;
import buildcraft.lib.client.model.ModelHolderVariable;
import buildcraft.lib.client.model.ModelPluggableItem;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.plug.PlugBakerSimple;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import buildcraft.lib.misc.RenderUtil;
import buildcraft.transport.BCTransportBlocks;
import buildcraft.transport.client.PipeBlockColours;
import buildcraft.transport.client.model.ModelPipe;
import buildcraft.transport.client.model.ModelPipeItem;
import buildcraft.transport.client.model.key.KeyPlugBlocker;
import buildcraft.transport.client.model.key.KeyPlugPowerAdaptor;
import buildcraft.transport.client.render.PipeBehaviourRendererStripes;
import buildcraft.transport.client.render.PipeFlowRendererFluids;
import buildcraft.transport.client.render.PipeFlowRendererItems;
import buildcraft.transport.client.render.PipeFlowRendererPower;
import buildcraft.transport.client.render.RenderPipeHolder;
import buildcraft.transport.pipe.behaviour.PipeBehaviourStripes;
import buildcraft.transport.pipe.flow.PipeFlowFluids;
import buildcraft.transport.pipe.flow.PipeFlowItems;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import buildcraft.transport.tile.TilePipeHolder;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCTransportModels {
    public static final ModelHolderStatic BLOCKER = BCTransportModels.getStaticModel("plugs/blocker");
    public static final ModelHolderStatic POWER_ADAPTER = BCTransportModels.getStaticModel("plugs/power_adapter");
    private static final ModelHolderVariable STRIPES;
    private static final NodeVariableObject<EnumFacing> STRIPES_DIRECTION;
    public static final IPluggableStaticBaker<KeyPlugBlocker> BAKER_PLUG_BLOCKER;
    public static final IPluggableStaticBaker<KeyPlugPowerAdaptor> BAKER_PLUG_POWER_ADAPTOR;

    private static ModelHolderStatic getStaticModel(String str) {
        return new ModelHolderStatic("buildcrafttransport:models/" + str + ".json");
    }

    private static ModelHolderVariable getModel(String str, FunctionContext fnCtx) {
        return new ModelHolderVariable("buildcrafttransport:models/" + str + ".json", fnCtx);
    }

    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCTransportModels.class);
    }

    public static void fmlInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TilePipeHolder.class, (TileEntitySpecialRenderer)new RenderPipeHolder());
        PipeApiClient.registry.registerBaker(KeyPlugBlocker.class, BAKER_PLUG_BLOCKER);
        PipeApiClient.registry.registerBaker(KeyPlugPowerAdaptor.class, BAKER_PLUG_POWER_ADAPTOR);
        PipeApiClient.registry.registerRenderer(PipeFlowItems.class, (IPipeFlowRenderer)PipeFlowRendererItems.INSTANCE);
        PipeApiClient.registry.registerRenderer(PipeFlowFluids.class, (IPipeFlowRenderer)PipeFlowRendererFluids.INSTANCE);
        PipeApiClient.registry.registerRenderer(PipeFlowPower.class, (IPipeFlowRenderer)PipeFlowRendererPower.INSTANCE);
        PipeApiClient.registry.registerRenderer(PipeBehaviourStripes.class, (IPipeBehaviourRenderer)PipeBehaviourRendererStripes.INSTANCE);
    }

    public static void fmlPostInit() {
        RenderUtil.registerBlockColour((Block)BCTransportBlocks.pipeHolder, (IBlockColor)PipeBlockColours.INSTANCE);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        BCTransportModels.putModel(event, "pipe_holder#normal", ModelPipe.INSTANCE);
        BCTransportModels.putModel(event, "pipe_item#inventory", ModelPipeItem.INSTANCE);
        BCTransportModels.putModel(event, "plug_blocker#inventory", (IBakedModel)new ModelPluggableItem((MutableQuad[][])new MutableQuad[][]{BLOCKER.getCutoutQuads()}));
        BCTransportModels.putModel(event, "plug_power_adaptor#inventory", (IBakedModel)new ModelPluggableItem((MutableQuad[][])new MutableQuad[][]{POWER_ADAPTER.getCutoutQuads()}));
    }

    private static void putModel(ModelBakeEvent event, String str, IBakedModel model) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("buildcrafttransport:" + str), (Object)model);
    }

    public static MutableQuad[] getStripesDynQuads(EnumFacing side) {
        BCTransportModels.STRIPES_DIRECTION.value = side;
        return STRIPES.getCutoutQuads();
    }

    static {
        BAKER_PLUG_BLOCKER = new PlugBakerSimple(() -> ((ModelHolderStatic)BLOCKER).getCutoutQuads());
        BAKER_PLUG_POWER_ADAPTOR = new PlugBakerSimple(() -> ((ModelHolderStatic)POWER_ADAPTER).getCutoutQuads());
        FunctionContext fnCtx = DefaultContexts.createWithAll();
        STRIPES_DIRECTION = fnCtx.putVariableObject("side", EnumFacing.class);
        STRIPES = BCTransportModels.getModel("pipes/stripes", fnCtx);
    }
}

