/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.interblock;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.compatibility.CompatClientHelper;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.entity.chunkdata.ChunkDataModuleManager;
import com.rwtema.extrautils2.entity.chunkdata.EntityChunkData;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.GuiHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.items.ItemFlatTransferNode;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessEmptyGlowing;
import com.rwtema.extrautils2.utils.client.GLStateAttributes;
import com.rwtema.extrautils2.utils.datastructures.nbt.NBTSerializer;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class FlatTransferNodeHandler
extends ChunkDataModuleManager<Multimap<BlockPos, FlatTransferNode>> {
    public static final FlatTransferNodeHandler INSTANCE = new FlatTransferNodeHandler();
    public static int[] guiIdSides = new int[6];
    static Processer<IItemHandler> itemHandlerProcesser = new Processer<IItemHandler>(CapGetter.ItemHandler){

        @Override
        public void transfer(World world, TileEntity input, TileEntity output, IItemHandler inputCap, IItemHandler outputCap, SingleStackHandlerFilter.EitherFilter filter) {
            for (int i = 0; i < inputCap.getSlots(); ++i) {
                ItemStack insert;
                ItemStack extractItem = inputCap.extractItem(i, 1, true);
                if (!StackHelper.isNonNull(extractItem) || !filter.matches(extractItem) || StackHelper.isNonNull(insert = InventoryHelper.insert(outputCap, extractItem, true)) || StackHelper.isNull(extractItem = inputCap.extractItem(i, 1, false))) continue;
                insert = InventoryHelper.insert(outputCap, extractItem, false);
                if (StackHelper.isNonNull(insert) && StackHelper.isNonNull(insert = inputCap.insertItem(i, insert, false))) {
                    BlockPos pos = input.func_174877_v();
                    InventoryHelper.dropItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), insert);
                }
                return;
            }
        }
    };
    static Processer<IFluidHandler> fluidHandlerProcesser = new Processer<IFluidHandler>(CapGetter.FluidHandler){

        @Override
        public void transfer(World world, TileEntity input, TileEntity output, IFluidHandler inputCap, IFluidHandler outputCap, SingleStackHandlerFilter.EitherFilter filter) {
            int amount;
            FluidStack drain;
            if (filter.hasFilter()) {
                drain = null;
                for (IFluidTankProperties properties : inputCap.getTankProperties()) {
                    FluidStack contents;
                    if (!properties.canDrain() || (contents = properties.getContents()) == null || contents.amount <= 0 || !filter.matches(contents)) continue;
                    FluidStack copy = contents.copy();
                    copy.amount = 200;
                    drain = inputCap.drain(copy, false);
                }
            } else {
                drain = inputCap.drain(200, false);
            }
            if (drain != null && drain.amount > 0 && (amount = outputCap.fill(drain, false)) > 0) {
                outputCap.fill(inputCap.drain(amount, true), true);
            }
        }
    };

    public void init() {
        for (EnumFacing facing : EnumFacing.values()) {
            FlatTransferNodeHandler.guiIdSides[facing.ordinal()] = GuiHandler.register("flatTransferNodes_" + facing, (ID2, player, world, x, y, z) -> {
                BlockPos pos = new BlockPos(x, y, z);
                Multimap<BlockPos, FlatTransferNode> flatTransferNodes = EntityChunkData.getChunkData(world.func_175726_f(pos), this, false);
                for (final FlatTransferNode flatTransferNode : flatTransferNodes.get((Object)pos)) {
                    if (flatTransferNode.side != facing || !pos.equals((Object)flatTransferNode.pos)) continue;
                    return new DynamicContainer(){
                        {
                            this.addTitle(Lang.getItemName(flatTransferNode.getDrop()));
                            this.addWidget(flatTransferNode.filter.newSlot(76, 13));
                            this.cropAndAddPlayerSlots(player.field_71071_by);
                            this.validate();
                        }

                        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
                            return !flatTransferNode.isDead;
                        }
                    };
                }
                return null;
            });
        }
    }

    @Override
    public Multimap<BlockPos, FlatTransferNode> getCachedBlank() {
        return ImmutableMultimap.of();
    }

    @Override
    public Multimap<BlockPos, FlatTransferNode> createBlank() {
        return LinkedListMultimap.create();
    }

    @Override
    public boolean onUpdate(Chunk chunk, Multimap<BlockPos, FlatTransferNode> entries) {
        if (entries.isEmpty()) {
            return true;
        }
        ArrayList nodes = new ArrayList(entries.values());
        Collections.shuffle(nodes);
        for (FlatTransferNode node2 : nodes) {
            try {
                if (node2.isDead || !node2.process(chunk.func_177412_p())) continue;
                node2.dropItemStack(chunk.func_177412_p());
                EntityChunkData.markChunkDirty(chunk);
                node2.isDead = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                node2.isDead = true;
            }
        }
        entries.values().removeIf(node -> node.isDead);
        return entries.isEmpty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientTick(Chunk chunk, Multimap<BlockPos, FlatTransferNode> data) {
    }

    @Override
    public void writeToNBT(NBTTagCompound base, Multimap<BlockPos, FlatTransferNode> entries) {
        base.func_74782_a("entries", (NBTBase)NBTHelper.createList(entries.values(), FlatTransferNode::serializeNBT));
    }

    @Override
    public Multimap<BlockPos, FlatTransferNode> readFromNBT(NBTTagCompound tag) {
        Multimap<BlockPos, FlatTransferNode> multimap = this.createBlank();
        for (FlatTransferNode node : NBTHelper.processList(tag.func_150295_c("entries", 10), () -> new FlatTransferNode())) {
            multimap.put((Object)node.pos, (Object)node);
        }
        return multimap;
    }

    @Override
    public void writeData(Multimap<BlockPos, FlatTransferNode> data, XUPacketBuffer buffer) {
        Collection values = data.values();
        buffer.writeInt(values.size());
        for (FlatTransferNode node : values) {
            buffer.writeBlockPos(node.pos);
            buffer.writeByte(node.side.ordinal());
            buffer.writeByte(node.type.ordinal());
            buffer.writeBoolean(node.extract);
        }
    }

    @Override
    public void readData(Multimap<BlockPos, FlatTransferNode> data, XUPacketBuffer buffer) {
        int n = buffer.readInt();
        for (int i = 0; i < n; ++i) {
            BlockPos pos = buffer.readBlockPos();
            EnumFacing facing = EnumFacing.values()[buffer.readByte()];
            FlatTransferNode.Type type = FlatTransferNode.Type.values()[buffer.readByte()];
            boolean extract = buffer.readBoolean();
            data.put((Object)pos, (Object)new FlatTransferNode(pos, facing, type, extract));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        List entities = world.func_175644_a(EntityChunkData.class, t -> t != null && t.hasData(this));
        if (entities.isEmpty()) {
            return;
        }
        Entity entityIn = Minecraft.func_71410_x().func_175606_aa();
        if (entityIn == null) {
            return;
        }
        FlatTransferNode selectedNode = null;
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            boolean holding = false;
            for (ItemStack stack : new ItemStack[]{player.func_184614_ca(), player.func_184592_cb()}) {
                Item item;
                if (!StackHelper.isNonNull(stack) || (item = stack.func_77973_b()) != XU2Entries.flatTransferNode.value && (!XU2Entries.wrench.isActive() || item != XU2Entries.wrench.value)) continue;
                holding = true;
                break;
            }
            if (holding) {
                selectedNode = ItemFlatTransferNode.getCurrentFlatTransferNode(player);
            }
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        IVertexBuffer vertexbuffer = IVertexBuffer.getVertexBuffer(tessellator);
        float partialTicks = event.getPartialTicks();
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLStateAttributes attributes = GLStateAttributes.loadStates();
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)false);
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        MutableModel model = new MutableModel(Transforms.blockTransforms);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        for (EntityChunkData data : entities) {
            Multimap<BlockPos, FlatTransferNode> data1 = data.getData(this);
            for (FlatTransferNode node : data1.values()) {
                Object access;
                boolean isSelected;
                boolean bl = isSelected = selectedNode == node;
                if (isSelected) {
                    GlStateManager.func_179097_i();
                    Minecraft.func_71410_x().field_71460_t.func_175072_h();
                    access = BlockAccessEmptyGlowing.INSTANCE;
                } else {
                    access = world;
                }
                int i = access.func_175626_b(node.pos, 0);
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                EnumFacing texDirection = node.extract ? EnumFacing.UP : EnumFacing.DOWN;
                vertexbuffer.begin(7, DefaultVertexFormats.field_176600_a);
                vertexbuffer.setTranslation(-d0, -d1, -d2);
                BoxModel boxes = new BoxModel();
                boxes.addBox(0.0f, -9.765625E-4f, 0.0f, 1.0f, 9.765625E-4f, 1.0f, node.type == FlatTransferNode.Type.ITEM ? "transfernodes/flat_transfernode_items" : "transfernodes/flat_transfernode_fluids").setTextureSides(texDirection, "transfernodes/flat_transfernode_back");
                if (isSelected) {
                    Box box = boxes.addBox(0.0f, -9.765625E-4f, 0.0f, 1.0f, 9.765625E-4f, 1.0f, "transfernodes/flat_transfernode_selection");
                    box.setInvisible(texDirection);
                    box.color = -16711936;
                    box = boxes.addBox(0.0f, -9.765625E-4f, 0.0f, 1.0f, 9.765625E-4f, 1.0f, "transfernodes/flat_transfernode_selection");
                    box.setInvisible(texDirection.func_176734_d());
                    box.color = -16776961;
                }
                boxes.rotateToSide(node.side);
                boxes.loadIntoMutable(model, null);
                dispatcher.func_175019_b().func_178267_a((IBlockAccess)access, (IBakedModel)model, Blocks.field_150350_a.func_176223_P(), node.pos, CompatClientHelper.unwrap(vertexbuffer), false);
                tessellator.func_78381_a();
                vertexbuffer.setTranslation(0.0, 0.0, 0.0);
                if (!isSelected) continue;
                Minecraft.func_71410_x().field_71460_t.func_180436_i();
                GlStateManager.func_179126_j();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179103_j((int)7424);
        attributes.restore();
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static abstract class Processer<T> {
        final CapGetter<T> capGetter;

        public Processer(CapGetter<T> capGetter) {
            this.capGetter = capGetter;
        }

        public void process(World world, TileEntity input, TileEntity output, EnumFacing direction, SingleStackHandlerFilter.EitherFilter filter) {
            T outputCap;
            if (!this.capGetter.hasInterface((ICapabilityProvider)input, direction) || !this.capGetter.hasInterface((ICapabilityProvider)output, direction.func_176734_d())) {
                return;
            }
            T inputCap = this.capGetter.getInterface((ICapabilityProvider)input, direction);
            if (inputCap == (outputCap = this.capGetter.getInterface((ICapabilityProvider)output, direction.func_176734_d())) || inputCap.equals(outputCap)) {
                return;
            }
            this.transfer(world, input, output, inputCap, outputCap, filter);
        }

        public abstract void transfer(World var1, TileEntity var2, TileEntity var3, T var4, T var5, SingleStackHandlerFilter.EitherFilter var6);
    }

    public static class FlatTransferNode
    implements INBTSerializable<NBTTagCompound> {
        static NBTSerializer<FlatTransferNode> serializer = new NBTSerializer<FlatTransferNode>(null).registerBlockPos("pos", t -> t.pos, (t, e) -> {
            t.pos = e;
        }).registerEnum("side", EnumFacing.class, t -> t.side, (t, e) -> {
            t.side = e;
        }).registerEnum("type", Type.class, t -> t.type, (t, e) -> {
            t.type = e;
        }).registerNBTSerializable("filter", t -> t.filter).registerBoolean("extract", t -> t.extract, (t, e) -> {
            t.extract = e;
        });
        public BlockPos pos;
        public EnumFacing side;
        public boolean extract;
        public SingleStackHandlerFilter.EitherFilter filter = new SingleStackHandlerFilter.EitherFilter();
        public Type type;
        public boolean isDead;
        @Nullable
        AxisAlignedBB bb;

        private FlatTransferNode() {
        }

        public FlatTransferNode(BlockPos pos, EnumFacing side, Type type, boolean extract) {
            this.pos = pos;
            this.side = side;
            this.type = type;
            this.extract = extract;
        }

        public void dropItemStack(World world) {
            InventoryHelper.dropItemStackAtPosition(world, this.getDrop(), (double)this.pos.func_177958_n() + 0.5 * (double)(1 + this.side.func_82601_c()), (double)this.pos.func_177956_o() + 0.5 * (double)(1 + this.side.func_96559_d()), (double)this.pos.func_177952_p() + 0.5 * (double)(1 + this.side.func_82599_e()));
            ItemStack filterStack = this.filter.getStack();
            if (StackHelper.isNonNull(filterStack)) {
                InventoryHelper.dropItemStackAtPosition(world, filterStack, (double)this.pos.func_177958_n() + 0.5 * (double)(1 + this.side.func_82601_c()), (double)this.pos.func_177956_o() + 0.5 * (double)(1 + this.side.func_96559_d()), (double)this.pos.func_177952_p() + 0.5 * (double)(1 + this.side.func_82599_e()));
            }
        }

        public AxisAlignedBB getBounds() {
            if (this.bb == null) {
                float x0 = 0.0f;
                float x1 = 1.0f;
                float y0 = 0.0f;
                float y1 = 1.0f;
                float z0 = 0.0f;
                float z1 = 1.0f;
                switch (this.side) {
                    case DOWN: {
                        y1 = 0.0f;
                        break;
                    }
                    case UP: {
                        y0 = 1.0f;
                        break;
                    }
                    case NORTH: {
                        z1 = 0.0f;
                        break;
                    }
                    case SOUTH: {
                        z0 = 1.0f;
                        break;
                    }
                    case WEST: {
                        x1 = 0.0f;
                        break;
                    }
                    case EAST: {
                        x0 = 1.0f;
                    }
                }
                this.bb = new AxisAlignedBB((double)(x0 += (float)this.pos.func_177958_n()), (double)(y0 += (float)this.pos.func_177956_o()), (double)(z0 += (float)this.pos.func_177952_p()), (double)(x1 += (float)this.pos.func_177958_n()), (double)(y1 += (float)this.pos.func_177956_o()), (double)(z1 += (float)this.pos.func_177952_p()));
            }
            return this.bb;
        }

        public NBTTagCompound serializeNBT() {
            return serializer.serialize(this);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            serializer.deserialize(this, nbt);
        }

        public boolean process(World world) {
            EnumFacing dir;
            TileEntity output;
            TileEntity input;
            long totalWorldTime = world.func_82737_E();
            if (totalWorldTime % 4L != 0L) {
                return false;
            }
            TileEntity owner = world.func_175625_s(this.pos);
            if (owner == null) {
                return true;
            }
            if (totalWorldTime % 10L != 0L) {
                return false;
            }
            TileEntity neighbour = world.func_175625_s(this.pos.func_177972_a(this.side));
            if (neighbour == null) {
                return false;
            }
            if (this.extract) {
                input = owner;
                output = neighbour;
                dir = this.side;
            } else {
                input = neighbour;
                output = owner;
                dir = this.side.func_176734_d();
            }
            switch (this.type) {
                case ITEM: {
                    itemHandlerProcesser.process(world, input, output, dir, this.filter);
                    break;
                }
                case FLUIDS: {
                    fluidHandlerProcesser.process(world, input, output, dir, this.filter);
                }
            }
            return false;
        }

        public ItemStack getDrop() {
            return XU2Entries.flatTransferNode.newStack(1, this.type.ordinal());
        }

        public static enum Type {
            ITEM,
            FLUIDS;

        }
    }
}

