/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.FontRainbow;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.tile.TileRainbowGenerator;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRainbowGenerator
extends XUBlockStatic {
    public static final PropertyEnumSimple<State> PROPERTY_STATE = new PropertyEnumSimple<State>(State.class);

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addDropProperties(new IProperty[]{PROPERTY_STATE}).build();
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        XUBlockState state = this.xuBlockState.getStateFromItemStack(stack);
        if (state.func_177229_b((IProperty)PROPERTY_STATE) != State.FULL) {
            return;
        }
        tooltip.add(Lang.translate("When all other generators are creating power, taste the unlimited power of the rainbow"));
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        switch ((State)((Object)state.func_177229_b(PROPERTY_STATE))) {
            case FULL: {
                return BoxModel.newStandardBlock("rainbow_generator");
            }
            case BOTTOM_HALF: {
                return new BoxModel(new Box(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f).setTextureSides("rainbow_generator", EnumFacing.UP, "rainbow_generator_center"));
            }
            case TOP_HALF: {
                return new BoxModel(new Box(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f).setTextureSides("rainbow_generator", EnumFacing.DOWN, "rainbow_generator_center"));
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(PROPERTY_STATE) == State.FULL;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileRainbowGenerator();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        if (this.xuBlockState.getStateFromItemStack(stack).func_177229_b((IProperty)PROPERTY_STATE) == State.FULL) {
            return FontRainbow.INSTANCE.init(true);
        }
        return null;
    }

    public static enum State {
        FULL,
        BOTTOM_HALF,
        TOP_HALF;

    }
}

