/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.NullModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class PassthruModelItem
extends NullModel {
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads2dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                if (sprite == null) {
                    sprite = Textures.MISSING_SPRITE;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h(), sprite));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g(), sprite));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> pseudoQuads2dCache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                if (sprite == null) {
                    sprite = Textures.MISSING_SPRITE;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h(), sprite));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g(), sprite));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads3dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                if (sprite == null) {
                    sprite = Textures.MISSING_SPRITE;
                }
                bakedQuads = ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, CompatHelper112.optionalOf(TRSRTransformation.identity()));
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuad>> tintedQuads = new TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuad>>(){

        public WeakHashMap<BakedQuad, BakedQuad> get(final int key) {
            WeakHashMap weakHashMap = (WeakHashMap)super.get(key);
            if (weakHashMap != null) {
                return weakHashMap;
            }
            weakHashMap = new WeakHashMap<BakedQuad, BakedQuad>(){

                @Override
                public BakedQuad get(Object quadKey) {
                    BakedQuad quadTint = (BakedQuad)super.get(quadKey);
                    if (quadTint != null) {
                        return quadTint;
                    }
                    BakedQuad quad = (BakedQuad)quadKey;
                    quadTint = new BakedQuad(quad.func_178209_a(), key, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
                    this.put(quad, quadTint);
                    return quadTint;
                }
            };
            this.put(key, weakHashMap);
            return weakHashMap;
        }
    };
    protected final IXUItem item;
    protected Supplier<ModelLayer> modelFactory;
    protected ItemOverrideList overrideList = new ItemOverrideList((List)ImmutableList.of()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            try {
                ModelLayer model = PassthruModelItem.this.modelFactory.get();
                PassthruModelItem.this.item.addQuads(model, stack, world, entity);
                return model;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Getting model for itemstack");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being processed");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)stack.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)stack.func_77960_j());
                crashreportcategory.func_189529_a("Item name", () -> ((ItemStack)stack).func_82833_r());
                throw new ReportedException(crashreport);
            }
        }
    };

    public PassthruModelItem(IXUItem item) {
        this(item, item.renderAsTool() ? Transforms.itemToolsTransforms : Transforms.itemTransforms);
    }

    public PassthruModelItem(IXUItem item, EnumMap<ItemCameraTransforms.TransformType, Matrix4f> transforms) {
        this(item, () -> new ModelLayer(transforms));
    }

    public PassthruModelItem(IXUItem item, Supplier<ModelLayer> model) {
        this.item = item;
        this.modelFactory = model;
    }

    public static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.item.getBaseTexture();
    }

    public static class ModelLayer
    extends MutableModel {
        static ItemCameraTransforms.TransformType[] types = new ItemCameraTransforms.TransformType[]{ItemCameraTransforms.TransformType.GUI, ItemCameraTransforms.TransformType.NONE};
        public MutableModel lowPolyVersion;

        public ModelLayer(EnumMap<ItemCameraTransforms.TransformType, Matrix4f> itemTransforms) {
            super(itemTransforms);
            this.isGui3D = false;
            this.ambientOcclusion = false;
            this.lowPolyVersion = new MutableModel(itemTransforms);
            for (ItemCameraTransforms.TransformType type : types) {
                this.transformMap.put(type, Pair.of((Object)this.lowPolyVersion, (Object)((Pair)this.transformMap.get(type)).getRight()));
            }
        }

        public void addBoxModel(BoxModel boxModel) {
            for (Box box : boxModel) {
                for (EnumFacing facing : EnumFacing.values()) {
                    List<BakedQuad> quads = box.getQuads(facing);
                    if (quads == null) continue;
                    this.addAllQuads(quads);
                }
                List<BakedQuad> quads = box.getQuads(null);
                if (quads == null) continue;
                this.addAllQuads(quads);
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.lowPolyVersion.clear();
        }

        public void addSprite(TextureAtlasSprite sprite) {
            this.generalQuads.addAll((Collection)quads3dcache.get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addSprite(TextureAtlasSprite sprite, boolean draw3d) {
            if (this.tex == null) {
                this.tex = sprite;
            }
            this.generalQuads.addAll((Collection)(draw3d ? quads3dcache : quads2dcache).get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addTintedSprite(TextureAtlasSprite sprite, boolean draw3d, int tint) {
            if (tint == -1) {
                this.addSprite(sprite, draw3d);
            } else {
                for (BakedQuad bakedQuad : (draw3d ? quads3dcache : quads2dcache).get(sprite)) {
                    this.generalQuads.add(((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
                for (BakedQuad bakedQuad : quads2dcache.get(sprite)) {
                    this.lowPolyVersion.generalQuads.add((BakedQuad)((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
            }
        }

        public void addQuad(BakedQuad quad) {
            this.generalQuads.add(quad);
            this.lowPolyVersion.generalQuads.add(quad);
        }

        public void addAllQuads(Collection<BakedQuad> quads) {
            this.generalQuads.addAll(quads);
            this.lowPolyVersion.generalQuads.addAll(quads);
        }
    }
}

