/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.math.geometry;

import com.austinv11.collectiveframework.utils.math.TwoDimensionalVector;
import com.austinv11.collectiveframework.utils.math.geometry.IncompatibleDimensionsException;

public class Circle {
    private TwoDimensionalVector center;
    private double radius;

    public Circle(TwoDimensionalVector center, double radius) throws IncompatibleDimensionsException {
        if (radius <= 0.0) {
            throw new IncompatibleDimensionsException("The radius must be greater than 0");
        }
        this.center = center;
        this.radius = radius;
    }

    public Circle(double radius) throws IncompatibleDimensionsException {
        this(new TwoDimensionalVector(0.0, 0.0), radius);
    }

    public TwoDimensionalVector getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public Circle setCenter(TwoDimensionalVector newCenter) {
        try {
            return new Circle(newCenter, this.radius);
        }
        catch (IncompatibleDimensionsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Circle setRadius(double newRadius) throws IncompatibleDimensionsException {
        return new Circle(this.center, newRadius);
    }

    public double getDiameter() {
        return 2.0 * this.radius;
    }

    public double getCircumference() {
        return this.getDiameter() * Math.PI;
    }

    public double getArea() {
        return Math.PI * Math.pow(this.radius, 2.0);
    }

    public boolean isPointOnCircumference(TwoDimensionalVector point) {
        return Math.sqrt(Math.pow(point.getX() - this.center.getX(), 2.0) + Math.pow(point.getY() - this.center.getY(), 2.0)) == this.radius;
    }

    public boolean isPointInCircle(TwoDimensionalVector point) {
        return this.isPointOnCircumference(point) || point.distanceTo(this.center) < this.radius;
    }
}

