/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniondc;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector4dc;
import org.joml.Vector4fc;

public class Vector4d
implements Externalizable,
Vector4dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Vector4d() {
        this.w = 1.0;
    }

    public Vector4d(Vector4dc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = v.w();
    }

    public Vector4d(Vector3dc v, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
    }

    public Vector4d(Vector2dc v, double z, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
    }

    public Vector4d(double d) {
        this(d, d, d, d);
    }

    public Vector4d(Vector4fc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = v.w();
    }

    public Vector4d(Vector3fc v, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
    }

    public Vector4d(Vector2fc v, double z, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
    }

    public Vector4d(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4d(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4d(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector4d(DoubleBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4d(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public Vector4d set(Vector4dc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = v.w();
        return this;
    }

    public Vector4d set(Vector4fc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = v.w();
        return this;
    }

    public Vector4d set(Vector3dc v, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
        return this;
    }

    public Vector4d set(Vector3fc v, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
        return this;
    }

    public Vector4d set(Vector2dc v, double z, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4d set(double d) {
        return this.set(d, d, d, d);
    }

    public Vector4d set(Vector2fc v, double z, double w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4d set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4d set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4d set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4d set(DoubleBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4d set(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4d setComponent(int component, double value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public DoubleBuffer get(DoubleBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public DoubleBuffer get(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector4d sub(Vector4dc v) {
        this.x -= v.x();
        this.y -= v.y();
        this.z -= v.z();
        this.w -= v.w();
        return this;
    }

    public Vector4d sub(Vector4fc v) {
        this.x -= (double)v.x();
        this.y -= (double)v.y();
        this.z -= (double)v.z();
        this.w -= (double)v.w();
        return this;
    }

    public Vector4d sub(double x, double y, double z, double w) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        this.w -= w;
        return this;
    }

    public Vector4d sub(double x, double y, double z, double w, Vector4d dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4d add(Vector4dc v) {
        this.x += v.x();
        this.y += v.y();
        this.z += v.z();
        this.w += v.w();
        return this;
    }

    public Vector4d add(double x, double y, double z, double w) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.w += w;
        return this;
    }

    public Vector4d add(double x, double y, double z, double w, Vector4d dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4d add(Vector4fc v) {
        this.x += (double)v.x();
        this.y += (double)v.y();
        this.z += (double)v.z();
        this.w += (double)v.w();
        return this;
    }

    public Vector4d fma(Vector4dc a, Vector4dc b) {
        this.x += a.x() * b.x();
        this.y += a.y() * b.y();
        this.z += a.z() * b.z();
        this.w += a.w() * b.w();
        return this;
    }

    public Vector4d fma(double a, Vector4dc b) {
        this.x += a * b.x();
        this.y += a * b.y();
        this.z += a * b.z();
        this.w += a * b.w();
        return this;
    }

    public Vector4d fma(Vector4dc a, Vector4dc b, Vector4d dest) {
        dest.x = this.x + a.x() * b.x();
        dest.y = this.y + a.y() * b.y();
        dest.z = this.z + a.z() * b.z();
        dest.w = this.w + a.w() * b.w();
        return dest;
    }

    public Vector4d fma(double a, Vector4dc b, Vector4d dest) {
        dest.x = this.x + a * b.x();
        dest.y = this.y + a * b.y();
        dest.z = this.z + a * b.z();
        dest.w = this.w + a * b.w();
        return dest;
    }

    public Vector4d mul(Vector4dc v) {
        this.x *= v.x();
        this.y *= v.y();
        this.z *= v.z();
        this.z *= v.w();
        return this;
    }

    public Vector4d mul(Vector4dc v, Vector4d dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        dest.w = this.w * v.w();
        return dest;
    }

    public Vector4d div(Vector4dc v) {
        this.x /= v.x();
        this.y /= v.y();
        this.z /= v.z();
        this.z /= v.w();
        return this;
    }

    public Vector4d div(Vector4dc v, Vector4d dest) {
        dest.x = this.x / v.x();
        dest.y = this.y / v.y();
        dest.z = this.z / v.z();
        dest.w = this.w / v.w();
        return dest;
    }

    public Vector4d mul(Vector4fc v) {
        this.x *= (double)v.x();
        this.y *= (double)v.y();
        this.z *= (double)v.z();
        this.z *= (double)v.w();
        return this;
    }

    public Vector4d mul(Matrix4dc mat) {
        return this.mul(mat, this);
    }

    public Vector4d mul(Matrix4dc mat, Vector4d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w, mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        return dest;
    }

    public Vector4d mul(Matrix4x3dc mat) {
        return this.mul(mat, this);
    }

    public Vector4d mul(Matrix4x3dc mat, Vector4d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w, this.w);
        return dest;
    }

    public Vector4d mul(Matrix4x3fc mat) {
        return this.mul(mat, this);
    }

    public Vector4d mul(Matrix4x3fc mat, Vector4d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30() * this.w, (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31() * this.w, (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32() * this.w, this.w);
        return dest;
    }

    public Vector4d mul(Matrix4fc mat) {
        return this.mul(mat, this);
    }

    public Vector4d mul(Matrix4fc mat, Vector4d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30() * this.w, (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31() * this.w, (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32() * this.w, (double)mat.m03() * this.x + (double)mat.m13() * this.y + (double)mat.m23() * this.z + (double)mat.m33() * this.w);
        return dest;
    }

    public Vector4d mulProject(Matrix4dc mat, Vector4d dest) {
        double invW = 1.0 / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        dest.set((mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w) * invW, (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w) * invW, (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w) * invW, 1.0);
        return dest;
    }

    public Vector4d mulProject(Matrix4dc mat) {
        return this.mulProject(mat, this);
    }

    public Vector4d mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public Vector4d mul(double scalar, Vector4d dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        dest.w = this.w * scalar;
        return dest;
    }

    public Vector4d div(double scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        this.w /= scalar;
        return this;
    }

    public Vector4d div(double scalar, Vector4d dest) {
        dest.x = this.x / scalar;
        dest.y = this.y / scalar;
        dest.z = this.z / scalar;
        dest.w = this.w / scalar;
        return dest;
    }

    public Vector4d rotate(Quaterniondc quat) {
        return this.rotate(quat, this);
    }

    public Vector4d rotate(Quaterniondc quat, Vector4d dest) {
        quat.transform(this, dest);
        return dest;
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public Vector4d normalize() {
        double invLength = 1.0 / this.length();
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        this.w *= invLength;
        return this;
    }

    public Vector4d normalize(Vector4d dest) {
        double invLength = 1.0 / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public Vector4d normalize3() {
        double invLength = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        this.w *= invLength;
        return this;
    }

    public Vector4d normalize3(Vector4d dest) {
        double invLength = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public double distance(Vector4dc v) {
        double dx = v.x() - this.x;
        double dy = v.y() - this.y;
        double dz = v.z() - this.z;
        double dw = v.w() - this.w;
        return Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public double distance(double x, double y, double z, double w) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        double dw = this.w - w;
        return Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public double dot(Vector4dc v) {
        return this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
    }

    public double dot(double x, double y, double z, double w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public double angleCos(Vector4dc v) {
        double length1Sqared = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        double length2Sqared = v.x() * v.x() + v.y() * v.y() + v.z() * v.z() + v.w() * v.w();
        double dot = this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
        return dot / Math.sqrt(length1Sqared * length2Sqared);
    }

    public double angle(Vector4dc v) {
        double cos = this.angleCos(v);
        cos = cos < 1.0 ? cos : 1.0;
        cos = cos > -1.0 ? cos : -1.0;
        return Math.acos(cos);
    }

    public Vector4d zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
        return this;
    }

    public Vector4d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4d negate(Vector4d dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = -this.w;
        return dest;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        String str = this.toString(formatter);
        StringBuffer res = new StringBuffer();
        int eIndex = Integer.MIN_VALUE;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'E') {
                eIndex = i;
            } else {
                if (c == ' ' && eIndex == i - 1) {
                    res.append('+');
                    continue;
                }
                if (Character.isDigit(c) && eIndex == i - 1) {
                    res.append('+');
                }
            }
            res.append(c);
        }
        return res.toString();
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.w);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector4d other = (Vector4d)obj;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(other.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public Vector4d smoothStep(Vector4dc v, double t, Vector4d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v.x() - v.x()) * t3 + (3.0 * v.x() - 3.0 * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y() - v.y()) * t3 + (3.0 * v.y() - 3.0 * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z() - v.z()) * t3 + (3.0 * v.z() - 3.0 * this.z) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v.w() - v.w()) * t3 + (3.0 * v.w() - 3.0 * this.w) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4d hermite(Vector4dc t0, Vector4dc v1, Vector4dc t1, double t, Vector4d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x() - v1.x() + t1.x() + t0.x()) * t3 + (3.0 * v1.x() - 3.0 * this.x - t0.x() - t0.x() - t1.x()) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y() - v1.y() + t1.y() + t0.y()) * t3 + (3.0 * v1.y() - 3.0 * this.y - t0.y() - t0.y() - t1.y()) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z() - v1.z() + t1.z() + t0.z()) * t3 + (3.0 * v1.z() - 3.0 * this.z - t0.z() - t0.z() - t1.z()) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v1.w() - v1.w() + t1.w() + t0.w()) * t3 + (3.0 * v1.w() - 3.0 * this.w - t0.w() - t0.w() - t1.w()) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4d lerp(Vector4dc other, double t) {
        return this.lerp(other, t, this);
    }

    public Vector4d lerp(Vector4dc other, double t, Vector4d dest) {
        dest.x = this.x + (other.x() - this.x) * t;
        dest.y = this.y + (other.y() - this.y) * t;
        dest.z = this.z + (other.z() - this.z) * t;
        dest.w = this.w + (other.w() - this.w) * t;
        return dest;
    }

    public Vector4dc toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Vector4dc {
        private final Vector4dc delegate;

        Proxy(Vector4dc delegate) {
            this.delegate = delegate;
        }

        public double x() {
            return this.delegate.x();
        }

        public double y() {
            return this.delegate.y();
        }

        public double z() {
            return this.delegate.z();
        }

        public double w() {
            return this.delegate.w();
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public DoubleBuffer get(DoubleBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public DoubleBuffer get(int index, DoubleBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public Vector4d sub(double x, double y, double z, double w, Vector4d dest) {
            return this.delegate.sub(x, y, z, w, dest);
        }

        public Vector4d add(double x, double y, double z, double w, Vector4d dest) {
            return this.delegate.add(x, y, z, w, dest);
        }

        public Vector4d fma(Vector4dc a, Vector4dc b, Vector4d dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector4d fma(double a, Vector4dc b, Vector4d dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector4d mul(Vector4dc v, Vector4d dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector4d div(Vector4dc v, Vector4d dest) {
            return this.delegate.div(v, dest);
        }

        public Vector4d mul(Matrix4dc mat, Vector4d dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector4d mul(Matrix4x3dc mat, Vector4d dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector4d mul(Matrix4x3fc mat, Vector4d dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector4d mul(Matrix4fc mat, Vector4d dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector4d mulProject(Matrix4dc mat, Vector4d dest) {
            return this.delegate.mulProject(mat, dest);
        }

        public Vector4d mul(double scalar, Vector4d dest) {
            return this.delegate.mul(scalar, dest);
        }

        public Vector4d div(double scalar, Vector4d dest) {
            return this.delegate.div(scalar, dest);
        }

        public Vector4d rotate(Quaterniondc quat, Vector4d dest) {
            return this.delegate.rotate(quat, dest);
        }

        public double lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public double length() {
            return this.delegate.length();
        }

        public Vector4d normalize(Vector4d dest) {
            return this.delegate.normalize(dest);
        }

        public Vector4d normalize3(Vector4d dest) {
            return this.delegate.normalize3(dest);
        }

        public double distance(Vector4dc v) {
            return this.delegate.distance(v);
        }

        public double distance(double x, double y, double z, double w) {
            return this.delegate.distance(x, y, z, w);
        }

        public double dot(Vector4dc v) {
            return this.delegate.dot(v);
        }

        public double dot(double x, double y, double z, double w) {
            return this.delegate.dot(x, y, z, w);
        }

        public double angleCos(Vector4dc v) {
            return this.delegate.angleCos(v);
        }

        public double angle(Vector4dc v) {
            return this.delegate.angle(v);
        }

        public Vector4d negate(Vector4d dest) {
            return this.delegate.negate(dest);
        }

        public Vector4d smoothStep(Vector4dc v, double t, Vector4d dest) {
            return this.delegate.smoothStep(v, t, dest);
        }

        public Vector4d hermite(Vector4dc t0, Vector4dc v1, Vector4dc t1, double t, Vector4d dest) {
            return this.delegate.hermite(t0, v1, t1, t, dest);
        }

        public Vector4d lerp(Vector4dc other, double t, Vector4d dest) {
            return this.delegate.lerp(other, t, dest);
        }
    }
}

