/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.mantle;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import slimeknights.mantle.util.RecipeMatch;

public class RecipeMatchIIngredient
extends RecipeMatch {
    private IIngredient ingredient;
    private List<ItemStack> items;

    public RecipeMatchIIngredient(IIngredient ingredient) {
        this(ingredient, 1);
    }

    public RecipeMatchIIngredient(IIngredient ingredient, int amountMatched) {
        super(amountMatched, ingredient.getAmount());
        this.ingredient = ingredient;
    }

    public List<ItemStack> getInputs() {
        if (this.items != null) {
            return this.items;
        }
        this.items = Arrays.stream(this.ingredient.getItemArray()).map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        return this.items;
    }

    public Optional<RecipeMatch.Match> matches(NonNullList<ItemStack> stacks) {
        LinkedList found = Lists.newLinkedList();
        int stillNeeded = this.amountNeeded;
        for (ItemStack stack : stacks) {
            if (!this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)stack))) continue;
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(Math.min(copy.func_190916_E(), stillNeeded));
            found.add(copy);
            if ((stillNeeded -= copy.func_190916_E()) > 0) continue;
            return Optional.of(new RecipeMatch.Match((List)found, this.amountMatched));
        }
        return Optional.empty();
    }
}

