/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.fixer;

import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.internal.ZeroCore;
import java.util.Map;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;

public class TileEntityNameFixer
implements IFixableData {
    private final int _dataVersion;
    private final String _filterPrefix;
    private final Map<String, String> _remappings;

    public TileEntityNameFixer(int dataVersion, @Nonnull String filterPrefix) {
        this._dataVersion = dataVersion;
        this._filterPrefix = filterPrefix;
        this._remappings = Maps.newHashMap();
    }

    public void addReplacement(@Nonnull String oldName, @Nonnull ResourceLocation newId) {
        this._remappings.put(oldName, newId.toString());
    }

    public int func_188216_a() {
        return this._dataVersion;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        String teName = compound.func_74779_i("id");
        if (teName.startsWith(this._filterPrefix)) {
            String newName = this._remappings.get(teName);
            if (!Strings.isNullOrEmpty((String)newName)) {
                compound.func_74778_a("id", newName);
                ZeroCore.getLogger().debug("Remapped old TileEntity ID '{}' with '{}'", (Object)teName, (Object)newName);
            } else {
                ZeroCore.getLogger().debug("No remapping found for TileEntity ID '{}'", (Object)teName);
            }
        }
        return compound;
    }
}

