/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.nbt;

import buildcraft.lib.misc.data.CompactingBitSet;
import buildcraft.lib.nbt.NbtSquishMap;
import buildcraft.lib.nbt.NbtSquisher;
import buildcraft.lib.nbt.WrittenType;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.list.array.TShortArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.init.Bootstrap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.profiler.Profiler;

class NbtSquishMapWriter {
    static boolean debug;
    static final boolean sort = true;
    static final Boolean packList;
    static final Profiler profiler;
    private final NbtSquishMap map;

    private static void log(String string) {
        if (!debug) {
            throw new IllegalArgumentException("Don't allocate a string if we aren't debugging!");
        }
        Bootstrap.field_179872_a.print(string + "\n");
    }

    public NbtSquishMapWriter(NbtSquishMap map) {
        this.map = map;
    }

    public static void write(NbtSquishMap map, DataOutput to) throws IOException {
        new NbtSquishMapWriter(map).write(to);
    }

    private void write(DataOutput to) throws IOException {
        profiler.func_76320_a("write");
        profiler.func_76320_a("flags");
        WrittenType type = this.map.getWrittenType();
        type.writeType(to);
        TByteArrayList bytes = this.map.bytes;
        TShortArrayList shorts = this.map.shorts;
        TIntArrayList ints = this.map.ints;
        TLongArrayList longs = this.map.longs;
        TFloatArrayList floats = this.map.floats;
        TDoubleArrayList doubles = this.map.doubles;
        List<TByteArrayList> byteArrays = this.map.byteArrays;
        List<TIntArrayList> intArrays = this.map.intArrays;
        List<String> strings = this.map.strings;
        List<NBTBase> complex = this.map.complex;
        int flags = 0;
        if (!bytes.isEmpty()) {
            flags |= 1;
        }
        if (!shorts.isEmpty()) {
            flags |= 2;
        }
        if (!ints.isEmpty()) {
            flags |= 4;
        }
        if (!longs.isEmpty()) {
            flags |= 8;
        }
        if (!floats.isEmpty()) {
            flags |= 0x10;
        }
        if (!doubles.isEmpty()) {
            flags |= 0x20;
        }
        if (!byteArrays.isEmpty()) {
            flags |= 0x40;
        }
        if (!intArrays.isEmpty()) {
            flags |= 0x80;
        }
        if (!strings.isEmpty()) {
            flags |= 0x100;
        }
        if (!complex.isEmpty()) {
            flags |= 0x200;
        }
        if (debug) {
            NbtSquishMapWriter.log("\nUsed flags = " + Integer.toBinaryString(flags));
        }
        to.writeInt(flags);
        profiler.func_76318_c("bytes");
        if (!bytes.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nByte dictionary size = " + bytes.size());
            }
            bytes.sort();
            NbtSquishMapWriter.writeVarInt(to, bytes.size());
            for (byte b : bytes.toArray()) {
                to.writeByte(b);
            }
        }
        profiler.func_76318_c("shorts");
        if (!shorts.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nShort dictionary size = " + shorts.size());
            }
            shorts.sort();
            NbtSquishMapWriter.writeVarInt(to, shorts.size());
            for (byte s : (Object)shorts.toArray()) {
                to.writeShort(s);
            }
        }
        profiler.func_76318_c("integers");
        if (!ints.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nInt dictionary size = " + ints.size());
            }
            ints.sort();
            NbtSquishMapWriter.writeVarInt(to, ints.size());
            for (byte i : (Object)ints.toArray()) {
                to.writeInt(i);
            }
        }
        profiler.func_76318_c("longs");
        if (!longs.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nLong dictionary size = " + longs.size());
            }
            longs.sort();
            NbtSquishMapWriter.writeVarInt(to, longs.size());
            for (byte l : (Object)longs.toArray()) {
                to.writeLong(l);
            }
        }
        profiler.func_76318_c("floats");
        if (!floats.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nFloat dictionary size = " + floats.size());
            }
            floats.sort();
            NbtSquishMapWriter.writeVarInt(to, floats.size());
            for (byte f : (Object)floats.toArray()) {
                to.writeFloat(f);
            }
        }
        profiler.func_76318_c("doubles");
        if (!doubles.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nDouble dictionary size = " + doubles.size());
            }
            doubles.sort();
            NbtSquishMapWriter.writeVarInt(to, doubles.size());
            for (Object d : (Object)doubles.toArray()) {
                to.writeDouble((double)d);
            }
        }
        profiler.func_76318_c("byte_arrays");
        if (!byteArrays.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nByte Array dictionary size = " + byteArrays.size());
            }
            NbtSquishMapWriter.writeVarInt(to, byteArrays.size());
            Object object = byteArrays.iterator();
            while (object.hasNext()) {
                TByteArrayList ba = (TByteArrayList)object.next();
                to.writeShort(ba.size());
                byte[] byArray = ba.toArray();
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    byte b = byArray[i];
                    to.writeByte(b);
                }
            }
        }
        profiler.func_76318_c("int_arrays");
        if (!intArrays.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nInt Array dictionary size = " + intArrays.size());
            }
            NbtSquishMapWriter.writeVarInt(to, intArrays.size());
            for (TIntArrayList ia : intArrays) {
                to.writeShort(ia.size());
                for (int i : ia.toArray()) {
                    to.writeInt(i);
                }
            }
        }
        profiler.func_76318_c("strings");
        if (!strings.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nString dictionary size = " + strings.size());
            }
            Collections.sort(strings);
            NbtSquishMapWriter.writeVarInt(to, strings.size());
            for (int i = 0; i < strings.size(); ++i) {
                String s = strings.get(i);
                if (debug) {
                    NbtSquishMapWriter.log("\n   String " + i + " = " + s);
                }
                byte[] stringBytes = s.getBytes(StandardCharsets.UTF_8);
                to.writeShort(stringBytes.length);
                to.write(stringBytes);
            }
        }
        profiler.func_76318_c("complex");
        if (!complex.isEmpty()) {
            if (debug) {
                NbtSquishMapWriter.log("\nComplex dictionary size = " + complex.size());
            }
            NbtSquishMapWriter.writeVarInt(to, complex.size());
            for (NBTBase nbt : complex) {
                if (nbt instanceof NBTTagList) {
                    NBTTagList list = (NBTTagList)nbt;
                    this.writeList(type, list, to);
                    continue;
                }
                NBTTagCompound compound = (NBTTagCompound)nbt;
                this.writeCompound(type, compound, to);
            }
        }
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    private static void writeVarInt(DataOutput to, int input) throws IOException {
        while ((input & 0xFFFFFF80) != 0) {
            to.writeByte(input & 0x7F | 0x80);
            input >>>= 7;
        }
        to.writeByte(input);
    }

    private void writeList(WrittenType type, NBTTagList list, DataOutput to) throws IOException {
        boolean pack = this.shouldPackList(list);
        if (debug) {
            NbtSquishMapWriter.log("\n  List tag count = " + list.func_74745_c() + ", writing it " + (pack ? "PACKED" : "NORMAL"));
        }
        if (pack) {
            this.writeListPacked(type, to, list);
        } else {
            this.writeListNormal(type, to, list);
        }
    }

    private boolean shouldPackList(NBTTagList list) {
        if (packList != null) {
            return packList;
        }
        profiler.func_76320_a("should_pack");
        TIntHashSet indexes = new TIntHashSet();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            indexes.add(this.map.indexOfTag(list.func_179238_g(i)));
        }
        profiler.func_76319_b();
        return indexes.size() * 2 < list.func_74745_c();
    }

    private void writeCompound(WrittenType type, NBTTagCompound compound, DataOutput to) throws IOException {
        profiler.func_76320_a("compound");
        WrittenType stringType = WrittenType.getForSize(this.map.strings.size());
        if (debug) {
            NbtSquishMapWriter.log("\n  Compound tag count = " + compound.func_186856_d());
        }
        to.writeByte(0);
        NbtSquishMapWriter.writeVarInt(to, compound.func_186856_d());
        for (String key : compound.func_150296_c()) {
            profiler.func_76320_a("entry");
            NBTBase nbt = compound.func_74781_a(key);
            profiler.func_76320_a("index_value");
            int index = this.map.indexOfTag(nbt);
            profiler.func_76319_b();
            if (debug) {
                NbtSquishMapWriter.log("\n             \"" + key + "\" -> " + index + " (" + NbtSquishMapWriter.safeToString(nbt) + ")");
            }
            profiler.func_76320_a("index_key");
            stringType.writeIndex(to, this.map.strings.indexOf(key));
            profiler.func_76319_b();
            type.writeIndex(to, index);
            profiler.func_76319_b();
        }
        profiler.func_76319_b();
    }

    private void writeListNormal(WrittenType type, DataOutput to, NBTTagList list) throws IOException {
        profiler.func_76320_a("list_normal");
        to.writeByte(1);
        NbtSquishMapWriter.writeVarInt(to, list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            profiler.func_76320_a("entry");
            if (i % 100 == 0 && debug) {
                NbtSquishMapWriter.log("\n   List items " + i + " to " + Math.min(i + 99, list.func_74745_c()));
            }
            profiler.func_76320_a("index");
            int index = this.map.indexOfTag(list.func_179238_g(i));
            profiler.func_76319_b();
            type.writeIndex(to, index);
            profiler.func_76319_b();
        }
        profiler.func_76319_b();
    }

    private void writeListPacked(WrittenType type, DataOutput to, NBTTagList list) throws IOException {
        profiler.func_76320_a("list_packed");
        to.writeByte(2);
        profiler.func_76320_a("header");
        profiler.func_76320_a("init");
        int[] data = new int[list.func_74745_c()];
        TIntIntHashMap indexes = new TIntIntHashMap();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            profiler.func_76320_a("entry");
            profiler.func_76320_a("index");
            int index = this.map.indexOfTag(list.func_179238_g(i));
            profiler.func_76319_b();
            data[i] = index;
            if (!indexes.increment(index)) {
                indexes.put(index, 1);
            }
            profiler.func_76319_b();
        }
        profiler.func_76318_c("sort");
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        for (int index : indexes.keys()) {
            int count = indexes.get(index);
            IndexEntry entry = new IndexEntry(index, count);
            entries.add(entry);
        }
        entries.sort(Comparator.reverseOrder());
        if (debug) {
            NbtSquishMapWriter.log("\n " + entries.size() + " List entries");
        }
        NbtSquishMapWriter.writeVarInt(to, entries.size());
        profiler.func_76318_c("write");
        TIntArrayList sortedIndexes = new TIntArrayList();
        int i = 0;
        for (IndexEntry entry : entries) {
            int j = i;
            NBTBase base = this.map.getTagForWriting(entry.index);
            String n = NbtSquishMapWriter.safeToString(base);
            if (debug) {
                NbtSquishMapWriter.log("\n List entry #" + j + " = " + entry.count + "x" + entry.index + " (" + n + ")");
            }
            sortedIndexes.add(entry.index);
            type.writeIndex(to, entry.index);
            ++i;
        }
        TIntArrayList nextData = new TIntArrayList();
        nextData.add(data);
        NbtSquishMapWriter.writeVarInt(to, data.length);
        profiler.func_76319_b();
        profiler.func_76318_c("contents");
        int b = 1;
        while (!nextData.isEmpty()) {
            profiler.func_76320_a("entry");
            CompactingBitSet bitset = new CompactingBitSet(b);
            bitset.ensureCapacityValues(nextData.size());
            TIntArrayList nextNextData = new TIntArrayList();
            int maxVal = (1 << b) - 1;
            profiler.func_76320_a("iter");
            for (int d : nextData.toArray()) {
                int index = sortedIndexes.indexOf(d);
                if (index < maxVal) {
                    bitset.append(index);
                    continue;
                }
                bitset.append(maxVal);
                nextNextData.add(d);
            }
            profiler.func_76319_b();
            sortedIndexes.remove(0, Math.min(sortedIndexes.size(), maxVal));
            byte[] bitsetBytes = bitset.getBytes();
            if (debug) {
                NbtSquishMapWriter.log("\n List bitset #" + (bitset.bits - 1));
            }
            NbtSquishMapWriter.writeVarInt(to, bitsetBytes.length);
            to.write(bitsetBytes);
            nextData = nextNextData;
            profiler.func_76319_b();
            ++b;
        }
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    public static String safeToString(NBTBase base) {
        String n = base.toString();
        if (n.length() > 100) {
            n = "[LARGE  " + n.substring(0, 100) + " ]";
        }
        return n;
    }

    static {
        packList = null;
        profiler = NbtSquisher.profiler;
    }

    private static class IndexEntry
    implements Comparable<IndexEntry> {
        public final int index;
        public final int count;

        public IndexEntry(int index, int count) {
            this.index = index;
            this.count = count;
        }

        @Override
        public int compareTo(IndexEntry o) {
            return Integer.compare(this.count, o.count);
        }

        public String toString() {
            return this.index + " x " + this.count;
        }
    }
}

