/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import java.util.Objects;

public class NodeFuncDoubleToDouble
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncDoubleToDouble function;
    private final StringFunctionBi stringFunction;

    public NodeFuncDoubleToDouble(String name, IFuncDoubleToDouble function) {
        this(function, (String a) -> "[ double -> double ] " + name + "(" + a + ")");
    }

    public NodeFuncDoubleToDouble(IFuncDoubleToDouble function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public NodeFuncDoubleToDouble setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble a = stack.popDouble();
        return this.create(a);
    }

    public FuncDoubleToDouble create(IExpressionNode.INodeDouble argA) {
        return new FuncDoubleToDouble(argA);
    }

    @FunctionalInterface
    public static interface IFuncDoubleToDouble {
        public double apply(double var1);
    }

    public class FuncDoubleToDouble
    implements IExpressionNode.INodeDouble,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeDouble argA;

        public FuncDoubleToDouble(IExpressionNode.INodeDouble argA) {
            this.argA = argA;
        }

        @Override
        public double evaluate() {
            return NodeFuncDoubleToDouble.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncDoubleToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncDoubleToDouble((IExpressionNode.INodeDouble)a), a -> new FuncDoubleToDouble((IExpressionNode.INodeDouble)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncDoubleToDouble((IExpressionNode.INodeDouble)a), a -> NodeConstantDouble.of(NodeFuncDoubleToDouble.this.function.apply(a.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncDoubleToDouble.this.canInline) {
                if (NodeFuncDoubleToDouble.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncDoubleToDouble.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn((IExpressionNode)this.argA);
        }

        public String toString() {
            return NodeFuncDoubleToDouble.this.stringFunction.apply(this.argA.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncDoubleToDouble.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncDoubleToDouble other = (FuncDoubleToDouble)obj;
            return Objects.equals(this.argA, other.argA);
        }
    }
}

