/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.reload;

import buildcraft.lib.client.reload.SourceType;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;

public class ReloadSource {
    public final ResourceLocation location;
    public final SourceType type;
    private final int hash;

    public ReloadSource(ResourceLocation location, SourceType type) {
        this.location = location;
        this.type = type;
        this.hash = Objects.hash(new Object[]{location, type});
    }

    public ReloadSource(String loc, SourceType type) {
        this(new ResourceLocation(loc), type);
    }

    public ReloadSource(String domain, String path, SourceType type) {
        this(new ResourceLocation(domain, path), type);
    }

    public String toString() {
        return (Object)((Object)this.type) + " [ " + this.location + " ]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReloadSource other = (ReloadSource)obj;
        return this.type == other.type && this.location.equals((Object)other.location);
    }

    public int hashCode() {
        return this.hash;
    }
}

