/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget;

import extracells.gui.IToolTipProvider;
import extracells.gui.widget.WidgetManager;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractWidget
implements IToolTipProvider {
    protected final WidgetManager manager;
    protected final int xPos;
    protected final int yPos;
    protected int width = 16;
    protected int height = 16;

    public AbstractWidget(WidgetManager manager, int xPos, int yPos) {
        this.manager = manager;
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract void draw(int var1, int var2);

    public void drawOverlay(int mouseX, int mouseY) {
    }

    @Override
    public List<String> getToolTip(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.xPos && mouseX < this.xPos + this.width && mouseY >= this.yPos && mouseY < this.yPos + this.height;
    }

    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
    }
}

