/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.client.render;

import buildcraft.api.core.render.ISprite;
import buildcraft.factory.client.render.RenderTube;
import buildcraft.factory.tile.TilePump;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.tile.RenderPartCube;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.client.model.animation.FastTESR;

public class RenderPump
extends FastTESR<TilePump> {
    private static final int[] COLOUR_POWER;
    private static final int COLOUR_STATUS_ON = -8921737;
    private static final int COLOUR_STATUS_OFF = -14741477;
    private static final int BLOCK_LIGHT_STATUS_ON = 15;
    private static final int BLOCK_LIGHT_STATUS_OFF = 0;
    private static final double POWER = 0.09375;
    private static final double STATUS = 0.21875;
    private static final double Y = 0.84375;
    private static final RenderPartCube[] LED_POWER;
    private static final RenderPartCube[] LED_STATUS;
    private static final LaserData_BC8.LaserType TUBE_LASER;
    private final RenderTube tubeRenderer = new RenderTube(TUBE_LASER);

    public static void textureStitchPost() {
        for (int i = 0; i < 4; ++i) {
            LED_POWER[i].setWhiteTex();
            LED_STATUS[i].setWhiteTex();
        }
    }

    public void renderTileEntityFast(@Nonnull TilePump tile, double x, double y, double z, float partialTicks, int destroyStage, float partial, @Nonnull BufferBuilder buffer) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("pump");
        buffer.func_178969_c(x, y, z);
        float percentFilled = tile.getPercentFilledForRender();
        int powerColour = COLOUR_POWER[(int)(percentFilled * (float)(COLOUR_POWER.length - 1))];
        boolean complete = tile.isComplete();
        int statusColour = complete ? -14741477 : -8921737;
        int statusLight = complete ? 0 : 15;
        for (int i = 0; i < 4; ++i) {
            EnumFacing dir = EnumFacing.func_176731_b((int)i);
            BlockPos pos = tile.func_174877_v().func_177972_a(dir);
            int block = tile.func_145831_w().func_175642_b(EnumSkyBlock.BLOCK, pos);
            int sky = tile.func_145831_w().func_175642_b(EnumSkyBlock.SKY, pos);
            RenderPump.LED_POWER[i].center.colouri(powerColour);
            RenderPump.LED_STATUS[i].center.colouri(statusColour);
            RenderPump.LED_POWER[i].center.lighti(block, sky);
            RenderPump.LED_STATUS[i].center.lighti(Math.max(statusLight, block), sky);
            LED_POWER[i].render(buffer);
            LED_STATUS[i].render(buffer);
        }
        this.tubeRenderer.renderTileEntityFast(tile, x, y, z, partialTicks, destroyStage, partial, buffer);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public boolean isGlobalRenderer(TilePump tile) {
        return true;
    }

    public static void init() {
    }

    static {
        int i;
        COLOUR_POWER = new int[16];
        for (i = 0; i < COLOUR_POWER.length; ++i) {
            int colour;
            int c = i * 64 / COLOUR_POWER.length;
            int r = i * 224 / COLOUR_POWER.length + 31;
            RenderPump.COLOUR_POWER[i] = colour = -16777216 + (c << 16) + (c << 8) + r;
        }
        LED_POWER = new RenderPartCube[4];
        LED_STATUS = new RenderPartCube[4];
        for (i = 0; i < 4; ++i) {
            double ledX;
            double ledZ;
            int dZ;
            int dX;
            EnumFacing facing = EnumFacing.func_176731_b((int)i);
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                dX = 0;
                dZ = facing.func_176743_c().func_179524_a();
                ledZ = 0.5;
                ledX = facing == EnumFacing.EAST ? 0.975 : 0.025;
            } else {
                dX = -facing.func_176743_c().func_179524_a();
                dZ = 0;
                ledX = 0.5;
                ledZ = facing == EnumFacing.SOUTH ? 0.975 : 0.025;
            }
            RenderPump.LED_POWER[i] = new RenderPartCube();
            RenderPump.LED_POWER[i].center.positiond(ledX + (double)dX * 0.09375, 0.84375, ledZ + (double)dZ * 0.09375);
            RenderPump.LED_STATUS[i] = new RenderPartCube();
            RenderPump.LED_STATUS[i].center.positiond(ledX + (double)dX * 0.21875, 0.84375, ledZ + (double)dZ * 0.21875);
        }
        SpriteHolderRegistry.SpriteHolder spriteTubeMiddle = SpriteHolderRegistry.getHolder((String)"buildcraftfactory:blocks/pump/tube");
        LaserData_BC8.LaserRow cap = new LaserData_BC8.LaserRow((ISprite)spriteTubeMiddle, 0, 8, 8, 16, new LaserData_BC8.LaserSide[0]);
        LaserData_BC8.LaserRow middle = new LaserData_BC8.LaserRow((ISprite)spriteTubeMiddle, 0, 0, 16, 8, new LaserData_BC8.LaserSide[0]);
        LaserData_BC8.LaserRow[] middles = new LaserData_BC8.LaserRow[]{middle};
        TUBE_LASER = new LaserData_BC8.LaserType(cap, middle, middles, null, cap);
    }
}

