/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters;

import com.tmtravlr.soundfilters.SoundFiltersMod;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import paulscode.sound.Source;

public class SoundTickHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    private static int profileTickCountdown = 13;
    private static float prevDecayFactor = 0.0f;
    private static float prevRoomFactor = 0.0f;
    private static float prevSkyFactor = 0.0f;
    public static float targetLowPassGain = 1.0f;
    public static float targetLowPassGainHF = 1.0f;
    public static float baseLowPassGain = 1.0f;
    public static float baseLowPassGainHF = 1.0f;
    public static boolean waterSound = false;
    public static boolean lavaSound = false;
    public static Comparator<ComparablePosition> CPcomparator = new Comparator<ComparablePosition>(){

        @Override
        public int compare(ComparablePosition first, ComparablePosition second) {
            return first.compareTo(second);
        }
    };
    public static ConcurrentSkipListMap<ComparablePosition, DoubleWithTimeout> sourceOcclusionMap = new ConcurrentSkipListMap(CPcomparator);

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.mc != null && this.mc.field_71441_e != null && this.mc.field_71439_g != null && !this.mc.func_147113_T()) {
                if (this.mc.field_71439_g.func_70055_a(Material.field_151586_h)) {
                    if (!waterSound) {
                        if (SoundFiltersMod.DEBUG) {
                            SoundFiltersMod.logger.debug("[SoundFilters] Applying water sound low pass.");
                        }
                        targetLowPassGain = SoundFiltersMod.waterVolume;
                        targetLowPassGainHF = SoundFiltersMod.waterLowPassAmount;
                        lavaSound = false;
                        waterSound = true;
                    }
                } else if (waterSound) {
                    if (SoundFiltersMod.DEBUG) {
                        SoundFiltersMod.logger.debug("[SoundFilters] Stopping water sound low pass.");
                    }
                    targetLowPassGain = 1.0f;
                    targetLowPassGainHF = 1.0f;
                    waterSound = false;
                }
                if (this.mc.field_71439_g.func_70055_a(Material.field_151587_i)) {
                    if (!lavaSound) {
                        if (SoundFiltersMod.DEBUG) {
                            SoundFiltersMod.logger.debug("[SoundFilters] Applying lava sound low pass.");
                        }
                        targetLowPassGain = SoundFiltersMod.lavaVolume;
                        targetLowPassGainHF = SoundFiltersMod.lavaLowPassAmount;
                        lavaSound = true;
                        waterSound = false;
                    }
                } else if (lavaSound) {
                    if (SoundFiltersMod.DEBUG) {
                        SoundFiltersMod.logger.debug("[SoundFilters] Stopping lava sound low pass.");
                    }
                    targetLowPassGain = 1.0f;
                    targetLowPassGainHF = 1.0f;
                    lavaSound = false;
                }
                if (Math.abs(targetLowPassGain - baseLowPassGain) > 0.001f) {
                    baseLowPassGain = (targetLowPassGain + baseLowPassGain) / 2.0f;
                }
                if (Math.abs(targetLowPassGainHF - baseLowPassGainHF) > 0.001f) {
                    baseLowPassGainHF = (targetLowPassGainHF + baseLowPassGainHF) / 2.0f;
                }
            } else {
                baseLowPassGain = 1.0f;
                baseLowPassGainHF = 1.0f;
                SoundFiltersMod.reverbFilter.decayTime = 0.1f;
                SoundFiltersMod.reverbFilter.reflectionsDelay = 0.0f;
                SoundFiltersMod.reverbFilter.lateReverbDelay = 0.0f;
                lavaSound = false;
                waterSound = false;
            }
        } else {
            ArrayList<ComparablePosition> toRemove = new ArrayList<ComparablePosition>();
            if (SoundFiltersMod.doOcclusion) {
                for (ComparablePosition sourcePosition : sourceOcclusionMap.keySet()) {
                    DoubleWithTimeout sourceAndAmount = sourceOcclusionMap.get(sourcePosition);
                    if (sourceAndAmount == null) continue;
                    if (sourceAndAmount.source != null && sourceAndAmount.source.position != null && sourceAndAmount.source.active()) {
                        try {
                            if (this.mc != null && this.mc.field_71441_e != null && this.mc.field_71439_g != null) {
                                Vec3d roomSize = new Vec3d(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u + (double)this.mc.field_71439_g.func_70047_e(), this.mc.field_71439_g.field_70161_v);
                                sourceAndAmount.amount = (sourceAndAmount.amount * 3.0 + (double)SoundFiltersMod.occlusionPercent * SoundTickHandler.getSoundOcclusion((World)this.mc.field_71441_e, new Vec3d((double)sourceAndAmount.source.position.x, (double)sourceAndAmount.source.position.y, (double)sourceAndAmount.source.position.z), roomSize)) / 4.0;
                                continue;
                            }
                            sourceAndAmount.amount = 0.0;
                        }
                        catch (NullPointerException e) {
                            if (!SoundFiltersMod.DEBUG) continue;
                            SoundFiltersMod.logger.warn("Caught null pointer exception while updating sound occlusion. This happens sometimes because a sound is modified at the same time in another thread.");
                        }
                        continue;
                    }
                    toRemove.add(sourcePosition);
                }
                for (ComparablePosition positionToRemove : toRemove) {
                    if (SoundFiltersMod.SUPER_DUPER_DEBUG) {
                        SoundFiltersMod.logger.debug("[Sound Filters] Removing " + positionToRemove + ", " + positionToRemove.hashCode() + ", " + profileTickCountdown);
                    }
                    sourceOcclusionMap.remove(positionToRemove);
                }
            }
            if (this.mc != null && this.mc.field_71441_e != null && this.mc.field_71439_g != null && SoundFiltersMod.doReverb && --profileTickCountdown <= 0) {
                int i;
                profileTickCountdown = 13;
                Random rand = new Random();
                TreeSet<ComparablePosition> visited = new TreeSet<ComparablePosition>(CPcomparator);
                ArrayList<IBlockState> blocksFound = new ArrayList<IBlockState>();
                LinkedList<ComparablePosition> toVisit = new LinkedList<ComparablePosition>();
                toVisit.add(new ComparablePosition(MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v)));
                for (i = 0; i < SoundFiltersMod.profileSize && !toVisit.isEmpty(); ++i) {
                    ComparablePosition current = (ComparablePosition)toVisit.remove(rand.nextInt(toVisit.size()));
                    visited.add(current);
                    ComparablePosition pos = new ComparablePosition(current.x, current.y, current.z + 1.0f);
                    IBlockState state = this.mc.field_71441_e.func_180495_p(new BlockPos(pos.x(), pos.y(), pos.z()));
                    Block block = state.func_177230_c();
                    Material material = state.func_185904_a();
                    if (!material.func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(state);
                        }
                    } else {
                        blocksFound.add(state);
                    }
                    pos = new ComparablePosition(current.x, current.y, current.z - 1.0f);
                    state = this.mc.field_71441_e.func_180495_p(new BlockPos(pos.x(), pos.y(), pos.z()));
                    block = state.func_177230_c();
                    material = state.func_185904_a();
                    if (!material.func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(state);
                        }
                    } else {
                        blocksFound.add(state);
                    }
                    pos = new ComparablePosition(current.x, current.y + 1.0f, current.z);
                    state = this.mc.field_71441_e.func_180495_p(new BlockPos(pos.x(), pos.y(), pos.z()));
                    block = state.func_177230_c();
                    material = state.func_185904_a();
                    if (!material.func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(state);
                        }
                    } else {
                        blocksFound.add(state);
                    }
                    pos = new ComparablePosition(current.x, current.y - 1.0f, current.z);
                    state = this.mc.field_71441_e.func_180495_p(new BlockPos(pos.x(), pos.y(), pos.z()));
                    block = state.func_177230_c();
                    material = state.func_185904_a();
                    if (!material.func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(state);
                        }
                    } else {
                        blocksFound.add(state);
                    }
                    pos = new ComparablePosition(current.x + 1.0f, current.y, current.z);
                    state = this.mc.field_71441_e.func_180495_p(new BlockPos(pos.x(), pos.y(), pos.z()));
                    block = state.func_177230_c();
                    material = state.func_185904_a();
                    if (!material.func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(state);
                        }
                    } else {
                        blocksFound.add(state);
                    }
                    pos = new ComparablePosition(current.x - 1.0f, current.y, current.z);
                    state = this.mc.field_71441_e.func_180495_p(new BlockPos(pos.x(), pos.y(), pos.z()));
                    block = state.func_177230_c();
                    material = state.func_185904_a();
                    if (!material.func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material == Material.field_151579_a) continue;
                        blocksFound.add(state);
                        continue;
                    }
                    blocksFound.add(state);
                }
                int roomSize = visited.size();
                double highReverb = 0.0;
                double midReverb = 0.0;
                double lowReverb = 0.0;
                for (IBlockState s : blocksFound) {
                    Block b = s.func_177230_c();
                    SoundFiltersMod.BlockMeta blockInfo = new SoundFiltersMod.BlockMeta(b, 16);
                    if (!SoundFiltersMod.customReverb.containsKey(blockInfo)) {
                        blockInfo = new SoundFiltersMod.BlockMeta(b, b.func_176201_c(s));
                    }
                    if (SoundFiltersMod.customReverb.containsKey(blockInfo)) {
                        double factor = SoundFiltersMod.customReverb.get(blockInfo);
                        lowReverb += factor >= 1.0 || factor < 0.0 ? 0.0 : 1.0 - factor;
                        midReverb += factor >= 2.0 || factor <= 0.0 ? 0.0 : 1.0 - Math.abs(factor - 1.0);
                        highReverb += factor <= 1.0 ? 0.0 : (factor > 2.0 ? 1.0 : factor - 1.0);
                        continue;
                    }
                    if (s.func_185904_a() != Material.field_151576_e && s.func_185904_a() != Material.field_151592_s && s.func_185904_a() != Material.field_151588_w && s.func_185904_a() != Material.field_151573_f) {
                        if (s.func_185904_a() != Material.field_151570_A && s.func_185904_a() != Material.field_151568_F && s.func_185904_a() != Material.field_151580_n && s.func_185904_a() != Material.field_151589_v && s.func_185904_a() != Material.field_151577_b && s.func_185904_a() != Material.field_151584_j && s.func_185904_a() != Material.field_151593_r && s.func_185904_a() != Material.field_151585_k && s.func_185904_a() != Material.field_151572_C && s.func_185904_a() != Material.field_151597_y && s.func_185904_a() != Material.field_151583_m && s.func_185904_a() != Material.field_151582_l && s.func_185904_a() != Material.field_151569_G) {
                            midReverb += 1.0;
                            continue;
                        }
                        lowReverb += 1.0;
                        continue;
                    }
                    highReverb += 1.0;
                }
                float skyFactor = 0.0f;
                if (SoundFiltersMod.doSkyChecks && roomSize == SoundFiltersMod.profileSize) {
                    int z;
                    int y;
                    int x = MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t);
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y = MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70163_u), z = MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v))) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y + 5, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y + 5, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y + 5, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y + 5, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y + 5, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                }
                skyFactor = 1.0f - skyFactor / 17.0f;
                float decayFactor = 0.0f;
                float roomFactor = (float)roomSize / (float)SoundFiltersMod.profileSize;
                if (highReverb + midReverb + lowReverb > 0.0) {
                    decayFactor += (float)(highReverb - lowReverb) / (float)(highReverb + midReverb + lowReverb);
                }
                if (decayFactor < 0.0f) {
                    decayFactor = 0.0f;
                }
                if (decayFactor > 1.0f) {
                    decayFactor = 1.0f;
                }
                if (SoundFiltersMod.SUPER_DUPER_DEBUG) {
                    SoundFiltersMod.logger.debug("[Sound Filters] Reverb Profile - Room Size: " + roomSize + ", Looked at: " + i + ", Sky Factor: " + skyFactor + ", High, Mid, and Low Reverb: (" + highReverb + ", " + midReverb + ", " + lowReverb + ")");
                }
                decayFactor = (decayFactor + prevDecayFactor) / 2.0f;
                roomFactor = (roomFactor + prevRoomFactor) / 2.0f;
                skyFactor = (skyFactor + prevSkyFactor) / 2.0f;
                prevDecayFactor = decayFactor;
                prevRoomFactor = roomFactor;
                prevSkyFactor = skyFactor;
                SoundFiltersMod.reverbFilter.decayTime = SoundFiltersMod.reverbPercent * 8.0f * decayFactor * roomFactor * skyFactor;
                if (SoundFiltersMod.reverbFilter.decayTime < 0.1f) {
                    SoundFiltersMod.reverbFilter.decayTime = 0.1f;
                }
                SoundFiltersMod.reverbFilter.reflectionsGain = SoundFiltersMod.reverbPercent * (0.05f + 0.05f * roomFactor);
                SoundFiltersMod.reverbFilter.reflectionsDelay = 0.025f * roomFactor;
                SoundFiltersMod.reverbFilter.lateReverbGain = SoundFiltersMod.reverbPercent * (1.26f + 0.1f * roomFactor);
                SoundFiltersMod.reverbFilter.lateReverbDelay = 0.01f * roomFactor;
            }
        }
    }

    private static boolean onlySkyAboveBlock(World world, int x, int y, int z) {
        for (int i = y; i < 256; ++i) {
            IBlockState state = world.func_180495_p(new BlockPos(x, i, z));
            Block block = state.func_177230_c();
            if (!state.func_185904_a().func_76230_c()) continue;
            return false;
        }
        return true;
    }

    public static double getSoundOcclusion(World world, Vec3d sound, Vec3d listener) {
        double occludedPercent = 0.0;
        sound = sound.func_72441_c(0.1, 0.1, 0.1);
        if (!(Double.isNaN(sound.field_72450_a) || Double.isNaN(sound.field_72448_b) || Double.isNaN(sound.field_72449_c))) {
            if (!(Double.isNaN(listener.field_72450_a) || Double.isNaN(listener.field_72448_b) || Double.isNaN(listener.field_72449_c))) {
                int listenerX = MathHelper.func_76128_c((double)listener.field_72450_a);
                int listenerY = MathHelper.func_76128_c((double)listener.field_72448_b);
                int listenerZ = MathHelper.func_76128_c((double)listener.field_72449_c);
                int soundX = MathHelper.func_76128_c((double)sound.field_72450_a);
                int soundY = MathHelper.func_76128_c((double)sound.field_72448_b);
                int soundZ = MathHelper.func_76128_c((double)sound.field_72449_c);
                int countDown = 200;
                while (countDown-- >= 0) {
                    RayTraceResult rayTrace;
                    int whichToChange;
                    if (Double.isNaN(sound.field_72450_a) || Double.isNaN(sound.field_72448_b) || Double.isNaN(sound.field_72449_c)) {
                        return occludedPercent;
                    }
                    if (soundX == listenerX && soundY == listenerY && soundZ == listenerZ) {
                        return occludedPercent;
                    }
                    boolean shouldChangeX = true;
                    boolean shouldChangeY = true;
                    boolean shouldChangeZ = true;
                    double newX = 999.0;
                    double newY = 999.0;
                    double newZ = 999.0;
                    if (listenerX == soundX) {
                        shouldChangeX = false;
                    }
                    if (shouldChangeX) {
                        newX = (double)soundX + (listenerX > soundX ? 1.0 : 0.0);
                    }
                    if (listenerY == soundY) {
                        shouldChangeY = false;
                    }
                    if (shouldChangeY) {
                        newY = (double)soundY + (listenerY > soundY ? 1.0 : 0.0);
                    }
                    if (listenerZ == soundZ) {
                        shouldChangeZ = false;
                    }
                    if (shouldChangeZ) {
                        newZ = (double)soundZ + (listenerZ > soundZ ? 1.0 : 0.0);
                    }
                    double xPercentChange = 999.0;
                    double yPercentChange = 999.0;
                    double zPercentChange = 999.0;
                    double xDifference = listener.field_72450_a - sound.field_72450_a;
                    double yDifference = listener.field_72448_b - sound.field_72448_b;
                    double zDifference = listener.field_72449_c - sound.field_72449_c;
                    if (shouldChangeX) {
                        xPercentChange = (newX - sound.field_72450_a) / xDifference;
                    }
                    if (shouldChangeY) {
                        yPercentChange = (newY - sound.field_72448_b) / yDifference;
                    }
                    if (shouldChangeZ) {
                        zPercentChange = (newZ - sound.field_72449_c) / zDifference;
                    }
                    if (xPercentChange < yPercentChange && xPercentChange < zPercentChange) {
                        whichToChange = listenerX > soundX ? 4 : 5;
                        sound = new Vec3d(newX, sound.field_72448_b + yDifference * xPercentChange, sound.field_72449_c + zDifference * xPercentChange);
                    } else if (yPercentChange < zPercentChange) {
                        whichToChange = listenerY > soundY ? 0 : 1;
                        sound = new Vec3d(sound.field_72450_a + xDifference * yPercentChange, newY, sound.field_72449_c + zDifference * yPercentChange);
                    } else {
                        whichToChange = listenerZ > soundZ ? 2 : 3;
                        sound = new Vec3d(sound.field_72450_a + xDifference * zPercentChange, sound.field_72448_b + yDifference * zPercentChange, newZ);
                    }
                    Vec3d vec32 = new Vec3d((double)MathHelper.func_76128_c((double)sound.field_72450_a), (double)MathHelper.func_76128_c((double)sound.field_72448_b), (double)MathHelper.func_76128_c((double)sound.field_72449_c));
                    soundX = (int)vec32.field_72450_a;
                    if (whichToChange == 5) {
                        --soundX;
                        vec32 = vec32.func_72441_c(1.0, 0.0, 0.0);
                    }
                    soundY = (int)vec32.field_72448_b;
                    if (whichToChange == 1) {
                        --soundY;
                        vec32 = vec32.func_72441_c(0.0, 1.0, 0.0);
                    }
                    soundZ = (int)vec32.field_72449_c;
                    if (whichToChange == 3) {
                        --soundZ;
                        vec32 = vec32.func_72441_c(0.0, 0.0, 1.0);
                    }
                    BlockPos pos = new BlockPos(soundX, soundY, soundZ);
                    IBlockState state = world.func_180495_p(pos);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    int meta = block.func_176201_c(state);
                    Material material = state.func_185904_a();
                    if (block == null || block == Blocks.field_150350_a || state.func_185900_c((IBlockAccess)world, new BlockPos(soundX, soundY, soundZ)) == Block.field_185506_k || !block.func_176209_a(state, false) || (rayTrace = state.func_185910_a(world, pos, sound, listener)) == null) continue;
                    SoundFiltersMod.BlockMeta blockInfo = new SoundFiltersMod.BlockMeta(block, 16);
                    if (!SoundFiltersMod.customOcclusion.containsKey(blockInfo)) {
                        blockInfo = new SoundFiltersMod.BlockMeta(block, meta);
                    }
                    if (SoundFiltersMod.customOcclusion.containsKey(blockInfo)) {
                        occludedPercent += SoundFiltersMod.customOcclusion.get(blockInfo) * 0.1;
                    } else if (occludedPercent < 0.7) {
                        occludedPercent += material.func_76218_k() ? 0.1 : 0.05;
                    }
                    if (!(occludedPercent > 0.98)) continue;
                    return 0.98;
                }
                return occludedPercent;
            }
            return occludedPercent;
        }
        return occludedPercent;
    }

    public static class DoubleWithTimeout {
        public Source source;
        public double amount;
        public int timeout;

        DoubleWithTimeout() {
            this(null, 0.0, 10);
        }

        DoubleWithTimeout(Source sToSet, double dToSet, int iToSet) {
            this.source = sToSet;
            this.amount = dToSet;
            this.timeout = iToSet;
        }
    }

    public static class ComparablePosition
    implements Comparable {
        float x;
        float y;
        float z;

        ComparablePosition(float xToSet, float yToSet, float zToSet) {
            this.x = xToSet;
            this.y = yToSet;
            this.z = zToSet;
        }

        public int x() {
            return MathHelper.func_76141_d((float)this.x);
        }

        public int y() {
            return MathHelper.func_76141_d((float)this.y);
        }

        public int z() {
            return MathHelper.func_76141_d((float)this.z);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComparablePosition)) {
                return false;
            }
            ComparablePosition toCompare = (ComparablePosition)object;
            return toCompare.compareTo(this) == 0;
        }

        public int compareTo(Object object) {
            if (!(object instanceof ComparablePosition)) {
                return 0;
            }
            ComparablePosition toCompare = (ComparablePosition)object;
            if ((double)(toCompare.x - this.x) > 0.1) {
                return 1;
            }
            if ((double)(toCompare.x - this.x) < -0.1) {
                return -1;
            }
            if ((double)(toCompare.y - this.y) > 0.1) {
                return 1;
            }
            if ((double)(toCompare.y - this.y) < -0.1) {
                return -1;
            }
            if ((double)(toCompare.z - this.z) > 0.1) {
                return 1;
            }
            if ((double)(toCompare.z - this.z) < -0.1) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "[" + this.x + ", " + this.y + ", " + this.z + "]";
        }
    }
}

