/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.base.render.util.HalfBakedQuad;
import crazypants.enderio.powertools.machine.capbank.BlockCapBank;
import crazypants.enderio.powertools.machine.capbank.CapBankType;
import crazypants.enderio.powertools.machine.capbank.InfoDisplayType;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class FillGaugeBakery {
    private static final double px = 0.0625;
    @Nonnull
    private static final Vector3d CENTER = new Vector3d(0.5, 0.5, 0.5);
    private CapBankType bankType;
    private int height;
    private int myOffset;
    private double localFillLevel;
    private boolean connectUp;
    private boolean connectDown;
    private final IBlockAccess world;
    private final BlockPos pos;
    @Nonnull
    private final EnumFacing face;
    @Nonnull
    private final TextureAtlasSprite tex;
    private HalfBakedQuad.HalfBakedList buffer;
    private HalfBakedQuad.HalfBakedList litBuffer;

    public FillGaugeBakery(@Nonnull TextureAtlasSprite tex, double fillLevel) {
        this(null, null, EnumFacing.NORTH, tex, fillLevel);
    }

    public FillGaugeBakery(IBlockAccess world, BlockPos pos, @Nonnull EnumFacing face, @Nonnull TextureAtlasSprite tex, double fillLevel) {
        this.world = world;
        this.pos = pos;
        this.face = face;
        this.tex = tex;
        this.localFillLevel = fillLevel * 10.0 + 3.0;
        this.connectDown = false;
        this.connectUp = false;
        this.mkQuads();
    }

    public FillGaugeBakery(IBlockAccess world, BlockPos pos, @Nonnull EnumFacing face, @Nonnull TextureAtlasSprite tex) {
        this.world = world;
        this.pos = pos;
        this.face = face;
        this.tex = tex;
        IBlockState bs = world.func_180495_p(pos.func_177972_a(face));
        if (bs.func_177230_c().isSideSolid(bs, world, pos.func_177972_a(face), face.func_176734_d())) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockCapBank)) {
            return;
        }
        this.bankType = (CapBankType)((Object)state.func_177229_b(CapBankType.KIND));
        if (!this.bankType.isMultiblock()) {
            this.height = 1;
            this.myOffset = 0;
            this.connectDown = false;
            this.connectUp = false;
        } else {
            this.countNeighbors();
        }
        if (this.bankType.isCreative()) {
            this.localFillLevel = 8.0;
        } else {
            this.calculateFillLevel();
        }
        this.mkQuads();
    }

    private void mkQuads() {
        VertexRotationFacing rot = new VertexRotationFacing(this.face);
        rot.setCenter(CENTER);
        rot.setRotation(EnumFacing.NORTH);
        this.buffer = new HalfBakedQuad.HalfBakedList();
        double upperBound = (double)(this.connectUp ? 16 : 13) * 0.0625;
        double lowerBound = (double)(this.connectDown ? 0 : 3) * 0.0625;
        double full_out = -0.03125;
        double half_out = -0.015625;
        double quarter_out = -0.0078125;
        double bit_in = 6.25E-4;
        BoundingBox border1 = new BoundingBox(0.375, lowerBound, -0.03125, 0.4375, upperBound, 6.25E-4);
        this.buffer.add(border1, EnumFacing.NORTH, 0.938125, 0.999375, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border1, EnumFacing.EAST, 0.938125, 0.968125, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border1, EnumFacing.WEST, 0.999375, 0.969375, lowerBound, upperBound, this.tex, null);
        BoundingBox border2 = new BoundingBox(0.5625, lowerBound, -0.03125, 0.625, upperBound, 6.25E-4);
        this.buffer.add(border2, EnumFacing.NORTH, 0.750625, 0.811875, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border2, EnumFacing.EAST, 0.750625, 0.780625, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border2, EnumFacing.WEST, 0.811875, 0.781875, lowerBound, upperBound, this.tex, null);
        BoundingBox back = new BoundingBox(0.375, (double)(this.connectDown ? 0 : 2) * 0.0625, -0.03125, 0.625, (double)(this.connectUp ? 16 : 14) * 0.0625, 6.25E-4);
        this.buffer.add(back, EnumFacing.SOUTH, 0.250625, 0.499375, (double)(this.connectDown ? 0 : 2) * 0.0625, (double)(this.connectUp ? 16 : 14) * 0.0625, this.tex, null);
        if (!this.connectDown) {
            BoundingBox border3 = new BoundingBox(0.375, lowerBound - 0.0625, -0.03125, 0.625, 0.1875, 6.25E-4);
            this.buffer.add(border3, EnumFacing.NORTH, 3.125E-4, 0.2496875, 0.813125, 0.874375, this.tex, null);
            this.buffer.add(border3, EnumFacing.UP, 3.125E-4, 0.2496875, 0.84375, 0.874375, this.tex, null);
            this.buffer.add(border3, EnumFacing.DOWN, 3.125E-4, 0.2496875, 0.84375, 0.874375, this.tex, null);
            this.buffer.add(border3, EnumFacing.WEST, 0.188125, 0.218125, 0.813125, 0.874375, this.tex, null);
            this.buffer.add(border3, EnumFacing.EAST, 0.061875, 0.031875, 0.813125, 0.874375, this.tex, null);
        }
        if (!this.connectUp) {
            BoundingBox border4 = new BoundingBox(0.375, 0.8125, -0.03125, 0.625, upperBound + 0.0625, 6.25E-4);
            this.buffer.add(border4, EnumFacing.NORTH, 3.125E-4, 0.2496875, 0.125625, 0.186875, this.tex, null);
            this.buffer.add(border4, EnumFacing.UP, 3.125E-4, 0.2496875, 0.125625, 0.15625, this.tex, null);
            this.buffer.add(border4, EnumFacing.DOWN, 3.125E-4, 0.2496875, 0.125625, 0.15625, this.tex, null);
            this.buffer.add(border4, EnumFacing.WEST, 0.188125, 0.218125, 0.125625, 0.186875, this.tex, null);
            this.buffer.add(border4, EnumFacing.EAST, 0.061875, 0.031875, 0.125625, 0.186875, this.tex, null);
        }
        BoundingBox bg = new BoundingBox(0.40625, (this.connectDown ? 0.0 : 2.5) * 0.0625, -0.0078125, 0.59375, (this.connectUp ? 16.0 : 13.5) * 0.0625, 6.25E-4);
        this.buffer.add(bg, EnumFacing.NORTH, 0.78125, 0.96875, (this.connectDown ? 0.0 : 2.5) * 0.0625, (this.connectUp ? 16.0 : 13.5) * 0.0625, this.tex, null);
        this.buffer.transform(new VertexTransform[]{rot});
        if (this.localFillLevel > 0.001) {
            BoundingBox fg = new BoundingBox(0.40625, (this.connectDown ? 0.0 : 2.99) * 0.0625, -0.015625, 0.59375, this.localFillLevel * 0.0625, 6.25E-4);
            this.litBuffer = new HalfBakedQuad.HalfBakedList();
            this.litBuffer.add(fg, EnumFacing.NORTH, 0.534375, 0.715625, (this.connectDown ? 0.0 : 2.99) * 0.0625, this.localFillLevel * 0.0625, this.tex, null);
            this.litBuffer.transform(new VertexTransform[]{rot});
        }
    }

    private void calculateFillLevel() {
        if (this.world != null && this.pos != null) {
            TileEntity tileEntity = BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.world, (BlockPos)this.pos);
            if (!(tileEntity instanceof TileCapBank)) {
                this.localFillLevel = 0.0;
                return;
            }
            ICapBankNetwork network = ((TileCapBank)tileEntity).getNetwork();
            if (!(network instanceof CapBankClientNetwork)) {
                this.localFillLevel = 0.0;
                return;
            }
            ((CapBankClientNetwork)network).requestPowerUpdate((TileCapBank)tileEntity, 20);
            double ratio = Math.min(((CapBankClientNetwork)network).getEnergyStoredRatio(), 1.0);
            this.localFillLevel = Math.max(0.0, Math.min(ratio * (double)(this.height * 16 - 6) - (double)(this.myOffset * 16), 13.0) + 3.0);
        }
    }

    private void countNeighbors() {
        if (this.world != null && this.pos != null) {
            TileEntity tileEntity;
            IBlockState infrontOfOther;
            boolean isCovered;
            IBlockState state;
            this.height = 1;
            this.myOffset = 0;
            BlockPos other = this.pos;
            while ((state = this.world.func_180495_p(other = other.func_177984_a())).func_177230_c() instanceof BlockCapBank && state.func_177229_b(CapBankType.KIND) == this.bankType && !(isCovered = (infrontOfOther = this.world.func_180495_p(other.func_177972_a(this.face))).isSideSolid(this.world, other.func_177972_a(this.face), this.face.func_176734_d())) && (tileEntity = BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.world, (BlockPos)other)) instanceof TileCapBank && ((TileCapBank)tileEntity).getDisplayType(this.face) == InfoDisplayType.LEVEL_BAR) {
                ++this.height;
                this.connectUp = true;
            }
            other = this.pos;
            while ((state = this.world.func_180495_p(other = other.func_177977_b())).func_177230_c() instanceof BlockCapBank && state.func_177229_b(CapBankType.KIND) == this.bankType && !(isCovered = (infrontOfOther = this.world.func_180495_p(other.func_177972_a(this.face))).isSideSolid(this.world, other.func_177972_a(this.face), this.face.func_176734_d())) && (tileEntity = BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.world, (BlockPos)other)) instanceof TileCapBank && ((TileCapBank)tileEntity).getDisplayType(this.face) == InfoDisplayType.LEVEL_BAR) {
                ++this.height;
                ++this.myOffset;
                this.connectDown = true;
            }
        }
    }

    public void render() {
        if (this.canRender()) {
            int i = this.world.func_175626_b(this.pos.func_177972_a(this.face), 0);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
            tes.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            this.buffer.render(tes);
            if (this.litBuffer != null) {
                this.litBuffer.render(tes);
            }
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public boolean canRender() {
        return this.buffer != null;
    }

    public void bake(@Nonnull List<BakedQuad> quads) {
        this.buffer.bake(quads);
        if (this.litBuffer != null) {
            this.litBuffer.bake(quads);
        }
    }
}

