/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.transceiver;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ChannelType;
import crazypants.enderio.machines.config.config.TranceiverConfig;
import crazypants.enderio.machines.machine.transceiver.TileTransceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public enum TransceiverRegistry {
    INSTANCE;

    @Nonnull
    private final NNList<TileTransceiver> transceivers = new NNList();
    @Nonnull
    private final Map<Channel, RoundRobinIterator<TileTransceiver>> iterators = new HashMap<Channel, RoundRobinIterator<TileTransceiver>>();

    public void register(@Nonnull TileTransceiver transceiver) {
        this.transceivers.add((Object)transceiver);
    }

    public void dergister(@Nonnull TileTransceiver transceiver) {
        this.transceivers.remove((Object)transceiver);
    }

    @Nonnull
    public RoundRobinIterator<TileTransceiver> getIterator(@Nonnull Channel channel) {
        RoundRobinIterator res = this.iterators.get(channel);
        if (res == null) {
            res = new RoundRobinIterator(this.transceivers);
            this.iterators.put(channel, (RoundRobinIterator<TileTransceiver>)res);
        }
        return res;
    }

    public void sendPower(@Nonnull TileTransceiver sender, int canSend, @Nonnull Channel channel) {
        RoundRobinIterator<TileTransceiver> iter = this.getIterator(channel);
        for (TileTransceiver trans : iter) {
            double invLoss;
            int canSendWithLoss;
            int recieved;
            if (trans == sender || !trans.getRecieveChannels(ChannelType.POWER).contains(channel) || (recieved = trans.receiveEnergy(null, canSendWithLoss = (int)Math.round((double)canSend * (invLoss = 1.0 - (Double)TranceiverConfig.energyLoss.get())), false)) <= 0) continue;
            int recievedPlusLoss = (int)Math.round((double)recieved / invLoss);
            sender.usePower(recievedPlusLoss);
        }
    }

    @Nonnull
    public IFluidTankProperties[] getTankInfoForChannels(@Nullable TileTransceiver tileTransceiver, @Nonnull Set<Channel> channelsIn) {
        ArrayList<IFluidTankProperties> infos = new ArrayList<IFluidTankProperties>();
        for (TileTransceiver tran : this.transceivers) {
            if (tran == tileTransceiver) continue;
            tran.getRecieveTankInfo(infos, channelsIn);
        }
        return infos.toArray(new IFluidTankProperties[infos.size()]);
    }

    public boolean canFill(@Nullable TileTransceiver tileTransceiver, @Nonnull Set<Channel> set, @Nonnull Fluid fluid) {
        for (TileTransceiver tran : this.transceivers) {
            if (tran == tileTransceiver || !tran.canReceive(set, fluid)) continue;
            return true;
        }
        return false;
    }

    public int fill(TileTransceiver from, @Nonnull Set<Channel> list, FluidStack resource, boolean doFill) {
        if (resource == null || !from.hasPower()) {
            return 0;
        }
        for (Channel channel : list) {
            if (channel == null) continue;
            RoundRobinIterator<TileTransceiver> iter = this.getIterator(channel);
            for (TileTransceiver trans : iter) {
                int val;
                if (trans == from || (val = trans.recieveFluid(list, resource, doFill)) <= 0) continue;
                if (doFill && (Integer)TranceiverConfig.bucketEnergyCost.get() > 0) {
                    int powerUsed = (int)Math.max(1.0, (double)((Integer)TranceiverConfig.bucketEnergyCost.get() * val) / 1000.0);
                    from.usePower(powerUsed);
                }
                return val;
            }
        }
        return 0;
    }

    public void sendItem(@Nonnull TileTransceiver from, @Nonnull Set<Channel> channelsIn, int slot, @Nonnull ItemStack contents) {
        if (!from.hasPower()) {
            return;
        }
        for (Channel channel : channelsIn) {
            if (channel == null) continue;
            RoundRobinIterator<TileTransceiver> iter = this.getIterator(channel);
            for (TileTransceiver trans : iter) {
                if (trans == from || !trans.getRecieveChannels(ChannelType.ITEM).contains(channel) || !trans.getRedstoneChecksPassed() || !(contents = this.sendItem(from, slot, contents, trans)).func_190926_b()) continue;
                return;
            }
        }
    }

    @Nonnull
    private ItemStack sendItem(@Nonnull TileTransceiver from, int slot, @Nonnull ItemStack contents, @Nonnull TileTransceiver to) {
        int numCanMerge;
        ItemStack existing;
        int i;
        SlotDefinition sd = to.getSlotDefinition();
        boolean sendComplete = false;
        for (i = sd.minOutputSlot; i <= sd.maxOutputSlot && !sendComplete; ++i) {
            ItemStack remaining;
            existing = to.getStackInSlot(i);
            if (!ItemUtil.areStacksEqual((ItemStack)existing, (ItemStack)contents)) continue;
            sendComplete = true;
            if (existing.func_190916_E() >= to.getInventoryStackLimit()) continue;
            numCanMerge = existing.func_77976_d() - existing.func_190916_E();
            if ((numCanMerge = Math.min(numCanMerge, contents.func_190916_E())) >= contents.func_190916_E()) {
                remaining = ItemStack.field_190927_a;
            } else {
                remaining = contents.func_77946_l();
                remaining.func_190918_g(numCanMerge);
            }
            ItemStack destStack = existing.func_77946_l();
            destStack.func_190917_f(numCanMerge);
            to.setInventorySlotContents(i, destStack);
            from.setInventorySlotContents(slot, remaining);
            if (remaining.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            contents = remaining.func_77946_l();
        }
        if (!sendComplete) {
            for (i = sd.minOutputSlot; i <= sd.maxOutputSlot; ++i) {
                existing = to.getStackInSlot(i);
                if (!existing.func_190926_b() || (numCanMerge = Math.min(contents.func_190916_E(), to.getInventoryStackLimit())) <= 0) continue;
                ItemStack destStack = contents.func_77946_l();
                destStack.func_190920_e(numCanMerge);
                to.setInventorySlotContents(i, destStack);
                ItemStack remaining = contents.func_77946_l();
                remaining.func_190918_g(numCanMerge);
                if (remaining.func_190916_E() == 0) {
                    remaining = ItemStack.field_190927_a;
                }
                from.setInventorySlotContents(slot, remaining);
                return ItemStack.field_190927_a;
            }
        }
        return contents;
    }
}

