/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.refinedstorage.conduit;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.Action;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.item.FunctionUpgrade;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.base.filter.gui.DamageMode;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ItemFilter;
import crazypants.enderio.conduit.refinedstorage.RSHelper;
import crazypants.enderio.conduit.refinedstorage.conduit.IRefinedStorageConduit;
import crazypants.enderio.conduit.refinedstorage.init.ConduitRefinedStorageObject;
import crazypants.enderio.util.FuncUtil;
import crazypants.enderio.util.MathUtil;
import crazypants.enderio.util.Prep;
import crazypants.enderio.util.SidedInt;
import crazypants.enderio.util.SidedNNObject;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ConduitRefinedStorageNode
implements INetworkNode,
INetworkNodeVisitor {
    @Nonnull
    public static final String ID = "rs_conduit";
    @Nullable
    protected INetwork rsNetwork;
    @Nonnull
    protected final World world;
    @Nonnull
    protected final BlockPos pos;
    @Nonnull
    protected final IRefinedStorageConduit con;
    private int tickCount = 0;
    @Nonnull
    private final Queue<EnumFacing> dirsToCheck;
    @Nonnull
    private final SidedInt currentImportSlot = new SidedInt();
    private int importFilterSlot;
    @Nonnull
    private final SidedInt exportFilterSlot = new SidedInt();
    @Nonnull
    private final SidedNNObject<UUID> craftingTask = new SidedNNObject<UUID>(UUID.randomUUID());

    public ConduitRefinedStorageNode(@Nonnull IRefinedStorageConduit con) {
        this.con = con;
        this.world = con.getBundle().getBundleworld();
        this.pos = con.getBundle().getLocation();
        this.dirsToCheck = new LinkedList<EnumFacing>();
        for (EnumFacing dir : EnumFacing.values()) {
            this.dirsToCheck.offer(dir);
        }
    }

    public int getEnergyUsage() {
        return 0;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack(ConduitRefinedStorageObject.item_refined_storage_conduit.getItemNN(), 1);
    }

    public void onConnected(INetwork network) {
        this.rsNetwork = network;
    }

    public void onDisconnected(INetwork network) {
        this.rsNetwork = null;
    }

    public boolean canUpdate() {
        return this.con.hasExternalConnections();
    }

    @Nullable
    public INetwork getNetwork() {
        return this.rsNetwork;
    }

    public void update() {
        if (this.canUpdate()) {
            ++this.tickCount;
            if (this.rsNetwork != null && this.tickCount > 4) {
                this.tickCount = 0;
                for (int i = 0; i < this.dirsToCheck.size(); ++i) {
                    EnumFacing dir = this.dirsToCheck.poll();
                    this.dirsToCheck.offer(dir);
                    if (dir == null || this.con.containsExternalConnection(dir) && this.updateDir(dir)) break;
                }
            }
        }
    }

    private boolean updateDir(@Nonnull EnumFacing dir) {
        TileEntity te = this.world.func_175625_s(this.pos.func_177972_a(dir));
        boolean done = false;
        if (te != null && !(te instanceof IStorageProvider)) {
            done = this.updateDirItems(dir, te);
            done = done || this.updateDirFluids(dir, te);
        }
        return done;
    }

    private boolean updateDirFluids(@Nonnull EnumFacing dir, @Nonnull TileEntity te) {
        IFluidHandler handler;
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()) && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) != null) {
            IFilter inFilt;
            IFilter outFilt = this.con.getOutputFilter(dir);
            if (outFilt instanceof IFluidFilter) {
                IFluidFilter exportFilter = (IFluidFilter)outFilt;
                FluidStack stack = null;
                if (!exportFilter.isEmpty()) {
                    do {
                        if ((stack = exportFilter.getFluidStackAt(this.exportFilterSlot.get(dir) >= exportFilter.getSlotCount() ? this.exportFilterSlot.set(dir, 0) : this.exportFilterSlot.get(dir))) != null) continue;
                        this.exportFilterSlot.set(dir, this.exportFilterSlot.get(dir) + 1);
                    } while (stack == null);
                }
                ItemStack upgrade = this.con.getUpgradeStack(dir.ordinal());
                FunctionUpgrade up = null;
                if (!upgrade.func_190926_b()) {
                    up = ((ItemFunctionUpgrade)upgrade.func_77973_b()).getFunctionUpgrade();
                }
                if (stack != null) {
                    int toExtract = 1000;
                    int compare = 1;
                    FluidStack stackInStorage = (FluidStack)this.rsNetwork.getFluidStorageCache().getList().get((Object)stack, compare);
                    if (stackInStorage != null) {
                        int filled;
                        FluidStack took = this.rsNetwork.extractFluid(stack, toExtract = Math.min(toExtract, stackInStorage.amount), compare, Action.SIMULATE);
                        if (took != null && (filled = handler.fill(took, false)) > 0) {
                            took = this.rsNetwork.extractFluid(stack, filled, compare, Action.PERFORM);
                            handler.fill(took, true);
                            this.exportFilterSlot.set(dir, this.exportFilterSlot.get(dir) + 1);
                            return true;
                        }
                    } else if (up != null && this.isCraftingUpgrade(up)) {
                        this.rsNetwork.getCraftingManager().request(stack, toExtract);
                    }
                }
            }
            if ((inFilt = this.con.getInputFilter(dir)) instanceof IFluidFilter) {
                IFluidFilter importFilter = (IFluidFilter)inFilt;
                boolean all = importFilter.isEmpty();
                FluidStack toDrain = handler.drain(1000, false);
                FluidStack stack = null;
                if (!all) {
                    do {
                        if ((stack = importFilter.getFluidStackAt(this.importFilterSlot >= importFilter.getSlotCount() ? (this.importFilterSlot = 0) : this.importFilterSlot)) != null) continue;
                        ++this.importFilterSlot;
                    } while (stack == null);
                }
                if ((all || stack != null && toDrain != null && stack.isFluidEqual(toDrain)) && toDrain != null) {
                    FluidStack remainder = this.rsNetwork.insertFluidTracked(toDrain, toDrain.amount);
                    if (remainder != null) {
                        toDrain.amount -= remainder.amount;
                    }
                    handler.drain(toDrain, true);
                    ++this.importFilterSlot;
                    return true;
                }
            }
        }
        return false;
    }

    private int getInsertLimit(@Nonnull IItemFilter filter, @Nonnull IItemHandler inventory, @Nonnull ItemStack item, int limit) {
        if (filter.isLimited()) {
            int count = filter.getMaxCountThatPassesFilter(inventory, item);
            if (count <= 0) {
                return 0;
            }
            int maxInsert = ItemTools.getInsertLimit(inventory, item, count);
            if (maxInsert <= 0) {
                return 0;
            }
            if (maxInsert < item.func_190916_E()) {
                return Math.min(limit, maxInsert);
            }
        } else if (!filter.doesItemPassFilter(inventory, item)) {
            return 0;
        }
        return Math.min(limit, item.func_190916_E());
    }

    private int getExtractLimit(@Nonnull IItemFilter filter, @Nonnull IItemHandler inventory, @Nonnull ItemStack existing, int limit) {
        if (filter.isLimited()) {
            int count = filter.getMaxCountThatPassesFilter(inventory, existing);
            if (count <= 0) {
                return 0;
            }
            if (count < Integer.MAX_VALUE) {
                return Math.max(0, Math.min(limit, existing.func_190916_E() - count));
            }
        } else if (!filter.doesItemPassFilter(inventory, existing)) {
            return 0;
        }
        return Math.min(limit, existing.func_190916_E());
    }

    private boolean updateDirItems(@Nonnull EnumFacing dir, @Nonnull TileEntity te) {
        INetwork network = this.rsNetwork;
        IItemHandler handler = ItemTools.getExternalInventory(te, dir.func_176734_d());
        if (network != null && handler != null && handler.getSlots() > 0) {
            IFilter inFilt;
            int insertable;
            IItemFilter exportFilter;
            IFilter outFilt = this.con.getOutputFilter(dir);
            if (outFilt instanceof IItemFilter && !(exportFilter = (IItemFilter)outFilt).isEmpty()) {
                ItemStack prototype = exportFilter.getInventorySlotContents(this.exportFilterSlot.set(dir, MathUtil.cycle(this.exportFilterSlot.get(dir), 0, exportFilter.getSlotCount() - 1)));
                int compare = 1;
                if (exportFilter instanceof ItemFilter) {
                    boolean matchMeta = ((ItemFilter)exportFilter).isMatchMeta() && ((ItemFilter)exportFilter).getDamageMode() == DamageMode.DISABLED;
                    boolean matchNBT = ((ItemFilter)exportFilter).isMatchNBT();
                    compare = (matchMeta ? 1 : 0) | (matchNBT ? 2 : 0);
                }
                if (!prototype.func_190926_b()) {
                    ItemStack remains;
                    ItemStack upgrade = this.con.getUpgradeStack(dir.ordinal());
                    int itemsPerTick = FunctionUpgrade.getMaximumExtracted(upgrade);
                    ItemStack available = network.extractItem(prototype, Math.min(prototype.func_77976_d(), itemsPerTick), compare, Action.SIMULATE);
                    if (available == null || Prep.isInvalid(available)) {
                        if (this.isCraftingUpgrade(ItemFunctionUpgrade.getFunctionUpgrade(upgrade)) && (insertable = (available = ItemHandlerHelper.copyStackWithSize((ItemStack)prototype, (int)this.getInsertLimit(exportFilter, handler, prototype, Integer.MAX_VALUE))).func_190916_E() - ItemTools.insertItemStacked(handler, available, true).func_190916_E()) > 0 && network.getCraftingManager().getTask(this.craftingTask.get(dir)) == null) {
                            this.craftingTask.set(dir, FuncUtil.runIf(network.getCraftingManager().request(prototype, insertable), ICraftingTask::getId));
                        }
                    } else if (Prep.isValid(available = ItemHandlerHelper.copyStackWithSize((ItemStack)available, (int)this.getInsertLimit(exportFilter, handler, available, itemsPerTick))) && (remains = ItemTools.insertItemStacked(handler, available, true)).func_190916_E() < available.func_190916_E() && (available = network.extractItem(prototype, available.func_190916_E() - remains.func_190916_E(), compare, Action.PERFORM)) != null && Prep.isValid(available) && Prep.isValid(remains = ItemTools.insertItemStacked(handler, available, false)) && (remains = network.insertItemTracked(remains, remains.func_190916_E())) != null && Prep.isValid(remains)) {
                        ItemUtil.spawnItemInWorldWithRandomMotion((World)this.getWorld(), (ItemStack)remains, (BlockPos)this.getPos());
                    }
                }
            }
            if ((inFilt = this.con.getInputFilter(dir)) instanceof IItemFilter) {
                ItemStack extractable;
                int maxCountThatPassesFilter;
                IItemFilter importFilter = (IItemFilter)inFilt;
                this.currentImportSlot.set(dir, MathUtil.cycle(this.currentImportSlot.get(dir), 0, handler.getSlots() - 1));
                ItemStack existing = handler.getStackInSlot(this.currentImportSlot.get(dir));
                if (Prep.isValid(existing) && (maxCountThatPassesFilter = this.getExtractLimit(importFilter, handler, existing, FunctionUpgrade.getMaximumExtracted(this.con.getUpgradeStack(dir.ordinal())))) > 0 && Prep.isValid(extractable = handler.extractItem(this.currentImportSlot.get(dir), maxCountThatPassesFilter, true))) {
                    ItemStack remains = network.insertItem(extractable, maxCountThatPassesFilter, Action.SIMULATE);
                    insertable = maxCountThatPassesFilter - (remains == null ? 0 : remains.func_190916_E());
                    if (insertable > 0 && (remains = network.insertItemTracked(extractable = handler.extractItem(this.currentImportSlot.get(dir), insertable, false), extractable.func_190916_E())) != null && Prep.isValid(remains)) {
                        ItemUtil.spawnItemInWorldWithRandomMotion((World)this.getWorld(), (ItemStack)remains, (BlockPos)this.getPos());
                    }
                }
            }
        }
        return false;
    }

    private boolean isCraftingUpgrade(@Nullable FunctionUpgrade functionUpgrade) {
        return functionUpgrade == FunctionUpgrade.RS_CRAFTING_UPGRADE || functionUpgrade == FunctionUpgrade.RS_CRAFTING_SPEED_UPGRADE || functionUpgrade == FunctionUpgrade.RS_CRAFTING_SPEED_DOWNGRADE;
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        return tag;
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nonnull
    public World getWorld() {
        return this.world;
    }

    public void markDirty() {
        if (!this.world.field_72995_K) {
            RSHelper.API.getNetworkNodeManager(this.world).markForSaving();
        }
    }

    public String getId() {
        return ID;
    }

    public boolean equals(Object right) {
        return RSHelper.API.isNetworkNodeEqual((INetworkNode)this, right);
    }

    public int hashCode() {
        return RSHelper.API.getNetworkNodeHashCode((INetworkNode)this);
    }

    public boolean canConduct(@Nonnull EnumFacing direction) {
        return this.con.containsConduitConnection(direction) || this.con.getConnectionMode(direction) != ConnectionMode.DISABLED;
    }

    public void visit(INetworkNodeVisitor.Operator operator) {
        NNList.FACING.apply(facing -> {
            if (this.canConduct((EnumFacing)facing)) {
                operator.apply(this.world, this.pos.func_177972_a(facing), facing.func_176734_d());
            }
        });
    }

    public void onConduitConnectionChange() {
        if (this.rsNetwork != null) {
            this.rsNetwork.getNodeGraph().rebuild();
        }
    }
}

