/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel.gui;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.handler.KeyTracker;
import crazypants.enderio.base.handler.darksteel.gui.AnvilSubGui;
import crazypants.enderio.base.handler.darksteel.gui.DSUContainer;
import crazypants.enderio.base.handler.darksteel.gui.DSURemoteExec;
import crazypants.enderio.base.handler.darksteel.gui.ISlotSelector;
import crazypants.enderio.base.handler.darksteel.gui.UpgradeCap;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import crazypants.enderio.util.AtlasWidgetIcon;
import crazypants.enderio.util.EnumReader;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DSUGui
extends GuiContainerBaseEIO<DSUContainer>
implements DSURemoteExec.GUI {
    private static final NNList<String> TEXTURES = new NNList((Object[])new String[]{"enderio:items/paint_overlay", "minecraft:items/empty_armor_slot_shield"});
    private final int initialTab;
    private final AnvilSubGui anvil;
    private boolean hasSetTab = false;

    public DSUGui(DSUContainer par1Container, int initialTab) {
        super(par1Container, (Container)par1Container, "dsu");
        this.initialTab = initialTab;
        this.anvil = new AnvilSubGui(par1Container, this);
        this.field_147000_g = 206;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.anvil.initGui();
        ((DSUContainer)this.getOwner()).createGhostSlots((List<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
    }

    @Override
    protected boolean doSwitchTab(int tab) {
        ISlotSelector oldTab = ((DSUContainer)this.getOwner()).activeTab;
        this.setTab(((DSUContainer)this.getOwner()).setTab(tab));
        if (oldTab == ((DSUContainer)this.getOwner()).activeTab) {
            return false;
        }
        if (((DSUContainer)this.getOwner()).activeTab.isItem()) {
            SoundHelper.playSound((World)this.field_146297_k.field_71441_e, (Entity)this.field_146297_k.field_71439_g, (IModSound)SoundRegistry.TAB_SWITCH, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    private void setInitialTab() {
        if (!this.hasSetTab) {
            this.hasSetTab = true;
            EntityEquipmentSlot preferedSlot = this.initialTab > -1 ? EnumReader.get(EntityEquipmentSlot.class, this.initialTab) : EntityEquipmentSlot.CHEST;
            boolean wantAnvil = this.initialTab == -2;
            int found = -1;
            for (UpgradeCap cap : ((DSUContainer)this.getOwner()).caps) {
                if (!cap.isAvailable()) continue;
                if (wantAnvil && cap.getSlotSelector().isAnvil()) {
                    found = cap.getSlotSelector().getTabOrder();
                    break;
                }
                if (found >= 0 && (!cap.getSlotSelector().isSlot() || cap.getSlotSelector().getSlot() != preferedSlot)) continue;
                found = cap.getSlotSelector().getTabOrder();
            }
            if (found >= 0) {
                this.setTab(((DSUContainer)this.getOwner()).setTab(found));
            }
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        this.setInitialTab();
        ((DSUContainer)this.getOwner()).calcSlots();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        DSUGui.func_152125_a((int)this.field_147003_i, (int)(this.field_147009_r + 5), (float)0.0f, (float)220.0f, (int)this.field_146999_f, (int)1, (int)this.field_146999_f, (int)111, (float)256.0f, (float)256.0f);
        if (((DSUContainer)this.getOwner()).activeTab.isAnvil()) {
            this.anvil.drawGuiContainerBackgroundLayer(par1, par2, par3);
        } else {
            boolean hasAnySlots = false;
            for (Slot inventorySlot : ((DSUContainer)this.getOwner()).field_75151_b) {
                DSUContainer.AutoSlot slot;
                if (!(inventorySlot instanceof DSUContainer.AutoSlot) || !(slot = (DSUContainer.AutoSlot)inventorySlot).func_111238_b()) continue;
                hasAnySlots = true;
                if (slot.isHead()) {
                    this.func_73729_b(this.field_147003_i + slot.getX() - 1 - 6, this.field_147009_r + slot.getY() - 1, 200, 18, 6, 18);
                }
                if (slot.isLocked()) {
                    this.func_73729_b(this.field_147003_i + slot.getX() - 1, this.field_147009_r + slot.getY() - 1, 236, 0, 18, 18);
                    continue;
                }
                if (slot.isBlocked()) {
                    this.func_73729_b(this.field_147003_i + slot.getX() - 1, this.field_147009_r + slot.getY() - 1, 218, 0, 18, 18);
                    continue;
                }
                this.func_73729_b(this.field_147003_i + slot.getX() - 1, this.field_147009_r + slot.getY() - 1, 200, 0, 18, 18);
            }
            if (hasAnySlots) {
                this.field_146289_q.func_78276_b(Lang.GUI_DSU_STORAGE.get(), this.field_147003_i + 7, this.field_147009_r + 99 - 11, 0x404040);
            } else {
                String str = (((DSUContainer)this.getOwner()).activeTab.isItem() ? Lang.GUI_DSU_NOT_INSERTED : Lang.GUI_DSU_NOT_INSTALLED).get();
                int y = 0;
                for (String sub : this.field_146289_q.func_78271_c(str, this.field_146999_f)) {
                    if (sub == null) continue;
                    int stringWidth = this.field_146289_q.func_78256_a(sub);
                    this.field_146289_q.func_78276_b(sub, this.field_147003_i + this.field_146999_f / 2 - stringWidth / 2, this.field_147009_r + (this.field_147000_g - 86) / 2 + y, 0x404040);
                    y += 9;
                }
            }
        }
        this.drawTabs();
        super.func_146976_a(par1, par2, par3);
    }

    private void drawTabs() {
        this.startTabs();
        for (UpgradeCap cap : ((DSUContainer)this.getOwner()).caps) {
            if (cap.getSlotSelector().isItem()) {
                Rectangle tabarea = this.renderStdTab(this.field_147003_i, this.field_147009_r, cap.getSlotSelector().getTabOrder(), cap.getSlotSelector() == ((DSUContainer)this.getOwner()).activeTab);
                Slot slot = cap.getSlotSelector().getContainerSlot();
                if (slot == null) continue;
                slot.field_75223_e = tabarea.x + tabarea.width - 5 - 16 - this.field_147003_i;
                slot.field_75221_f = tabarea.y + 5 - this.field_147009_r;
                this.bindGuiTexture();
                this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 200, 0, 18, 18);
                continue;
            }
            if (cap.isAvailable()) {
                this.renderStdTab(this.field_147003_i, this.field_147009_r, cap.getSlotSelector().getTabOrder(), cap.getSlotSelector().getItem((EntityPlayer)this.field_146297_k.field_71439_g), cap.getSlotSelector() == ((DSUContainer)this.getOwner()).activeTab);
                continue;
            }
            if (!cap.getSlotSelector().isSlot()) continue;
            this.renderStdTab(this.field_147003_i, this.field_147009_r, cap.getSlotSelector().getTabOrder(), new AtlasWidgetIcon(this.field_146297_k.func_147117_R().func_110572_b((String)TEXTURES.get(cap.getSlotSelector().getSlot().ordinal()))), cap.getSlotSelector() == ((DSUContainer)this.getOwner()).activeTab);
        }
    }

    protected void func_73869_a(char c, int key) throws IOException {
        if (((DSUContainer)this.getOwner()).activeTab.isAnvil() && this.anvil.keyTyped(c, key)) {
            return;
        }
        if (key == KeyTracker.dsu.getBinding().func_151463_i()) {
            if (!this.hideOverlays()) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
            return;
        }
        super.func_73869_a(c, key);
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        if (((DSUContainer)this.getOwner()).activeTab.isAnvil()) {
            this.anvil.mouseClicked(x, y, button);
        }
        super.func_73864_a(x, y, button);
    }

    protected void drawForegroundImpl(int mouseX, int mouseY) {
        if (((DSUContainer)this.getOwner()).activeTab.isAnvil()) {
            this.anvil.drawGuiContainerForegroundLayer(mouseX, mouseY);
        }
        super.drawForegroundImpl(mouseX, mouseY);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.anvil.onGuiClosed();
    }

    static {
        TEXTURES.addAll((Object[])ItemArmor.field_94603_a);
    }
}

