/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Enchantment
implements IRecipeConfigElement {
    protected Optional<String> name = this.empty();
    protected transient Optional<net.minecraft.enchantment.Enchantment> enchantment = this.empty();
    private double costMultiplier = 1.0;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (!this.name.isPresent()) {
            this.enchantment = this.empty();
            return this;
        }
        this.enchantment = this.ofNullable(net.minecraft.enchantment.Enchantment.func_180305_b((String)this.get(this.name)));
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            throw new InvalidRecipeConfigException("Could not find an enchantment for '" + this.name.get() + "'");
        }
    }

    @Override
    public boolean isValid() {
        return this.enchantment.isPresent();
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = this.ofString(value);
            return true;
        }
        if ("costMultiplier".equals(name)) {
            try {
                this.costMultiplier = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRecipeConfigException("Invalid value in 'amount': Not a number");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    public net.minecraft.enchantment.Enchantment getEnchantment() {
        return this.get(this.enchantment);
    }

    public double getCostMultiplier() {
        return this.costMultiplier;
    }
}

