/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events;

import crafttweaker.api.formatting.IFormattedText;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.tooltip.ITooltipFunction;
import crafttweaker.api.tooltip.IngredientTooltips;
import crafttweaker.mc1120.formatting.IMCFormattedString;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import stanhebben.zenscript.util.Pair;

public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent ev) {
        if (!ev.getItemStack().func_190926_b()) {
            IItemStack itemStack = CraftTweakerMC.getIItemStack(ev.getItemStack());
            if (IngredientTooltips.shouldClearToolTip(itemStack)) {
                ev.getToolTip().clear();
            }
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Pattern pattern : IngredientTooltips.getTooltipsToRemove(itemStack)) {
                for (String s : ev.getToolTip()) {
                    if (!pattern.matcher(s).find()) continue;
                    toRemove.add(s);
                }
            }
            ev.getToolTip().removeAll(toRemove);
            for (Pair pair : IngredientTooltips.getTooltips(itemStack)) {
                ev.getToolTip().add(((IMCFormattedString)pair.getKey()).getTooltipString());
            }
            for (Pair pair : IngredientTooltips.getAdvancedTooltips(itemStack)) {
                ev.getToolTip().add(((ITooltipFunction)pair.getKey()).process(itemStack));
            }
            boolean pressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            for (Pair<IFormattedText, IFormattedText> pair : IngredientTooltips.getShiftTooltips(itemStack)) {
                if (pressed) {
                    ev.getToolTip().add(((IMCFormattedString)pair.getKey()).getTooltipString());
                    continue;
                }
                if (pair.getValue() == null) continue;
                ev.getToolTip().add(((IMCFormattedString)pair.getValue()).getTooltipString());
            }
            for (Pair<ITooltipFunction, ITooltipFunction> pair : IngredientTooltips.getAdvancedShiftTooltips(itemStack)) {
                if (pressed) {
                    ev.getToolTip().add(pair.getKey().process(itemStack));
                    continue;
                }
                if (pair.getValue() == null) continue;
                ev.getToolTip().add(pair.getValue().process(itemStack));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent ev) {
    }
}

