/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.google.common.collect.ImmutableMap;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PeripheralGarden
implements IPlusPlusPeripheral {
    private ITurtleAccess turtle;

    public PeripheralGarden(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "gardener";
    }

    public String[] getMethodNames() {
        return new String[]{"getGrowth", "getGrowthUp", "getGrowthDown", "fertilize", "fertilizeUp", "fertilizeDown"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableGardeningTurtle) {
            throw new LuaException("Gardening Turtles have been disabled!");
        }
        switch (method) {
            case 0: {
                return this.getGrowth(this.turtle.getPosition().func_177972_a(this.turtle.getDirection()));
            }
            case 1: {
                return this.getGrowth(this.turtle.getPosition().func_177984_a());
            }
            case 2: {
                return this.getGrowth(this.turtle.getPosition().func_177977_b());
            }
            case 3: {
                return this.fertilize(this.turtle.getPosition().func_177972_a(this.turtle.getDirection()));
            }
            case 4: {
                return this.fertilize(this.turtle.getPosition().func_177984_a());
            }
            case 5: {
                return this.fertilize(this.turtle.getPosition().func_177977_b());
            }
        }
        throw new LuaException();
    }

    private Object[] fertilize(BlockPos pos) {
        boolean success = false;
        if (this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77969_a(new ItemStack(Items.field_151100_aR, 1, 15))) {
            ItemStack bonemeal = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
            IBlockState blockFacing = this.turtle.getWorld().func_180495_p(pos);
            if (blockFacing.func_177230_c() instanceof IGrowable) {
                success = ItemDye.func_179234_a((ItemStack)bonemeal, (World)this.turtle.getWorld(), (BlockPos)pos);
            }
        }
        return new Object[]{success};
    }

    private Object[] getGrowth(BlockPos pos) throws LuaException {
        IBlockState blockFacing = this.turtle.getWorld().func_180495_p(pos);
        if (blockFacing.func_177230_c() instanceof IGrowable) {
            ImmutableMap properties = blockFacing.func_177228_b();
            for (Map.Entry entry : properties.entrySet()) {
                if (!((IProperty)entry.getKey()).func_177701_a().equalsIgnoreCase("age") && !((IProperty)entry.getKey()).func_177701_a().equalsIgnoreCase("stage")) continue;
                if (((IProperty)entry.getKey()).getClass().isAssignableFrom(PropertyInteger.class)) {
                    HashMap<String, Object> growth = new HashMap<String, Object>();
                    growth.put("age", entry.getValue());
                    Object[] allowedValues = ((IProperty)entry.getKey()).func_177700_c().toArray();
                    growth.put("min", allowedValues[0]);
                    growth.put("max", allowedValues[allowedValues.length - 1]);
                    growth.put("percent", Float.valueOf(Float.valueOf(String.valueOf(entry.getValue())).floatValue() / (float)((Integer)allowedValues[allowedValues.length - 1]).intValue()));
                    return new Object[]{growth};
                }
                throw new LuaException("IGrowable \"age\" property is not of the type PropertyInteger");
            }
            throw new LuaException("IGrowable does not contain an \"age\" property.");
        }
        throw new LuaException("Block is not an instance of IGrowable");
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }
}

