/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PeripheralDispenser
implements IPlusPlusPeripheral {
    private ITurtleAccess turtle;

    public PeripheralDispenser(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "flinging";
    }

    public String[] getMethodNames() {
        return new String[]{"dispense", "dispenseUp", "dispenseDown"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        EnumFacing direction;
        if (!Config.enableFlingingTurtle) {
            throw new LuaException("Flinging turtles have been disabled");
        }
        if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
            throw new LuaException("Bad argument #1 (expected number)");
        }
        int slot = 1;
        switch (method) {
            case 0: {
                direction = this.turtle.getDirection();
                break;
            }
            case 1: {
                direction = EnumFacing.UP;
                break;
            }
            case 2: {
                direction = EnumFacing.DOWN;
                break;
            }
            default: {
                throw new LuaException("Unhandled method");
            }
        }
        slot = arguments.length > 0 ? (slot += (int)((Double)arguments[0]).doubleValue()) : this.turtle.getSelectedSlot();
        PeripheralDispenser peripheralDispenser = this;
        synchronized (peripheralDispenser) {
            IBehaviorDispenseItem behavior;
            ItemStack stack = this.turtle.getInventory().func_70301_a(slot);
            if (!stack.func_190926_b() && (behavior = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)stack.func_77973_b())) != IBehaviorDispenseItem.field_82483_a) {
                BlockSourceTurtle blockSource = new BlockSourceTurtle(direction);
                ItemStack newStack = behavior.func_82482_a((IBlockSource)blockSource, stack);
                this.turtle.getInventory().func_70299_a(slot, newStack);
                this.turtle.getInventory().func_70296_d();
            }
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public class BlockSourceTurtle
    implements IBlockSource {
        public EnumFacing direction;

        public BlockSourceTurtle(EnumFacing direction) {
            this.direction = direction;
        }

        public double func_82615_a() {
            return PeripheralDispenser.this.turtle.getPosition().func_177958_n();
        }

        public double func_82617_b() {
            return PeripheralDispenser.this.turtle.getPosition().func_177956_o();
        }

        public double func_82616_c() {
            return PeripheralDispenser.this.turtle.getPosition().func_177952_p();
        }

        public BlockPos func_180699_d() {
            return PeripheralDispenser.this.turtle.getPosition();
        }

        public IBlockState func_189992_e() {
            return Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)this.direction);
        }

        public TileEntity func_150835_j() {
            return this.func_82618_k().func_175625_s(PeripheralDispenser.this.turtle.getPosition());
        }

        public World func_82618_k() {
            return PeripheralDispenser.this.turtle.getWorld();
        }
    }
}

