/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersUtil;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.BouncyGPG;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.BuildDecryptionInputStreamAPI;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.BuildEncryptionOutputStreamAPI;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallbacks;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.InMemoryKeyring;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfigs;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Optional;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;

public class TileEntityPrivacyGuard
extends TileEntity
implements IPlusPlusPeripheral,
OpenComputersPeripheral {
    private static final String ENCODING = "US-ASCII";
    private Node node = OpenComputersUtil.createNode(this, this.getType());

    public TileEntityPrivacyGuard() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    @Nonnull
    public String getType() {
        return "privacy_guard";
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"generateKey", "readKey", "decrypt", "encrypt"};
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return this.generateKeyLua(arguments);
            }
            case 1: {
                return this.readKeyLua(arguments);
            }
            case 2: {
                return this.decryptLua(arguments);
            }
            case 3: {
                return this.encryptLua(arguments);
            }
        }
        throw new LuaException("No such method");
    }

    private Object[] encryptLua(Object[] arguments) throws LuaException {
        OutputStream encryptStream;
        PGPPublicKeyRing key;
        InMemoryKeyring keyring;
        if (arguments.length < 2) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof String)) {
            throw new LuaException("Argument #1 expected to be a string");
        }
        if (!(arguments[1] instanceof String)) {
            throw new LuaException("Argument #2 expected to be a string");
        }
        if (arguments.length > 2 && !(arguments[2] instanceof String) && arguments[2] != null) {
            throw new LuaException("Argument #3 expected to be a string or nil");
        }
        if (!(arguments.length <= 3 && arguments[2] == null || arguments[3] instanceof String)) {
            throw new LuaException("Argument #4 expected to be a string");
        }
        if (arguments.length > 4 && !(arguments[4] instanceof String)) {
            throw new LuaException("Argument #5 expected to be a string");
        }
        if (arguments.length > 5 && !(arguments[5] instanceof String)) {
            throw new LuaException("Argument #6 expected to be a string");
        }
        String keyString = (String)arguments[0];
        String plaintext = (String)arguments[1];
        String signKeyString = arguments.length > 2 ? (String)arguments[2] : null;
        String password = arguments.length > 3 ? (String)arguments[3] : null;
        String recipient = arguments.length > 4 ? (String)arguments[4] : null;
        String signer = arguments.length > 5 ? (String)arguments[5] : null;
        KeyringConfigCallback keyringCallback = KeyringConfigCallbacks.withUnprotectedKeys();
        if (password != null) {
            keyringCallback = KeyringConfigCallbacks.withPassword(password);
        }
        try {
            keyring = KeyringConfigs.forGpgExportedKeys(keyringCallback);
        }
        catch (IOException | PGPException e) {
            throw new LuaException(e.getMessage());
        }
        PGPSecretKeyRing signKey = null;
        try {
            key = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new ByteArrayInputStream(keyString.getBytes(ENCODING))), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            keyring.addPublicKey(keyString.getBytes(ENCODING));
            if (signKeyString != null) {
                signKey = new PGPSecretKeyRing(PGPUtil.getDecoderStream(new ByteArrayInputStream(signKeyString.getBytes(ENCODING))), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                keyring.addSecretKey(signKeyString.getBytes(ENCODING));
            }
        }
        catch (IOException | PGPException e) {
            throw new LuaException("Invalid key: " + e.getMessage());
        }
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            BuildEncryptionOutputStreamAPI.WithAlgorithmSuite.To.SignWith signWith = BouncyGPG.encryptToStream().withConfig(keyring).withStrongAlgorithms().toRecipient(recipient == null ? this.extractEmailFromKey(key) : recipient);
            BuildEncryptionOutputStreamAPI.WithAlgorithmSuite.To.SignWith.Armor armor = signKey != null ? signWith.andSignWith(signer == null ? this.extractEmailFromKey(signKey) : signer) : signWith.andDoNotSign();
            encryptStream = armor.armorAsciiOutput().andWriteTo(byteOutput);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | PGPException e) {
            throw new LuaException(e.getMessage());
        }
        try {
            encryptStream.write(plaintext.getBytes());
            encryptStream.flush();
            encryptStream.close();
        }
        catch (IOException e) {
            throw new LuaException("IO error: " + e.getMessage());
        }
        try {
            return new Object[]{byteOutput.toString(ENCODING)};
        }
        catch (UnsupportedEncodingException e) {
            throw new LuaException(e.getMessage());
        }
    }

    private String extractEmailFromKey(PGPSecretKeyRing key) throws LuaException {
        Iterator<PGPSecretKey> keys = key.getSecretKeys();
        while (keys.hasNext()) {
            String email = this.extractEmailFromUserIds(keys.next().getUserIDs());
            if (email == null) continue;
            return email;
        }
        throw new LuaException("Missing email feild in GPG key");
    }

    private String extractEmailFromKey(PGPPublicKeyRing key) throws LuaException {
        Iterator<PGPPublicKey> keys = key.getPublicKeys();
        while (keys.hasNext()) {
            String email = this.extractEmailFromUserIds(keys.next().getUserIDs());
            if (email == null) continue;
            return email;
        }
        throw new LuaException("Missing email field in GPG key");
    }

    @Nullable
    private String extractEmailFromUserIds(Iterator<String> ids) {
        Pattern emailRegex = Pattern.compile(".*<(.*@.*\\..*)>");
        while (ids.hasNext()) {
            Matcher matcher = emailRegex.matcher(ids.next());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private Object[] decryptLua(Object[] arguments) throws LuaException {
        InputStream decryptStream;
        BuildDecryptionInputStreamAPI.Build build;
        InMemoryKeyring keyring;
        if (arguments.length < 3) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof String)) {
            throw new LuaException("Argument #1 expected to be a string");
        }
        if (!(arguments[1] instanceof String) && arguments[1] != null) {
            throw new LuaException("Argument #2 expected to be a string or nil");
        }
        if (!(arguments[2] instanceof String)) {
            throw new LuaException("Argument #3 expected to be a string");
        }
        if (arguments.length > 3 && !(arguments[3] instanceof Map)) {
            throw new LuaException("Argument #4 expected to be a table");
        }
        if (arguments.length > 4 && !(arguments[4] instanceof Map) && !(arguments[4] instanceof Boolean)) {
            throw new LuaException("Argument #5 expected to be a table or boolean");
        }
        String keyString = (String)arguments[0];
        String password = (String)arguments[1];
        String encodedText = (String)arguments[2];
        ArrayList<String> verificationKeys = arguments.length > 3 ? this.luaMapToStringList((Map)arguments[3]) : new ArrayList<String>();
        ArrayList verificationIds = arguments.length > 4 && arguments[4] instanceof Map ? this.luaMapToStringList((Map)arguments[4]) : new ArrayList();
        boolean verifyAll = arguments.length > 4 && arguments[4] instanceof Boolean && (Boolean)arguments[4] != false;
        KeyringConfigCallback keyringCallback = KeyringConfigCallbacks.withUnprotectedKeys();
        if (password != null) {
            keyringCallback = KeyringConfigCallbacks.withPassword(password);
        }
        try {
            keyring = KeyringConfigs.forGpgExportedKeys(keyringCallback);
        }
        catch (IOException | PGPException e) {
            throw new LuaException(e.getMessage());
        }
        try {
            keyring.addSecretKey(keyString.getBytes(ENCODING));
        }
        catch (IOException | PGPException e) {
            throw new LuaException("Invalid key: " + e.getMessage());
        }
        for (String verificationKey : verificationKeys) {
            try {
                keyring.addPublicKey(verificationKey.getBytes(ENCODING));
            }
            catch (IOException | PGPException e) {
                throw new LuaException("Invalid verification key: " + e.getMessage());
            }
        }
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        BuildDecryptionInputStreamAPI.Validation validation = BouncyGPG.decryptAndVerifyStream().withConfig(keyring);
        if (verificationIds.size() == 0 && verificationKeys.size() == 0) {
            build = validation.andIgnoreSignatures();
        } else {
            try {
                build = verifyAll ? validation.andRequireSignatureFromAllKeys(this.extractAllIdsFromPublicKeys(verificationKeys)) : validation.andRequireSignatureFromAllKeys(verificationIds.toArray(new String[verificationIds.size()]));
            }
            catch (IOException | PGPException e) {
                throw new LuaException("Failed to verify signature: " + e.getMessage());
            }
        }
        try {
            decryptStream = build.fromEncryptedInputStream(new ByteArrayInputStream(encodedText.getBytes(ENCODING)));
        }
        catch (IOException | NoSuchProviderException e) {
            if (e.getCause() instanceof PGPException) {
                throw new LuaException(e.getMessage() + ": " + e.getCause().getMessage());
            }
            throw new LuaException(e.getMessage());
        }
        try {
            Streams.pipeAll(decryptStream, byteOutput);
            decryptStream.close();
            byteOutput.flush();
        }
        catch (IOException e) {
            throw new LuaException("IO Error: " + e.getMessage());
        }
        try {
            return new Object[]{byteOutput.toString(ENCODING)};
        }
        catch (UnsupportedEncodingException e) {
            throw new LuaException(e.getMessage());
        }
    }

    private Long[] extractAllIdsFromPublicKeys(List<String> keys) throws IOException {
        ArrayList<Long> ids = new ArrayList<Long>();
        BcKeyFingerprintCalculator calc = new BcKeyFingerprintCalculator();
        for (String keyString : keys) {
            PGPPublicKeyRing key = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new ByteArrayInputStream(keyString.getBytes(ENCODING))), (KeyFingerPrintCalculator)calc);
            Iterator<PGPPublicKey> publicKeys = key.getPublicKeys();
            while (publicKeys.hasNext()) {
                PGPPublicKey publicKey = publicKeys.next();
                if (publicKey.isEncryptionKey()) continue;
                ids.add(publicKey.getKeyID());
            }
        }
        return ids.toArray(new Long[ids.size()]);
    }

    private List<String> luaMapToStringList(Map<Double, String> map) throws LuaException {
        ArrayList<String> list = new ArrayList<String>();
        Double index = 1.0;
        while (index <= (double)map.size()) {
            if (!map.containsKey(index)) {
                throw new LuaException("Table contains invalid key");
            }
            list.add(map.get(index));
            Double d = index;
            Double d2 = index = Double.valueOf(index + 1.0);
        }
        return list;
    }

    private Object[] readKeyLua(Object[] arguments) throws LuaException {
        HashMap<String, Object> keyMap;
        Iterator<Object> keysIter;
        PGPKeyRing key2;
        if (arguments.length < 1) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof String)) {
            throw new LuaException("Argument #1 expected to be a string");
        }
        String keyString = (String)arguments[0];
        ArrayList keys = new ArrayList();
        try {
            key2 = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new ByteArrayInputStream(keyString.getBytes(ENCODING))), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            keysIter = ((PGPPublicKeyRing)key2).getPublicKeys();
            while (keysIter.hasNext()) {
                keyMap = new HashMap<String, Object>();
                PGPPublicKey publicKey = (PGPPublicKey)keysIter.next();
                keyMap.put("private", false);
                keyMap.put("masterKey", publicKey.isMasterKey());
                keyMap.put("signingKey", !publicKey.isEncryptionKey());
                keyMap.put("id", Double.parseDouble(String.valueOf(publicKey.getKeyID())));
                keyMap.put("version", publicKey.getVersion());
                keyMap.put("algorithm", publicKey.getAlgorithm());
                keyMap.put("strength", publicKey.getBitStrength());
                keyMap.put("creationTime", publicKey.getCreationTime());
                keyMap.put("userIds", Util.iteratorToMap(publicKey.getUserIDs()));
                keyMap.put("fingerprint", Util.byteArraytoUnsignedIntArray(publicKey.getFingerprint()));
                keyMap.put("signatures", Util.iteratorToMap(publicKey.getKeySignatures()));
                keyMap.put("validSeconds", Double.parseDouble(String.valueOf(publicKey.getValidSeconds())));
                keys.add(keyMap);
            }
        }
        catch (IOException key2) {
            // empty catch block
        }
        try {
            key2 = new PGPSecretKeyRing(PGPUtil.getDecoderStream(new ByteArrayInputStream(keyString.getBytes(ENCODING))), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            keysIter = ((PGPSecretKeyRing)key2).getSecretKeys();
            while (keysIter.hasNext()) {
                keyMap = new HashMap();
                PGPSecretKey secretKey = (PGPSecretKey)keysIter.next();
                keyMap.put("private", true);
                keyMap.put("masterKey", secretKey.isMasterKey());
                keyMap.put("signingKey", secretKey.isSigningKey());
                keyMap.put("id", Double.parseDouble(String.valueOf(secretKey.getKeyID())));
                keyMap.put("s2k", secretKey.getS2KUsage());
                keyMap.put("algorithm", secretKey.getKeyEncryptionAlgorithm());
                keyMap.put("userIds", Util.iteratorToMap(secretKey.getUserIDs()));
                keys.add(keyMap);
            }
        }
        catch (IOException key3) {
        }
        catch (PGPException e) {
            throw new LuaException(e.getMessage());
        }
        return new Object[]{Util.arrayToMap(keys.toArray())};
    }

    private Object[] generateKeyLua(Object[] arguments) throws LuaException {
        int size = 2048;
        String password = null;
        if (arguments.length < 1 || !(arguments[0] instanceof String)) {
            throw new LuaException("Argument #1 expected to be a string");
        }
        String id = (String)arguments[0];
        if (arguments.length > 1) {
            if (!(arguments[1] instanceof Double)) {
                throw new LuaException("Argument #2 expected to be an integer");
            }
            size = ((Double)arguments[1]).intValue();
        }
        if (arguments.length > 2) {
            if (!(arguments[2] instanceof String)) {
                throw new LuaException("Argument #3 expected to be a string");
            }
            password = (String)arguments[2];
        }
        PGPKeyRingGenerator generator = this.createPGPKeyRingGenerator(id, size, password);
        PGPPublicKeyRing publicKeyRing = generator.generatePublicKeyRing();
        PGPSecretKeyRing secretKeyRing = generator.generateSecretKeyRing();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        try {
            keyMap.put("public", this.wrapGpgKey(publicKeyRing.getEncoded(), KeyType.PUBLIC));
            keyMap.put("secret", this.wrapGpgKey(secretKeyRing.getEncoded(), KeyType.PRIVATE));
        }
        catch (IOException e) {
            throw new LuaException("Failed to generate keys: " + e.getMessage());
        }
        return new Object[]{keyMap};
    }

    private String wrapGpgKey(byte[] key, KeyType keyType) throws IOException {
        String header = String.format("-----BEGIN PGP %s KEY BLOCK-----", keyType.name());
        String footer = String.format("-----END PGP %s KEY BLOCK-----", keyType.name());
        CRC24 checksum = new CRC24();
        for (byte b : key) {
            checksum.update(b);
        }
        byte[] crcArray = BigInteger.valueOf(checksum.getValue()).toByteArray();
        if (crcArray.length > 3) {
            System.arraycopy(crcArray, 1, crcArray, 0, 3);
        }
        String crc = String.format("=%s", Base64.toBase64String(crcArray));
        String keyBlock = Base64.toBase64String(key);
        return String.format("%s\n\n%s\n%s\n%s", header, keyBlock, crc, footer);
    }

    private PGPKeyRingGenerator createPGPKeyRingGenerator(String id, int size, @Nullable String password) throws LuaException {
        PGPKeyRingGenerator generator;
        PGPDigestCalculator sha256Calc;
        PGPDigestCalculator sha1Calc;
        BcPGPKeyPair encryptKey;
        BcPGPKeyPair signKey;
        RSAKeyPairGenerator keyPairGenerator = this.createKeyPairGenerator(size);
        try {
            signKey = new BcPGPKeyPair(3, keyPairGenerator.generateKeyPair(), new Date());
            encryptKey = new BcPGPKeyPair(2, keyPairGenerator.generateKeyPair(), new Date());
        }
        catch (PGPException e) {
            throw new LuaException("Could not create key: " + e.getMessage());
        }
        PGPSignatureSubpacketGenerator signSignatureGenerator = new PGPSignatureSubpacketGenerator();
        signSignatureGenerator.setKeyFlags(false, 3);
        signSignatureGenerator.setPreferredSymmetricAlgorithms(false, new int[]{9, 8, 7});
        signSignatureGenerator.setPreferredHashAlgorithms(false, new int[]{8, 2, 9, 10, 11});
        signSignatureGenerator.setFeature(false, (byte)1);
        PGPSignatureSubpacketGenerator encryptSignatureGenerator = new PGPSignatureSubpacketGenerator();
        encryptSignatureGenerator.setKeyFlags(false, 12);
        try {
            sha1Calc = new BcPGPDigestCalculatorProvider().get(2);
            sha256Calc = new BcPGPDigestCalculatorProvider().get(8);
        }
        catch (PGPException e) {
            throw new LuaException("Unsupported hashing algorithm: " + e.getMessage());
        }
        PBESecretKeyEncryptor keyEncryptor = password != null ? new BcPBESecretKeyEncryptorBuilder(9, sha256Calc, 192).build(password.toCharArray()) : new BcPBESecretKeyEncryptorBuilder(0).build(new char[0]);
        try {
            generator = new PGPKeyRingGenerator(19, signKey, id, sha1Calc, signSignatureGenerator.generate(), null, new BcPGPContentSignerBuilder(signKey.getPublicKey().getAlgorithm(), 2), keyEncryptor);
            generator.addSubKey(encryptKey, encryptSignatureGenerator.generate(), null);
        }
        catch (PGPException e) {
            throw new LuaException(e.getMessage());
        }
        return generator;
    }

    private RSAKeyPairGenerator createKeyPairGenerator(int size) throws LuaException {
        RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
        try {
            generator.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), SecureRandom.getInstanceStrong(), size, 80));
        }
        catch (NoSuchAlgorithmException e) {
            throw new LuaException("RSA is not supported");
        }
        return generator;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @Optional.Method(modid="opencomputers|core")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers|core")
    public String[] methods() {
        return this.getMethodNames();
    }

    @Optional.Method(modid="opencomputers|core")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        this.callMethod(null, null, Arrays.asList(this.getMethodNames()).indexOf(method), args.toArray());
        throw new NoSuchMethodException(method);
    }

    public void func_73660_a() {
        OpenComputersUtil.updateNode(this, this.node);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        OpenComputersUtil.removeNode(this.node);
    }

    public void func_145843_s() {
        super.func_145843_s();
        OpenComputersUtil.removeNode(this.node);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        OpenComputersUtil.readFromNbt(compound, this.node);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        OpenComputersUtil.writeToNbt(compound, this.node);
        return compound;
    }

    private static enum KeyType {
        PUBLIC,
        PRIVATE;

    }
}

