/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.TileEntityInteractiveSorter;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersUtil;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Optional.InterfaceList(value={@Optional.Interface(modid="appliedenergistics2", iface="appeng.api.networking.security.IActionHost", striprefs=true), @Optional.Interface(modid="appliedenergistics2", iface="appeng.api.networking.IGridBlock", striprefs=true), @Optional.Interface(modid="appliedenergistics2", iface="appeng.api.networking.IGridHost", striprefs=true), @Optional.Interface(modid="appliedenergistics2", iface="appeng.api.networking.security.IActionSource", striprefs=true)})
public class TileEntityMEBridge
extends TileEntity
implements IActionHost,
IGridBlock,
ITickable,
IActionSource,
IGridHost,
IPlusPlusPeripheral,
OpenComputersPeripheral {
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private IGridNode node;
    private boolean initialized = false;
    private EntityPlayer placed;
    private Node nodeOc = OpenComputersUtil.createNode(this, this.getType());

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.node != null) {
            this.node.destroy();
        }
        this.node = AEApi.instance().grid().createGridNode((IGridBlock)this);
        this.node.loadFromNBT("node", nbttagcompound);
        this.initialized = false;
        OpenComputersUtil.readFromNbt(nbttagcompound, this.nodeOc);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return nbttagcompound;
        }
        if (this.node != null) {
            this.node.saveToNBT("node", nbttagcompound);
        }
        OpenComputersUtil.writeToNbt(nbttagcompound, this.nodeOc);
        return nbttagcompound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.initialized) {
                this.node = AEApi.instance().grid().createGridNode((IGridBlock)this);
                if (this.placed != null) {
                    this.node.setPlayerID(AEApi.instance().registries().players().getID(this.placed));
                }
                this.node.updateState();
                this.initialized = true;
            }
            OpenComputersUtil.updateNode(this, this.nodeOc);
        }
    }

    public String getType() {
        return "meBridge";
    }

    public String[] getMethodNames() {
        return new String[]{"listAll", "listItems", "listCraft", "retrieve", "craft"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableMEBridge) {
            throw new LuaException("ME Bridges have been disabled");
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            throw new LuaException("Applied Energistics 2 is not installed");
        }
        IMEMonitor grid = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        switch (method) {
            case 0: {
                return new Object[]{this.iteratorToMap(grid.getStorageList().iterator(), 0)};
            }
            case 1: {
                return new Object[]{this.iteratorToMap(grid.getStorageList().iterator(), 1)};
            }
            case 2: {
                return new Object[]{this.iteratorToMap(grid.getStorageList().iterator(), 2)};
            }
            case 3: {
                return this.retrieve(arguments, (IMEMonitor<IAEItemStack>)grid);
            }
            case 4: {
                return this.craft(arguments, (IMEMonitor<IAEItemStack>)grid);
            }
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] craft(Object[] arguments, IMEMonitor<IAEItemStack> monitor) throws LuaException {
        if (arguments.length < 3) {
            throw new LuaException("Too few arguments");
        }
        if (!(arguments[0] instanceof String)) {
            throw new LuaException("Bad argument #1: name should be a string");
        }
        if (!(arguments[1] instanceof Double)) {
            throw new LuaException("Bad argument #2: Meta should be an number");
        }
        if (!(arguments[2] instanceof Double)) {
            throw new LuaException("Bad argument #3: amount should be a number");
        }
        if (arguments.length > 3 && !(arguments[3] instanceof String)) {
            throw new LuaException("Bad argument #4: amount should be a string");
        }
        String itemName = (String)arguments[0];
        int meta = (int)((Double)arguments[1]).doubleValue();
        long amount = (long)((Double)arguments[2]).doubleValue();
        String nbtString = arguments.length > 3 ? (String)arguments[3] : "";
        ItemStack toCraft = GameRegistry.makeItemStack((String)itemName, (int)meta, (int)1, (String)nbtString);
        if (toCraft.func_190926_b()) {
            throw new LuaException("Failed to find item");
        }
        IAEItemStack aeToCraft = this.findAEStackFromItemStack(monitor, toCraft);
        if (aeToCraft == null) {
            throw new LuaException("Failed to find item in AE system");
        }
        if (!aeToCraft.isCraftable()) {
            throw new LuaException("AE system cannot craft item");
        }
        aeToCraft = aeToCraft.copy();
        aeToCraft.setStackSize(amount);
        TileEntityMEBridge tileEntityMEBridge = this;
        synchronized (tileEntityMEBridge) {
            ICraftingGrid craftingGrid = (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
            craftingGrid.beginCraftingJob(this.field_145850_b, this.node.getGrid(), (IActionSource)this, aeToCraft, job -> {
                ICraftingLink result = craftingGrid.submitJob(job, null, null, false, (IActionSource)this);
                ResourceLocation itemName1 = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)job.getOutput().getItem());
                Object[] event = new Object[]{itemName1 == null ? "null" : itemName1.toString(), job.getOutput().getStackSize(), job.getByteTotal(), result != null};
                for (IComputerAccess comp : this.computers.keySet()) {
                    comp.queueEvent("craftingComplete", event);
                }
                OpenComputersUtil.sendToReachable(this.nodeOc, "craftingComplete", event);
            });
        }
        return new Object[0];
    }

    private Object[] retrieve(Object[] arguments, IMEMonitor<IAEItemStack> monitor) throws LuaException {
        if (arguments.length < 4) {
            throw new LuaException("Too few arguments");
        }
        if (!(arguments[0] instanceof String)) {
            throw new LuaException("Bad argument #1: name should be a string");
        }
        if (!(arguments[1] instanceof Double)) {
            throw new LuaException("Bad argument #2: Meta should be an number");
        }
        if (!(arguments[2] instanceof Double)) {
            throw new LuaException("Bad argument #3: amount should be a number");
        }
        if (!(arguments[3] instanceof String) && !(arguments[3] instanceof Double)) {
            throw new LuaException("Bad argument #4: direction should be a string or number");
        }
        if (arguments.length > 4 && !(arguments[4] instanceof String)) {
            throw new LuaException("Bad argument #5: nbt should be a string");
        }
        String itemName = (String)arguments[0];
        int meta = (int)((Double)arguments[1]).doubleValue();
        long amount = (long)((Double)arguments[2]).doubleValue();
        EnumFacing direction = arguments[3] instanceof String ? EnumFacing.valueOf((String)String.valueOf(arguments[3]).toUpperCase(Locale.US)) : EnumFacing.func_82600_a((int)((int)((Double)arguments[3]).doubleValue()));
        String nbtString = arguments.length > 4 ? (String)arguments[4] : "";
        IInventory inventory = TileEntityInteractiveSorter.getInventoryForSide(this.field_145850_b, this.func_174877_v(), direction);
        if (inventory == null) {
            throw new LuaException("Block is not a valid inventory");
        }
        ItemStack item = GameRegistry.makeItemStack((String)itemName, (int)meta, (int)1, (String)nbtString);
        if (item.func_190926_b()) {
            throw new LuaException("Item not found");
        }
        long extracted = 0L;
        IAEItemStack stack = this.findAEStackFromItemStack(monitor, item);
        if (stack != null) {
            if (amount > stack.getStackSize()) {
                amount = stack.getStackSize();
            }
            if (amount > (long)this.getRemainingSlots(item.func_77973_b(), inventory)) {
                amount = this.getRemainingSlots(item.func_77973_b(), inventory);
            }
            IAEItemStack stackToGet = stack.copy();
            stackToGet.setStackSize(amount);
            IAEItemStack resultant = (IAEItemStack)monitor.extractItems((IAEStack)stackToGet, Actionable.MODULATE, (IActionSource)this);
            if (resultant != null) {
                extracted = resultant.getStackSize();
                int[] slots = inventory instanceof ISidedInventory ? ((ISidedInventory)inventory).func_180463_a(direction.func_176734_d()) : this.getDefaultSlots(inventory);
                int currentSlot = 0;
                ItemStack itemStack = resultant.createItemStack();
                itemStack.func_190920_e(1);
                while (resultant.getStackSize() >= 1L && currentSlot < slots.length) {
                    if (inventory.func_94041_b(slots[currentSlot], itemStack.func_77946_l())) {
                        if (inventory.func_70301_a(slots[currentSlot]).func_190926_b()) {
                            ItemStack toAdd = itemStack.func_77946_l();
                            inventory.func_70299_a(slots[currentSlot], toAdd);
                            resultant.setStackSize(resultant.getStackSize() - 1L);
                        } else {
                            ItemStack toAdd;
                            ItemStack current = inventory.func_70301_a(slots[currentSlot]);
                            if (ItemStack.func_179545_c((ItemStack)current, (ItemStack)(toAdd = itemStack.func_77946_l())) && ItemStack.func_77970_a((ItemStack)current, (ItemStack)toAdd) && toAdd.func_190916_E() + current.func_190916_E() <= Math.min(current.func_77976_d(), inventory.func_70297_j_())) {
                                current.func_190920_e(current.func_190916_E() + 1);
                                inventory.func_70299_a(slots[currentSlot], current);
                                resultant.setStackSize(resultant.getStackSize() - 1L);
                            } else {
                                ++currentSlot;
                            }
                        }
                        inventory.func_70296_d();
                        continue;
                    }
                    ++currentSlot;
                }
            }
        }
        return new Object[]{extracted};
    }

    private int[] getDefaultSlots(IInventory inventory) {
        int[] array = new int[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            array[i] = i;
        }
        return array;
    }

    private int getRemainingSlots(Item item, IInventory inventory) {
        int slots = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_94041_b(i, new ItemStack(item)) && inventory.func_70301_a(i).func_190926_b()) {
                slots += inventory.func_70297_j_();
                continue;
            }
            if (!inventory.func_94041_b(i, new ItemStack(item)) || inventory.func_70301_a(i).func_77973_b() != item || inventory.func_70297_j_() < inventory.func_70301_a(i).func_190916_E()) continue;
            slots += inventory.func_70297_j_() - inventory.func_70301_a(i).func_190916_E();
        }
        return slots;
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.destroy();
            this.node = null;
            this.initialized = false;
        }
        OpenComputersUtil.removeNode(this.nodeOc);
    }

    private IAEItemStack findAEStackFromItemStack(IMEMonitor<IAEItemStack> monitor, ItemStack item) {
        IAEItemStack stack = null;
        for (IAEItemStack temp : monitor.getStorageList()) {
            if (!temp.isSameType(item)) continue;
            stack = temp;
            break;
        }
        return stack;
    }

    private HashMap<Integer, Object> iteratorToMap(Iterator<IAEItemStack> iterator, int flag) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int i = 1;
        while (iterator.hasNext()) {
            Object o = this.getObjectFromStack(iterator.next(), flag);
            if (o == null) continue;
            map.put(i++, o);
        }
        return map;
    }

    private Object getObjectFromStack(IAEItemStack stack, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResourceLocation itemResourceLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.getItem());
        String itemName = itemResourceLocation == null ? "null" : itemResourceLocation.toString();
        int meta = stack.getItemDamage();
        long amount = stack.getStackSize();
        String displayName = new ItemStack(stack.getItem()).func_82833_r();
        NBTTagCompound nbt = stack.createItemStack().func_77978_p();
        map.put("name", itemName);
        map.put("meta", meta);
        map.put("amount", amount);
        map.put("displayName", displayName);
        map.put("nbt", nbt == null ? "" : nbt.toString());
        if (flag == 0) {
            return map;
        }
        if (flag == 1 ? stack.getStackSize() > 0L : flag == 2 && stack.isCraftable()) {
            return map;
        }
        return null;
    }

    public double getIdlePowerUsage() {
        return 1.0;
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    public boolean isWorldAccessible() {
        return true;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AEColor getGridColor() {
        return AEColor.TRANSPARENT;
    }

    public void onGridNotification(GridNotification notification) {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("gridNotification", new Object[]{notification.toString()});
        }
        OpenComputersUtil.sendToReachable(this.nodeOc, "gridNotification", notification.toString());
    }

    public void setNetworkStatus(IGrid grid, int channelsInUse) {
    }

    public EnumSet<EnumFacing> getConnectableSides() {
        return EnumSet.allOf(EnumFacing.class);
    }

    public IGridHost getMachine() {
        return this;
    }

    public void gridChanged() {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("gridChanged", new Object[0]);
        }
        OpenComputersUtil.sendToReachable(this.nodeOc, "gridChanged", new Object[0]);
    }

    public ItemStack getMachineRepresentation() {
        return new ItemStack((Block)ModBlocks.ME_BRIDGE);
    }

    public IGridNode getActionableNode() {
        return this.node;
    }

    @Nonnull
    public Optional<EntityPlayer> player() {
        return Optional.empty();
    }

    @Nonnull
    public Optional<IActionHost> machine() {
        return Optional.of(this);
    }

    @Nonnull
    public <T> Optional<T> context(@Nonnull Class<T> key) {
        return Optional.empty();
    }

    public void setPlayer(EntityPlayer player) {
        this.placed = player;
    }

    public IGridNode getGridNode(AEPartLocation dir) {
        return this.node;
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    public void securityBreak() {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("securityBreak", new Object[0]);
        }
        OpenComputersUtil.sendToReachable(this.nodeOc, "securityBreak", new Object[0]);
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Optional.Method(modid="opencomputers|core")
    public String[] methods() {
        return this.getMethodNames();
    }

    @Optional.Method(modid="opencomputers|core")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "listAll": {
                return this.callMethod(null, null, 0, args.toArray());
            }
            case "listItems": {
                return this.callMethod(null, null, 1, args.toArray());
            }
            case "listCraft": {
                return this.callMethod(null, null, 2, args.toArray());
            }
            case "retrieve": {
                return this.callMethod(null, null, 3, args.toArray());
            }
            case "craft": {
                return this.callMethod(null, null, 4, args.toArray());
            }
        }
        throw new NoSuchMethodException(method);
    }

    @Optional.Method(modid="opencomputers|core")
    public Node node() {
        return this.nodeOc;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        OpenComputersUtil.removeNode(this.nodeOc);
    }
}

