/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.recipe;

import com.austinv11.peripheralsplusplus.init.ModItems;
import com.austinv11.peripheralsplusplus.utils.rfid.RfidTag;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RecipeRfidChip
implements IRecipe {
    private ResourceLocation group;
    private ResourceLocation name;

    public RecipeRfidChip(ResourceLocation group) {
        this.group = group;
    }

    public RecipeRfidChip() {
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return this.matchesAdd(inv) || this.matchesRemove(inv);
    }

    private boolean matchesRemove(InventoryCrafting inv) {
        ItemStack rfidItem = this.getRfidItem(inv);
        if (rfidItem.func_190926_b()) {
            return false;
        }
        ItemStack fork = this.getFork(inv);
        return !fork.func_190926_b() && this.getInventorySize(inv) == 2;
    }

    private int getInventorySize(InventoryCrafting inv) {
        int size = 0;
        for (int itemIndex = 0; itemIndex < inv.func_70302_i_(); ++itemIndex) {
            if (inv.func_70301_a(itemIndex).func_190926_b()) continue;
            ++size;
        }
        return size;
    }

    private boolean matchesAdd(InventoryCrafting inv) {
        ItemStack blankItem = this.getBlankItem(inv);
        if (blankItem.func_190926_b()) {
            return false;
        }
        ItemStack rfidChip = this.getRfidChip(inv);
        return !rfidChip.func_190926_b() && this.getInventorySize(inv) == 2;
    }

    @Nonnull
    private ItemStack getRfidChip(InventoryCrafting inv) {
        return this.getItemFromInventory(inv, new ItemStack(ModItems.RFID_CHIP));
    }

    @Nonnull
    private ItemStack getFork(InventoryCrafting inv) {
        return this.getItemFromInventory(inv, new ItemStack(ModItems.FORK));
    }

    @Nonnull
    private ItemStack getItemFromInventory(InventoryCrafting inv, ItemStack match) {
        ItemStack found = ItemStack.field_190927_a;
        for (int itemIndex = 0; itemIndex < inv.func_70302_i_(); ++itemIndex) {
            ItemStack itemStack = inv.func_70301_a(itemIndex).func_77946_l();
            if (itemStack.func_190926_b() || !itemStack.func_77969_a(match)) continue;
            if (!found.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            found = itemStack;
        }
        return found;
    }

    @Nonnull
    private ItemStack getBlankItem(InventoryCrafting inv) {
        return this.getRfidItem(inv, true);
    }

    @Nonnull
    private ItemStack getRfidItem(InventoryCrafting inv, boolean blankItem) {
        ItemStack rfidItem = ItemStack.field_190927_a;
        for (int itemIndex = 0; itemIndex < inv.func_70302_i_(); ++itemIndex) {
            ItemStack itemStack = inv.func_70301_a(itemIndex).func_77946_l();
            if (itemStack.func_190926_b() || itemStack.func_77969_a(new ItemStack(ModItems.RFID_CHIP)) || itemStack.func_77969_a(new ItemStack(ModItems.FORK)) || (blankItem || !RfidTag.hasTag(itemStack)) && (!blankItem || RfidTag.hasTag(itemStack))) continue;
            if (!rfidItem.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            rfidItem = itemStack;
        }
        return rfidItem;
    }

    @Nonnull
    private ItemStack getRfidItem(InventoryCrafting inv) {
        return this.getRfidItem(inv, false);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (this.matchesAdd(inv)) {
            ItemStack rfidChip = this.getRfidChip(inv);
            ItemStack blankItem = this.getBlankItem(inv);
            RfidTag rfidTag = new RfidTag(rfidChip);
            RfidTag.addTag(blankItem, rfidTag);
            if (blankItem.func_77969_a(new ItemStack(ModItems.PLASTIC_CARD))) {
                blankItem.func_190924_f(blankItem.func_77977_a() + (Math.random() < 0.5 ? ".name_rfid" : ".name_nfc"));
            }
            return blankItem;
        }
        ItemStack rfidItem = this.getRfidItem(inv).func_77946_l();
        return RfidTag.createChip(new RfidTag(rfidItem));
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        if (this.matchesAdd(inv)) {
            return super.func_179532_b(inv);
        }
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int itemIndex = 0; itemIndex < inv.func_70302_i_(); ++itemIndex) {
            ItemStack item = inv.func_70301_a(itemIndex).func_77946_l();
            if (RfidTag.hasTag(item)) {
                RfidTag.removeTag(item);
            }
            list.set(itemIndex, (Object)item);
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return new ItemStack(ModItems.RFID_CHIP);
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public String func_193358_e() {
        return this.group.toString();
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        ItemStack item = event.getPlayer().func_184586_b(event.getHand());
        if (RfidTag.hasTag(item)) {
            ItemStack chip = RfidTag.createChip(new RfidTag(item));
            EntityItem chipEntity = new EntityItem(event.getWorld(), (double)event.getBlockSnapshot().getPos().func_177958_n(), (double)event.getBlockSnapshot().getPos().func_177956_o(), (double)event.getBlockSnapshot().getPos().func_177952_p(), chip);
            event.getWorld().func_72838_d((Entity)chipEntity);
        }
    }
}

