/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.tiles.TileEntitySpeaker;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SynthResponsePacket
implements IMessage {
    private UUID eventId;
    private BlockPos pos;
    public String text;
    public int x;
    public int y;
    public int z;
    public World world;
    public TurtleSide side;

    public SynthResponsePacket() {
    }

    public SynthResponsePacket(String text, BlockPos pos, World world, TurtleSide side, UUID eventId) {
        this.text = text;
        this.pos = pos;
        this.world = world;
        this.side = side;
        this.eventId = eventId;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.text = tag.func_74779_i("text");
        int[] posArray = tag.func_74759_k("pos");
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.world = DimensionManager.getWorld((int)tag.func_74762_e("dim"));
        this.side = tag.func_74779_i("side").equals("null") ? null : TurtleSide.valueOf((String)tag.func_74779_i("side"));
        this.eventId = tag.func_186857_a("eventId");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("text", this.text);
        tag.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        tag.func_74768_a("dim", this.world.field_73011_w.getDimension());
        tag.func_74778_a("side", this.side == null ? "null" : this.side.name());
        tag.func_186854_a("eventId", this.eventId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class SynthResponsePacketHandler
    implements IMessageHandler<SynthResponsePacket, IMessage> {
        public IMessage onMessage(SynthResponsePacket message, MessageContext ctx) {
            if (message.side == null) {
                TileEntity tileEntity = message.world.func_175625_s(message.pos);
                if (tileEntity != null) {
                    ((TileEntitySpeaker)tileEntity).onSpeechCompletion(message.text, message.eventId);
                }
            } else {
                try {
                    IPeripheral tileEntity;
                    ITurtleAccess turtle = ReflectionHelper.getTurtle(message.world.func_175625_s(message.pos));
                    if (turtle != null && (tileEntity = turtle.getPeripheral(message.side)) != null) {
                        ((TileEntitySpeaker)tileEntity).onSpeechCompletion(message.text, message.eventId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

