/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.mount;

import dan200.computercraft.api.filesystem.IMount;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class DynamicMountExtra
implements IMount {
    private final Map<String, File> files;

    DynamicMountExtra(Map<String, File> files) {
        this.files = files;
    }

    private File getFile(String path) throws IOException {
        if (this.files.containsKey(path)) {
            return this.files.get(path);
        }
        throw new IOException(path);
    }

    public boolean exists(@Nonnull String path) throws IOException {
        if (path.equals("")) {
            return true;
        }
        try {
            this.getFile(path);
            return true;
        }
        catch (IOException e) {
            ArrayList<String> contents = new ArrayList<String>();
            String[] split = path.split("/");
            String previousPath = path.replace("/" + split[split.length - 1], "");
            if (previousPath.equals(path)) {
                previousPath = "";
            }
            this.list(previousPath, contents);
            for (String item : contents) {
                if (!path.endsWith(item)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isDirectory(@Nonnull String path) throws IOException {
        File file;
        try {
            file = this.getFile(path);
        }
        catch (IOException e) {
            return true;
        }
        return path.equals("") || file.isDirectory();
    }

    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        for (Map.Entry<String, File> file : this.files.entrySet()) {
            if (!file.getKey().startsWith(path)) continue;
            String name = file.getKey().replaceFirst(path, "");
            String[] nameSplit = name.split("/");
            if (nameSplit.length > 1 && nameSplit[0].equals("")) {
                if (nameSplit[1].equals(".")) continue;
                contents.add(nameSplit[1]);
                continue;
            }
            contents.add(nameSplit[0]);
        }
    }

    public long getSize(@Nonnull String path) throws IOException {
        return this.getFile(path).getTotalSpace();
    }

    @Nonnull
    public InputStream openForRead(@Nonnull String path) throws IOException {
        return new FileInputStream(this.getFile(path));
    }
}

