/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.items;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.capabilities.nano.CapabilityNanoBot;
import com.austinv11.peripheralsplusplus.capabilities.nano.NanoBotHolder;
import com.austinv11.peripheralsplusplus.entities.EntityNanoBotSwarm;
import com.austinv11.peripheralsplusplus.items.ItemPPP;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.TileEntityAntenna;
import java.util.UUID;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemNanoSwarm
extends ItemPPP {
    public ItemNanoSwarm() {
        this.func_77625_d(16);
        this.setRegistryName("nano_swarm");
        this.func_77655_b("nano_swarm");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (NBTHelper.hasTag((ItemStack)player.func_184586_b(hand), (String)"identifier")) {
            if (!world.field_72995_K) {
                EntityNanoBotSwarm swarm = new EntityNanoBotSwarm(world, (EntityLivingBase)player);
                swarm.antennaIdentifier = UUID.fromString(NBTHelper.getString((ItemStack)player.func_184586_b(hand), (String)"identifier"));
                if (NBTHelper.hasTag((ItemStack)player.func_184586_b(hand), (String)"label")) {
                    swarm.label = NBTHelper.getString((ItemStack)player.func_184586_b(hand), (String)"label");
                }
                swarm.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.1f, 6.0f);
                world.func_72838_d((Entity)swarm);
            }
            player.func_184586_b(hand).func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public static void addSwarmForEntity(EntityNanoBotSwarm swarm, Entity hit) {
        if (TileEntityAntenna.ANTENNA_REGISTRY.containsKey(swarm.antennaIdentifier)) {
            TileEntityAntenna antenna = TileEntityAntenna.ANTENNA_REGISTRY.get(swarm.antennaIdentifier);
            antenna.registerEntity(hit);
            NanoBotHolder properties = (NanoBotHolder)hit.getCapability(CapabilityNanoBot.INSTANCE, null);
            if (properties == null) {
                return;
            }
            properties.setBots(properties.getBots() + Config.numberOfInstructions);
            properties.setAntenna(swarm.antennaIdentifier);
        }
    }

    public static boolean doInstruction(UUID identifier, Entity performer, boolean allowIfDead, int cost) {
        TileEntityAntenna antenna;
        if ((!performer.field_70128_L || allowIfDead) && TileEntityAntenna.ANTENNA_REGISTRY.containsKey(identifier) && (antenna = TileEntityAntenna.ANTENNA_REGISTRY.get(identifier)).isEntityRegistered(performer)) {
            NanoBotHolder properties = (NanoBotHolder)performer.getCapability(CapabilityNanoBot.INSTANCE, null);
            if (properties == null || properties.getBots() < cost) {
                return false;
            }
            properties.setBots(properties.getBots() - cost);
            if (properties.getBots() <= 0) {
                antenna.removeEntity(performer);
            }
            return true;
        }
        return false;
    }

    public static class BehaviorNanoSwarm
    extends BehaviorDefaultDispenseItem {
        public ItemStack func_82487_b(IBlockSource blockSource, ItemStack stack) {
            EntityNanoBotSwarm iprojectile;
            EnumFacing enumfacing;
            World world;
            if (NBTHelper.hasTag((ItemStack)stack, (String)"identifier")) {
                world = blockSource.func_82618_k();
                IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)blockSource);
                enumfacing = (EnumFacing)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                iprojectile = new EntityNanoBotSwarm(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
                iprojectile.antennaIdentifier = UUID.fromString(NBTHelper.getString((ItemStack)stack, (String)"identifier"));
                if (NBTHelper.hasTag((ItemStack)stack, (String)"label")) {
                    iprojectile.label = NBTHelper.getString((ItemStack)stack, (String)"label");
                }
            } else {
                return super.func_82487_b(blockSource, stack);
            }
            iprojectile.func_70186_c(enumfacing.func_82601_c(), (float)enumfacing.func_96559_d() + 0.1f, enumfacing.func_82599_e(), 1.1f, 6.0f);
            world.func_72838_d((Entity)iprojectile);
            stack.func_77979_a(1);
            return stack;
        }
    }
}

