/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.init;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.pocket.PocketMotionDetector;
import com.austinv11.peripheralsplusplus.pocket.PocketPeripheralContainer;
import com.austinv11.peripheralsplusplus.pocket.PocketRfid;
import com.austinv11.peripheralsplusplus.turtles.TurtleBarrel;
import com.austinv11.peripheralsplusplus.turtles.TurtleChatBox;
import com.austinv11.peripheralsplusplus.turtles.TurtleChunkLoader;
import com.austinv11.peripheralsplusplus.turtles.TurtleCompass;
import com.austinv11.peripheralsplusplus.turtles.TurtleDispenser;
import com.austinv11.peripheralsplusplus.turtles.TurtleDropCollector;
import com.austinv11.peripheralsplusplus.turtles.TurtleEnvironmentScanner;
import com.austinv11.peripheralsplusplus.turtles.TurtleFeeder;
import com.austinv11.peripheralsplusplus.turtles.TurtleGarden;
import com.austinv11.peripheralsplusplus.turtles.TurtleOreDictionary;
import com.austinv11.peripheralsplusplus.turtles.TurtlePlayerSensor;
import com.austinv11.peripheralsplusplus.turtles.TurtleResupply;
import com.austinv11.peripheralsplusplus.turtles.TurtleRfid;
import com.austinv11.peripheralsplusplus.turtles.TurtleRidable;
import com.austinv11.peripheralsplusplus.turtles.TurtleShear;
import com.austinv11.peripheralsplusplus.turtles.TurtleSignReader;
import com.austinv11.peripheralsplusplus.turtles.TurtleSpeaker;
import com.austinv11.peripheralsplusplus.turtles.TurtleTank;
import com.austinv11.peripheralsplusplus.turtles.TurtleXP;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

public class ModPeripherals {
    public static final List<ITurtleUpgrade> TURTLE_UPGRADES = new ArrayList<ITurtleUpgrade>();
    public static final List<IPocketUpgrade> POCKET_UPGRADES = new ArrayList<IPocketUpgrade>();

    public static void registerInternally() {
        TURTLE_UPGRADES.add(new TurtleChatBox());
        TURTLE_UPGRADES.add(new TurtlePlayerSensor());
        TURTLE_UPGRADES.add(new TurtleCompass());
        TURTLE_UPGRADES.add(new TurtleXP());
        TURTLE_UPGRADES.add(new TurtleBarrel());
        TURTLE_UPGRADES.add(new TurtleOreDictionary());
        TURTLE_UPGRADES.add(new TurtleEnvironmentScanner());
        TURTLE_UPGRADES.add(new TurtleFeeder());
        TURTLE_UPGRADES.add(new TurtleShear());
        TURTLE_UPGRADES.add(new TurtleSignReader());
        TURTLE_UPGRADES.add(new TurtleGarden());
        TURTLE_UPGRADES.add(new TurtleSpeaker());
        TURTLE_UPGRADES.add(new TurtleTank());
        TURTLE_UPGRADES.add(new TurtleRidable());
        TURTLE_UPGRADES.add(new TurtleDispenser());
        TURTLE_UPGRADES.add(new TurtleResupply());
        TURTLE_UPGRADES.add(new TurtleChunkLoader());
        TURTLE_UPGRADES.add(new TurtleRfid());
        POCKET_UPGRADES.add(new PocketMotionDetector());
        POCKET_UPGRADES.add(new PocketPeripheralContainer());
        POCKET_UPGRADES.add(new PocketRfid());
    }

    public static void registerWithComputerCraft() {
        PeripheralsPlusPlus.LOGGER.info("Registering peripherals...");
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new IPlusPlusPeripheral.Provider());
        PeripheralsPlusPlus.LOGGER.info("Registering turtle upgrades...");
        for (ITurtleUpgrade upgrade : TURTLE_UPGRADES) {
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)upgrade);
            if (!(upgrade instanceof TurtleDropCollector)) continue;
            MinecraftForge.EVENT_BUS.register(((TurtleDropCollector)upgrade).newInstanceOfListener());
        }
        PeripheralsPlusPlus.LOGGER.info("Registering pocket computer upgrades...");
        for (IPocketUpgrade pocketUpgrade : POCKET_UPGRADES) {
            ComputerCraftAPI.registerPocketUpgrade((IPocketUpgrade)pocketUpgrade);
        }
    }
}

